/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.IntervalIntegerMap;
import org.gephi.graph.api.types.IntervalLongMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.IntervalStringMap;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.graph.api.types.TimestampIntegerMap;
import org.gephi.graph.api.types.TimestampLongMap;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.api.types.TimestampStringMap;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.plugin.file.spreadsheet.process.AbstractImportProcess;
import org.gephi.io.importer.plugin.file.spreadsheet.process.ImportAdjacencyListProcess;
import org.gephi.io.importer.plugin.file.spreadsheet.process.ImportEdgesProcess;
import org.gephi.io.importer.plugin.file.spreadsheet.process.ImportMatrixProcess;
import org.gephi.io.importer.plugin.file.spreadsheet.process.ImportNodesProcess;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetRow;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Exceptions;

public abstract class AbstractImporterSpreadsheet
implements FileImporter,
FileImporter.FileAware,
LongTask {
    private static final int MAX_ROWS_TO_ANALYZE_COLUMN_TYPES = 25;
    protected final SpreadsheetGeneralConfiguration generalConfig = new SpreadsheetGeneralConfiguration();
    protected ContainerLoader container;
    protected Report report;
    protected ProgressTicket progressTicket;
    protected boolean cancel = false;
    protected AbstractImportProcess importer = null;
    protected File file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        this.container.setTimeRepresentation(this.generalConfig.getTimeRepresentation());
        this.container.setTimeZone(this.generalConfig.getTimeZone());
        try (SheetParser parser = this.createParser();){
            switch (this.getMode()) {
                case NODES_TABLE: {
                    this.importer = new ImportNodesProcess(this.generalConfig, parser, container, this.progressTicket);
                    break;
                }
                case EDGES_TABLE: {
                    this.importer = new ImportEdgesProcess(this.generalConfig, parser, container, this.progressTicket);
                    break;
                }
                case ADJACENCY_LIST: {
                    this.importer = new ImportAdjacencyListProcess(this.generalConfig, container, this.progressTicket, parser);
                    break;
                }
                case MATRIX: {
                    this.importer = new ImportMatrixProcess(this.generalConfig, container, this.progressTicket, parser);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mode " + String.valueOf((Object)this.getMode()));
                }
            }
            this.importer.execute();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (this.importer != null) {
                this.report.append(this.importer.getReport());
                this.importer = null;
            }
        }
        return !this.cancel;
    }

    public abstract SheetParser createParser() throws IOException;

    public abstract SheetParser createParserWithoutHeaders() throws IOException;

    public Map<String, Integer> getHeadersMap() throws IOException {
        try (SheetParser parser = this.createParser();){
            Map<String, Integer> map = parser.getHeaderMap();
            return map;
        }
    }

    public List<SheetRow> getFirstRows(int maxRows) throws IOException {
        try (SheetParser parser = this.createParser();){
            List<SheetRow> list = this.getFirstRows(parser, maxRows);
            return list;
        }
    }

    public List<SheetRow> getFirstRows(SheetParser parser, int maxRows) throws IOException {
        ArrayList<SheetRow> rows = new ArrayList<SheetRow>();
        Iterator iterator = parser.iterator();
        for (int i = 0; i < maxRows && iterator.hasNext(); ++i) {
            rows.add((SheetRow)iterator.next());
        }
        return rows;
    }

    protected void autoDetectImportMode() {
        try {
            SheetParser parser = this.createParserWithoutHeaders();
            SpreadsheetGeneralConfiguration.Mode mode = null;
            Iterator iterator = parser.iterator();
            if (iterator.hasNext()) {
                SheetRow firstRow = (SheetRow)iterator.next();
                if (firstRow.get(0) == null || firstRow.get(0).trim().isEmpty()) {
                    mode = SpreadsheetGeneralConfiguration.Mode.MATRIX;
                } else {
                    String value;
                    int i;
                    for (i = 0; i < firstRow.size(); ++i) {
                        value = firstRow.get(i);
                        if (!"source".equalsIgnoreCase(value) && !"target".equalsIgnoreCase(value)) continue;
                        mode = SpreadsheetGeneralConfiguration.Mode.EDGES_TABLE;
                        break;
                    }
                    if (mode == null) {
                        for (i = 0; i < firstRow.size(); ++i) {
                            value = firstRow.get(i);
                            if (!"id".equalsIgnoreCase(value) && !"label".equalsIgnoreCase(value) && !"timeset".equalsIgnoreCase(value)) continue;
                            mode = SpreadsheetGeneralConfiguration.Mode.NODES_TABLE;
                        }
                    }
                }
            }
            if (mode == null) {
                mode = SpreadsheetGeneralConfiguration.Mode.ADJACENCY_LIST;
            }
            this.setMode(mode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void autoDetectColumnTypes() {
        try (SheetParser parser = this.createParser();){
            List<SheetRow> rows = this.getFirstRows(parser, 25);
            int rowCount = rows.size();
            if (rowCount == 0) {
                return;
            }
            Map<String, Integer> headerMap = parser.getHeaderMap();
            if (headerMap.isEmpty()) {
                return;
            }
            HashMap classMatchByHeader = new HashMap();
            List<Class> classesToTry = Arrays.asList(Boolean.class, Integer.class, Long.class, BigInteger.class, Double.class, BigDecimal.class, IntervalIntegerMap.class, IntervalLongMap.class, IntervalDoubleMap.class, IntervalStringMap.class, IntervalSet.class, TimestampIntegerMap.class, TimestampLongMap.class, TimestampDoubleMap.class, TimestampStringMap.class, TimestampSet.class);
            for (String column : headerMap.keySet()) {
                classMatchByHeader.put(column, new LinkedHashSet());
                ((LinkedHashSet)classMatchByHeader.get(column)).addAll(classesToTry);
            }
            for (SheetRow row : rows) {
                for (Map.Entry<String, Integer> entry : headerMap.entrySet()) {
                    String column = entry.getKey();
                    int index = entry.getValue();
                    String value = row.get(index);
                    if (value != null) {
                        value = value.trim();
                    }
                    LinkedHashSet columnMatches = (LinkedHashSet)classMatchByHeader.get(column);
                    for (Class clazz : classesToTry) {
                        if (!columnMatches.contains(clazz) || value == null || value.isEmpty()) continue;
                        if (clazz.equals(Boolean.class)) {
                            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) continue;
                            columnMatches.remove(clazz);
                            continue;
                        }
                        try {
                            Object parsed = clazz.equals(Integer.class) ? Integer.valueOf(Integer.parseInt(value)) : (clazz.equals(Long.class) ? Long.valueOf(Long.parseLong(value)) : (clazz.equals(BigInteger.class) ? new BigInteger(value) : (clazz.equals(Double.class) ? Double.valueOf(Double.parseDouble(value)) : (clazz.equals(BigDecimal.class) ? new BigDecimal(value) : AttributeUtils.parse((String)value, (Class)clazz)))));
                            if (parsed instanceof TimeMap && ((TimeMap)parsed).isEmpty()) {
                                parsed = null;
                            }
                            if (parsed instanceof TimeSet && ((TimeSet)parsed).isEmpty()) {
                                parsed = null;
                            }
                            if (parsed != null) continue;
                            columnMatches.remove(clazz);
                        }
                        catch (Exception parseError) {
                            columnMatches.remove(clazz);
                        }
                    }
                }
            }
            TimeRepresentation foundTimeRepresentation = TimeRepresentation.INTERVAL;
            for (String column : headerMap.keySet()) {
                LinkedHashSet columnMatches = (LinkedHashSet)classMatchByHeader.get(column);
                Class detectedClass = String.class;
                if (!columnMatches.isEmpty() && columnMatches.size() != classesToTry.size()) {
                    detectedClass = (Class<IntervalSet>)columnMatches.iterator().next();
                }
                if (column.equalsIgnoreCase("id") || column.equalsIgnoreCase("label")) {
                    detectedClass = String.class;
                }
                if (detectedClass.equals(String.class)) {
                    if (column.toLowerCase().contains("interval")) {
                        detectedClass = IntervalSet.class;
                    }
                    if (column.toLowerCase().contains("timestamp")) {
                        detectedClass = TimestampSet.class;
                    }
                    if (column.equalsIgnoreCase("timeset")) {
                        detectedClass = foundTimeRepresentation == TimeRepresentation.INTERVAL ? IntervalSet.class : TimestampSet.class;
                    }
                }
                if (this.getMode() == SpreadsheetGeneralConfiguration.Mode.EDGES_TABLE) {
                    if (column.equalsIgnoreCase("source") || column.equalsIgnoreCase("target") || column.equalsIgnoreCase("type") || column.equalsIgnoreCase("kind")) {
                        detectedClass = String.class;
                    }
                    if (column.equalsIgnoreCase("weight")) {
                        if (columnMatches.contains(Double.class)) {
                            detectedClass = Double.class;
                        } else if (columnMatches.contains(IntervalDoubleMap.class)) {
                            detectedClass = IntervalDoubleMap.class;
                        } else if (columnMatches.contains(TimestampDoubleMap.class)) {
                            detectedClass = TimestampDoubleMap.class;
                        }
                    }
                }
                this.setColumnClass(column, detectedClass);
                if (!TimestampSet.class.isAssignableFrom(detectedClass) && !TimestampMap.class.isAssignableFrom(detectedClass)) continue;
                foundTimeRepresentation = TimeRepresentation.TIMESTAMP;
            }
            this.setTimeRepresentation(foundTimeRepresentation);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void refreshAutoDetections() {
        this.autoDetectImportMode();
        this.autoDetectColumnTypes();
    }

    public void setReader(Reader reader) {
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        File previousFile = this.file;
        this.file = file;
        if (previousFile == null && file != null) {
            this.refreshAutoDetections();
        }
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        if (this.importer != null) {
            this.importer.cancel();
            this.importer = null;
        }
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public SpreadsheetGeneralConfiguration.Mode getMode() {
        return this.generalConfig.getMode();
    }

    public void setMode(SpreadsheetGeneralConfiguration.Mode table) {
        this.generalConfig.setTable(table);
    }

    public TimeRepresentation getTimeRepresentation() {
        return this.generalConfig.getTimeRepresentation();
    }

    public void setTimeRepresentation(TimeRepresentation timeRepresentation) {
        this.generalConfig.setTimeRepresentation(timeRepresentation);
    }

    public ZoneId getTimeZone() {
        return this.generalConfig.getTimeZone();
    }

    public void setTimeZone(ZoneId timeZone) {
        this.generalConfig.setTimeZone(timeZone);
    }

    public Map<String, Class> getColumnsClasses() {
        return this.generalConfig.getColumnsClasses();
    }

    public void setColumnsClasses(Map<String, Class> columnsClasses) {
        this.generalConfig.setColumnsClasses(columnsClasses);
    }

    public Class getColumnClass(String column) {
        return this.generalConfig.getColumnClass(column);
    }

    public void setColumnClass(String column, Class clazz) {
        this.generalConfig.setColumnClass(column, clazz);
    }
}

