/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.api.TimeIndex;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.impl.TableLockImpl;
import org.gephi.graph.impl.TimeIndexStore;

public abstract class TimeIndexImpl<T extends Element, K, S extends TimeSet<K>, M extends TimeMap<K, ?>>
implements TimeIndex<T> {
    protected final TableLockImpl lock;
    protected final TimeIndexStore<T, K, S, M> timestampIndexStore;
    protected final boolean mainIndex;
    protected TimeIndexEntry[] timestamps;
    protected int elementCount;

    protected TimeIndexImpl(TimeIndexStore<T, K, S, M> store, boolean main) {
        this.timestampIndexStore = store;
        this.mainIndex = main;
        this.timestamps = new TimeIndexEntry[0];
        this.lock = store.lock;
    }

    public boolean hasElements() {
        return this.elementCount > 0;
    }

    public void clear() {
        this.lock();
        this.timestamps = new TimeIndexEntry[0];
        this.elementCount = 0;
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(int timestampIndex, Element element) {
        this.lock();
        try {
            this.ensureArraySize(timestampIndex);
            TimeIndexEntry entry = this.timestamps[timestampIndex];
            if (entry == null) {
                entry = this.addTimestamp(timestampIndex);
            }
            if (entry.add(element)) {
                ++this.elementCount;
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int timestampIndex, Element element) {
        this.lock();
        try {
            TimeIndexEntry entry = this.timestamps[timestampIndex];
            if (entry.remove(element)) {
                --this.elementCount;
                if (entry.isEmpty()) {
                    this.clearEntry(timestampIndex);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    private TimeIndexEntry addTimestamp(int index) {
        TimeIndexEntry entry;
        this.ensureArraySize(index);
        this.timestamps[index] = entry = new TimeIndexEntry();
        return entry;
    }

    private void ensureArraySize(int index) {
        if (index >= this.timestamps.length) {
            TimeIndexEntry[] newArray = new TimeIndexEntry[index + 1];
            System.arraycopy(this.timestamps, 0, newArray, 0, this.timestamps.length);
            this.timestamps = newArray;
        }
    }

    private void clearEntry(int index) {
        this.timestamps[index] = null;
    }

    protected void checkDouble(double timestamp) {
        if (Double.isInfinite(timestamp) || Double.isNaN(timestamp)) {
            throw new IllegalArgumentException("Timestamp can' be NaN or infinity");
        }
    }

    protected void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    protected void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    protected static class TimeIndexEntry {
        protected final ObjectSet<Element> elementSet = new ObjectOpenHashSet();

        public boolean add(Element element) {
            return this.elementSet.add((Object)element);
        }

        public boolean remove(Element element) {
            return this.elementSet.remove((Object)element);
        }

        public boolean isEmpty() {
            return this.elementSet.isEmpty();
        }
    }

    protected class ElementSetWrapperIterable
    implements ElementIterable {
        protected final Set<Element> set;

        public ElementSetWrapperIterable(Set<Element> set) {
            this.set = set;
        }

        @Override
        public Iterator<Element> iterator() {
            return this.set.iterator();
        }

        public Element[] toArray() {
            return this.set.toArray(new Element[0]);
        }

        public Collection<Element> toCollection() {
            return this.set;
        }

        public Set<Element> toSet() {
            return this.set;
        }

        @Override
        public void doBreak() {
        }
    }
}

