/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.Iterator;
import java.util.Map;
import org.gephi.graph.api.Interval;

public class TimeAttributeIterable
implements Iterable<Map.Entry> {
    private static Iterator<Map.Entry> EMPTY_ITERATOR = new EmptyIterator();
    protected static Iterable<Map.Entry> EMPTY_ITERABLE = new Iterable<Map.Entry>(){

        @Override
        public Iterator<Map.Entry> iterator() {
            return EMPTY_ITERATOR;
        }
    };
    private final Interval[] intervals;
    private final double[] timestamps;
    private final Object[] values;

    public TimeAttributeIterable(double[] timestamps, Object[] values) {
        this.timestamps = timestamps;
        this.values = values;
        this.intervals = null;
    }

    public TimeAttributeIterable(Interval[] intervals, Object[] values) {
        this.intervals = intervals;
        this.values = values;
        this.timestamps = null;
    }

    @Override
    public Iterator<Map.Entry> iterator() {
        if (this.intervals != null) {
            return new IntervalAttributeIterator(this.intervals, this.values);
        }
        return new TimestampAttributeIterator(this.timestamps, this.values);
    }

    private static class IntervalAttributeIterator
    implements Iterator<Map.Entry> {
        private final IntervalEntry intervalEntry = new IntervalEntry();
        private final Interval[] intervals;
        private final Object[] values;
        private int index;

        public IntervalAttributeIterator(Interval[] intervals, Object[] values) {
            this.intervals = intervals;
            this.values = values;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.intervals.length;
        }

        @Override
        public Map.Entry<Interval, Object> next() {
            this.intervalEntry.interval = this.intervals[this.index];
            this.intervalEntry.value = this.values[this.index++];
            return this.intervalEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static class TimestampAttributeIterator
    implements Iterator<Map.Entry> {
        private final TimestampEntry timestampEntry = new TimestampEntry();
        private final double[] timestamps;
        private final Object[] values;
        private int index;

        public TimestampAttributeIterator(double[] timestamps, Object[] values) {
            this.timestamps = timestamps;
            this.values = values;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.timestamps.length;
        }

        @Override
        public Map.Entry<Double, Object> next() {
            this.timestampEntry.timestamp = this.timestamps[this.index];
            this.timestampEntry.value = this.values[this.index++];
            return this.timestampEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    protected static class EmptyIterator
    implements Iterator<Map.Entry> {
        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Map.Entry next() {
            throw new UnsupportedOperationException("Not supposed to call this for empty iterator.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supposed to call this for empty iterator.");
        }
    }

    private static class IntervalEntry
    implements Map.Entry<Interval, Object> {
        private Interval interval;
        private Object value;

        private IntervalEntry() {
        }

        @Override
        public Interval getKey() {
            return this.interval;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private static class TimestampEntry
    implements Map.Entry<Double, Object> {
        private double timestamp;
        private Object value;

        private TimestampEntry() {
        }

        @Override
        public Double getKey() {
            return this.timestamp;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

