/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.function.Predicate;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Rect2D;
import org.gephi.graph.api.SpatialIndex;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.NodesQuadTree;

public class SpatialIndexImpl
implements SpatialIndex {
    protected final NodesQuadTree nodesTree;

    public SpatialIndexImpl(GraphStore store) {
        float boundaries = 1000000.0f;
        this.nodesTree = new NodesQuadTree(store, new Rect2D(-boundaries / 2.0f, -boundaries / 2.0f, boundaries / 2.0f, boundaries / 2.0f));
    }

    @Override
    public NodeIterable getNodesInArea(Rect2D rect) {
        return this.nodesTree.getNodes(rect, false);
    }

    @Override
    public NodeIterable getApproximateNodesInArea(Rect2D rect) {
        return this.nodesTree.getNodes(rect, true);
    }

    @Override
    public EdgeIterable getEdgesInArea(Rect2D rect) {
        return this.nodesTree.getEdges(rect, false);
    }

    @Override
    public EdgeIterable getApproximateEdgesInArea(Rect2D rect) {
        return this.nodesTree.getEdges(rect, true);
    }

    @Override
    public void spatialIndexReadLock() {
        this.nodesTree.readLock();
    }

    @Override
    public void spatialIndexReadUnlock() {
        this.nodesTree.readUnlock();
    }

    @Override
    public NodeIterable getNodesInArea(Rect2D rect, Predicate<? super Node> predicate) {
        return this.nodesTree.getNodes(rect, false, predicate);
    }

    @Override
    public NodeIterable getApproximateNodesInArea(Rect2D rect, Predicate<? super Node> predicate) {
        return this.nodesTree.getNodes(rect, true, predicate);
    }

    @Override
    public EdgeIterable getEdgesInArea(Rect2D rect, Predicate<? super Edge> predicate) {
        return this.nodesTree.getEdges(rect, false, predicate);
    }

    @Override
    public EdgeIterable getApproximateEdgesInArea(Rect2D rect, Predicate<? super Edge> predicate) {
        return this.nodesTree.getEdges(rect, true, predicate);
    }

    protected void clearNodes() {
        this.nodesTree.clear();
    }

    protected void incrementVersion() {
        this.nodesTree.incrementVersion();
    }

    protected void addNode(NodeImpl node) {
        this.nodesTree.addNode(node);
    }

    protected void removeNode(NodeImpl node) {
        this.nodesTree.removeNode(node);
    }

    protected void moveNode(NodeImpl node) {
        float x = node.x();
        float y = node.y();
        float size = node.size();
        float minX = x - size;
        float minY = y - size;
        float maxX = x + size;
        float maxY = y + size;
        this.nodesTree.updateNode(node, minX, minY, maxX, maxY);
    }

    @Override
    public Rect2D getBoundaries() {
        return this.nodesTree.getBoundaries();
    }

    public Rect2D getBoundaries(Predicate<? super Node> predicate) {
        return this.nodesTree.getBoundaries(predicate);
    }

    public int getObjectCount() {
        return this.nodesTree.getObjectCount();
    }
}

