/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Rect2D;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.EdgeStore;
import org.gephi.graph.impl.GraphLockImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.SpatialNodeDataImpl;

public class NodesQuadTree {
    protected final GraphLockImpl lock = new GraphLockImpl();
    private final QuadTreeNode quadTreeRoot;
    private final int maxLevels;
    private final int maxObjectsPerNode;
    private final GraphStore graphStore;
    private int version = 0;

    public NodesQuadTree(Rect2D rect) {
        this(null, rect);
    }

    public NodesQuadTree(GraphStore store, Rect2D rect) {
        this(store, rect, 16, 8192);
    }

    public NodesQuadTree(GraphStore store, Rect2D rect, int maxLevels, int maxObjectsPerNode) {
        this.quadTreeRoot = new QuadTreeNode(rect);
        this.maxLevels = maxLevels;
        this.maxObjectsPerNode = maxObjectsPerNode;
        this.graphStore = store;
    }

    public Rect2D quadRect() {
        return this.quadTreeRoot.quadRect();
    }

    public NodeIterable getNodes(Rect2D searchRect) {
        return this.quadTreeRoot.getNodes(searchRect);
    }

    public NodeIterable getNodes(Rect2D searchRect, boolean approximate) {
        return this.quadTreeRoot.getNodes(searchRect, approximate);
    }

    public NodeIterable getNodes(Rect2D searchRect, boolean approximate, Predicate<? super Node> predicate) {
        return this.quadTreeRoot.getNodes(searchRect, approximate, predicate);
    }

    public NodeIterable getAllNodes() {
        return this.quadTreeRoot.getAllNodes();
    }

    public NodeIterable getAllNodes(Predicate<? super Node> predicate) {
        return this.quadTreeRoot.getAllNodes(predicate);
    }

    public EdgeIterable getEdges() {
        return this.quadTreeRoot.getAllEdges();
    }

    public EdgeIterable getEdges(Rect2D searchRect) {
        return this.quadTreeRoot.getEdges(searchRect);
    }

    public EdgeIterable getEdges(Rect2D searchRect, boolean approximate) {
        return this.quadTreeRoot.getEdges(searchRect, approximate);
    }

    public EdgeIterable getEdges(Rect2D searchRect, boolean approximate, Predicate<? super Edge> predicate) {
        return this.quadTreeRoot.getEdges(searchRect, approximate, predicate);
    }

    public void incrementVersion() {
        ++this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateNode(NodeImpl item, float minX, float minY, float maxX, float maxY) {
        this.writeLock();
        try {
            SpatialNodeDataImpl obj = item.getSpatialData();
            if (obj != null) {
                obj.updateBoundaries(minX, minY, maxX, maxY);
                this.quadTreeRoot.update(item);
                ++this.version;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(NodeImpl item) {
        this.writeLock();
        try {
            float x = item.x();
            float y = item.y();
            float size = item.size();
            float minX = x - size;
            float minY = y - size;
            float maxX = x + size;
            float maxY = y + size;
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            if (spatialData == null) {
                spatialData = new SpatialNodeDataImpl(minX, minY, maxX, maxY);
                item.setSpatialData(spatialData);
                this.quadTreeRoot.insert(item);
                ++this.version;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock();
        try {
            for (Node node : this.getAllNodes()) {
                SpatialNodeDataImpl spatialData = ((NodeImpl)node).getSpatialData();
                spatialData.clear();
            }
            this.quadTreeRoot.clear();
            ++this.version;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNode(NodeImpl item) {
        this.writeLock();
        try {
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            if (spatialData != null && spatialData.quadTreeNode != null) {
                this.quadTreeRoot.delete(item, true);
                ++this.version;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    public int getObjectCount() {
        this.readLock();
        int count = this.quadTreeRoot.objectCount();
        this.readUnlock();
        return count;
    }

    public void readLock() {
        if (this.lock != null) {
            this.lock.readLock();
        }
    }

    public void readUnlock() {
        if (this.lock != null) {
            this.lock.readUnlock();
        }
    }

    public void writeLock() {
        if (this.lock != null) {
            this.lock.writeLock();
        }
    }

    public void writeUnlock() {
        if (this.lock != null) {
            this.lock.writeUnlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.quadTreeRoot.toString(sb);
        return sb.toString();
    }

    public int getDepth() {
        this.readLock();
        int depth = this.quadTreeRoot.getDepth();
        this.readUnlock();
        return depth;
    }

    public int getNodeCount(boolean keepOnlyWithObjects) {
        this.readLock();
        int count = this.quadTreeRoot.getNodeCount(keepOnlyWithObjects);
        this.readUnlock();
        return count;
    }

    public Rect2D getBoundaries() {
        return this.getBoundaries(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rect2D getBoundaries(Predicate<? super Node> predicate) {
        this.readLock();
        try {
            NodeIterable allNodes = predicate == null ? this.getAllNodes() : this.getAllNodes(predicate);
            float minX = Float.POSITIVE_INFINITY;
            float minY = Float.POSITIVE_INFINITY;
            float maxX = Float.NEGATIVE_INFINITY;
            float maxY = Float.NEGATIVE_INFINITY;
            boolean hasNodes = false;
            for (Node node : allNodes) {
                SpatialNodeDataImpl spatialData;
                if (node == null || (spatialData = ((NodeImpl)node).getSpatialData()) == null) continue;
                hasNodes = true;
                if (spatialData.minX < minX) {
                    minX = spatialData.minX;
                }
                if (spatialData.minY < minY) {
                    minY = spatialData.minY;
                }
                if (spatialData.maxX > maxX) {
                    maxX = spatialData.maxX;
                }
                if (!(spatialData.maxY > maxY)) continue;
                maxY = spatialData.maxY;
            }
            Rect2D rect2D = hasNodes ? new Rect2D(minX, minY, maxX, maxY) : new Rect2D(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
            return rect2D;
        }
        finally {
            this.readUnlock();
        }
    }

    private int collectOverlapping(QuadTreeNode node, Rect2D searchRect, Set<QuadTreeNode> resultSet) {
        if (searchRect != null && !node.rect.intersects(searchRect)) {
            return 0;
        }
        int nodeCount = 0;
        if (node.objectCount > 0) {
            resultSet.add(node);
            nodeCount += node.objectCount;
        }
        if (node.childTL != null) {
            nodeCount += this.collectOverlapping(node.childTL, searchRect, resultSet);
            nodeCount += this.collectOverlapping(node.childTR, searchRect, resultSet);
            nodeCount += this.collectOverlapping(node.childBL, searchRect, resultSet);
            nodeCount += this.collectOverlapping(node.childBR, searchRect, resultSet);
        }
        return nodeCount;
    }

    protected class QuadTreeNode {
        private NodeImpl[] objects = null;
        private int objectCount = 0;
        private final Rect2D rect;
        private final QuadTreeNode parent;
        private final int level;
        private int size = 0;
        private QuadTreeNode childTL = null;
        private QuadTreeNode childTR = null;
        private QuadTreeNode childBL = null;
        private QuadTreeNode childBR = null;

        public Rect2D quadRect() {
            return this.rect;
        }

        public QuadTreeNode topLeftChild() {
            return this.childTL;
        }

        public QuadTreeNode topRightChild() {
            return this.childTR;
        }

        public QuadTreeNode bottomLeftChild() {
            return this.childBL;
        }

        public QuadTreeNode bottomRightChild() {
            return this.childBR;
        }

        public QuadTreeNode parent() {
            return this.parent;
        }

        public int count() {
            return this.size;
        }

        public boolean isEmptyLeaf() {
            return this.size == 0 && this.childTL == null;
        }

        public QuadTreeNode(Rect2D rect) {
            this(null, 0, rect);
        }

        private QuadTreeNode(QuadTreeNode parent, int level, Rect2D rect) {
            this.level = level;
            this.rect = rect;
            this.parent = parent;
        }

        private void add(NodeImpl item) {
            if (this.objects == null) {
                this.objects = new NodeImpl[NodesQuadTree.this.maxObjectsPerNode / 16];
            }
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            if (spatialData.quadTreeNode == this && spatialData.arrayIndex >= 0) {
                return;
            }
            if (this.objectCount >= this.objects.length) {
                NodeImpl[] newArray = new NodeImpl[this.objects.length * 2];
                System.arraycopy(this.objects, 0, newArray, 0, this.objects.length);
                this.objects = newArray;
            }
            this.objects[this.objectCount] = item;
            spatialData.setQuadTreeNode(this);
            spatialData.setArrayIndex(this.objectCount);
            ++this.objectCount;
            QuadTreeNode node = this;
            while (node != null) {
                ++node.size;
                node = node.parent;
            }
        }

        private void remove(NodeImpl item) {
            if (this.objects != null && this.objectCount > 0) {
                SpatialNodeDataImpl spatialData = item.getSpatialData();
                int index = spatialData.arrayIndex;
                if (index >= 0 && index < this.objectCount && this.objects[index] == item) {
                    NodeImpl lastItem;
                    --this.objectCount;
                    this.objects[index] = lastItem = this.objects[this.objectCount];
                    this.objects[this.objectCount] = null;
                    if (lastItem != null && index < this.objectCount) {
                        lastItem.getSpatialData().setArrayIndex(index);
                    }
                    spatialData.clear();
                    QuadTreeNode node = this;
                    while (node != null) {
                        --node.size;
                        node = node.parent;
                    }
                }
            }
        }

        private int objectCount() {
            return this.size;
        }

        private void subdivide() {
            int i;
            float minX = this.rect.minX;
            float halfX = (this.rect.minX + this.rect.maxX) / 2.0f;
            float maxX = this.rect.maxX;
            float minY = this.rect.minY;
            float halfY = (this.rect.minY + this.rect.maxY) / 2.0f;
            float maxY = this.rect.maxY;
            this.childTL = new QuadTreeNode(this, this.level + 1, new Rect2D(minX, minY, halfX, halfY));
            this.childTR = new QuadTreeNode(this, this.level + 1, new Rect2D(halfX, minY, maxX, halfY));
            this.childBL = new QuadTreeNode(this, this.level + 1, new Rect2D(minX, halfY, halfX, maxY));
            this.childBR = new QuadTreeNode(this, this.level + 1, new Rect2D(halfX, halfY, maxX, maxY));
            NodeImpl[] remainingObjects = new NodeImpl[this.objectCount];
            int remainingCount = 0;
            for (i = 0; i < this.objectCount; ++i) {
                NodeImpl obj = this.objects[i];
                QuadTreeNode destTree = this.getDestinationTree(obj);
                if (destTree != this) {
                    destTree.insert(obj);
                    QuadTreeNode node = this;
                    while (node != null) {
                        --node.size;
                        node = node.parent;
                    }
                    continue;
                }
                remainingObjects[remainingCount] = obj;
                obj.getSpatialData().setArrayIndex(remainingCount);
                ++remainingCount;
            }
            for (i = 0; i < remainingCount; ++i) {
                this.objects[i] = remainingObjects[i];
            }
            for (i = remainingCount; i < this.objectCount; ++i) {
                this.objects[i] = null;
            }
            this.objectCount = remainingCount;
        }

        private QuadTreeNode getDestinationTree(NodeImpl item) {
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            float minX = spatialData.minX;
            float minY = spatialData.minY;
            float maxX = spatialData.maxX;
            float maxY = spatialData.maxY;
            QuadTreeNode destTree = this.childTL.quadRect().contains(minX, minY, maxX, maxY) ? this.childTL : (this.childTR.quadRect().contains(minX, minY, maxX, maxY) ? this.childTR : (this.childBL.quadRect().contains(minX, minY, maxX, maxY) ? this.childBL : (this.childBR.quadRect().contains(minX, minY, maxX, maxY) ? this.childBR : this)));
            return destTree;
        }

        private void relocate(NodeImpl item) {
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            if (this.quadRect().contains(spatialData.minX, spatialData.minY, spatialData.maxX, spatialData.maxY)) {
                QuadTreeNode dest;
                if (this.childTL != null && spatialData.quadTreeNode != (dest = this.getDestinationTree(item))) {
                    QuadTreeNode formerOwner = spatialData.quadTreeNode;
                    this.delete(item, false);
                    dest.insert(item);
                    formerOwner.cleanUpwards();
                }
            } else if (this.parent != null) {
                this.parent.relocate(item);
            }
        }

        private void cleanUpwards() {
            if (this.childTL != null) {
                if (this.childTL.isEmptyLeaf() && this.childTR.isEmptyLeaf() && this.childBL.isEmptyLeaf() && this.childBR.isEmptyLeaf()) {
                    this.childTL = null;
                    this.childTR = null;
                    this.childBL = null;
                    this.childBR = null;
                    if (this.parent != null && this.count() == 0) {
                        this.parent.cleanUpwards();
                    }
                }
            } else if (this.parent != null && this.count() == 0) {
                this.parent.cleanUpwards();
            }
        }

        private void clear() {
            if (this.childTL != null) {
                this.childTL.clear();
                this.childTR.clear();
                this.childBL.clear();
                this.childBR.clear();
            }
            if (this.objects != null) {
                for (int i = 0; i < this.objectCount; ++i) {
                    if (this.objects[i] == null) continue;
                    SpatialNodeDataImpl spatialData = this.objects[i].getSpatialData();
                    spatialData.clear();
                    this.objects[i] = null;
                }
                this.objects = null;
                this.objectCount = 0;
            }
            this.size = 0;
            this.childTL = null;
            this.childTR = null;
            this.childBL = null;
            this.childBR = null;
        }

        private void delete(NodeImpl node, boolean clean) {
            SpatialNodeDataImpl spatialData = node.getSpatialData();
            if (spatialData.quadTreeNode != null) {
                if (spatialData.quadTreeNode == this) {
                    this.remove(node);
                    if (clean) {
                        this.cleanUpwards();
                    }
                } else {
                    spatialData.quadTreeNode.delete(node, clean);
                }
            }
        }

        private void insert(NodeImpl item) {
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            if (!this.rect.contains(spatialData.minX, spatialData.minY, spatialData.maxX, spatialData.maxY)) {
                if (this.parent == null) {
                    this.add(item);
                } else {
                    throw new IllegalStateException("We are not the root, and this object doesn't fit here. How did we get here?");
                }
            }
            if (this.objects == null || this.childTL == null && (this.level >= NodesQuadTree.this.maxLevels || this.objectCount + 1 <= NodesQuadTree.this.maxObjectsPerNode)) {
                this.add(item);
            } else {
                QuadTreeNode destTree;
                if (this.childTL == null) {
                    this.subdivide();
                }
                if ((destTree = this.getDestinationTree(item)) == this) {
                    this.add(item);
                } else {
                    destTree.insert(item);
                }
            }
        }

        private NodeIterable getNodes(Rect2D searchRect) {
            return new QuadTreeNodesIterable(searchRect);
        }

        private NodeIterable getNodes(Rect2D searchRect, boolean approximate) {
            return new QuadTreeNodesIterable(searchRect, approximate);
        }

        private NodeIterable getNodes(Rect2D searchRect, boolean approximate, Predicate<? super Node> predicate) {
            return new FilteredQuadTreeNodeIterable(searchRect, approximate, predicate);
        }

        private NodeIterable getAllNodes() {
            return new QuadTreeNodesIterable(null);
        }

        private NodeIterable getAllNodes(Predicate<? super Node> predicate) {
            return new FilteredQuadTreeNodeIterable(null, false, predicate);
        }

        private EdgeIterable getEdges(Rect2D searchRect) {
            return new QuadTreeEdgesIterable(searchRect);
        }

        private EdgeIterable getEdges(Rect2D searchRect, boolean approximate) {
            return new QuadTreeEdgesIterable(searchRect, approximate);
        }

        private EdgeIterable getEdges(Rect2D searchRect, boolean approximate, Predicate<? super Edge> predicate) {
            return new FilteredQuadTreeEdgeIterable(searchRect, approximate, predicate);
        }

        private EdgeIterable getAllEdges() {
            return new QuadTreeEdgesIterable(null);
        }

        private void update(NodeImpl item) {
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            if (spatialData.quadTreeNode != null) {
                spatialData.quadTreeNode.relocate(item);
            } else {
                this.relocate(item);
            }
        }

        private int getDepth() {
            int maxLevel = this.level;
            if (this.childTL != null) {
                maxLevel = Math.max(maxLevel, this.childTL.getDepth());
                maxLevel = Math.max(maxLevel, this.childBR.getDepth());
                maxLevel = Math.max(maxLevel, this.childTR.getDepth());
                maxLevel = Math.max(maxLevel, this.childBL.getDepth());
            }
            return maxLevel;
        }

        private int getNodeCount(boolean withObjects) {
            int count = 1;
            if (withObjects && (this.objects == null || this.objectCount == 0)) {
                count = 0;
            }
            if (this.childTL != null) {
                count += this.childTL.getNodeCount(withObjects);
                count += this.childTR.getNodeCount(withObjects);
                count += this.childBL.getNodeCount(withObjects);
                count += this.childBR.getNodeCount(withObjects);
            }
            return count;
        }

        public void toString(StringBuilder sb) {
            for (int i = 0; i < this.level; ++i) {
                sb.append("  ");
            }
            sb.append(this.rect.toString()).append('\n');
            if (this.objects != null) {
                for (int j = 0; j <= this.level; ++j) {
                    sb.append("  ");
                }
                sb.append(this.objectCount).append(" objects \n");
            }
            if (this.childTL != null) {
                this.childTL.toString(sb);
                this.childTR.toString(sb);
                this.childBL.toString(sb);
                this.childBR.toString(sb);
            }
        }
    }

    protected class QuadTreeGlobalEdgesSpliterator
    implements Spliterator<Edge> {
        private final Rect2D searchRect;
        private final boolean approximate;
        private final Set<QuadTreeNode> overlappingQuadNodes;
        private final Spliterator<Edge> baseSpliterator;
        private final int expectedVersion;
        private final Predicate<? super Edge> additionalPredicate;

        public QuadTreeGlobalEdgesSpliterator(Rect2D searchRect, boolean approximate, Set<QuadTreeNode> overlappingQuadNodes, Predicate<? super Edge> additionalPredicate) {
            this.searchRect = searchRect;
            this.approximate = approximate;
            this.additionalPredicate = additionalPredicate;
            this.expectedVersion = NodesQuadTree.this.version;
            this.overlappingQuadNodes = overlappingQuadNodes;
            this.baseSpliterator = additionalPredicate == null ? (searchRect == null ? NodesQuadTree.this.graphStore.edgeStore.spliterator() : NodesQuadTree.this.graphStore.edgeStore.newFilteredSpliterator(this::shouldIncludeEdge)) : (searchRect == null ? NodesQuadTree.this.graphStore.edgeStore.newFilteredSpliterator(this::shouldIncludeEdgeAllWithPredicate) : NodesQuadTree.this.graphStore.edgeStore.newFilteredSpliterator(this::shouldIncludeEdge));
        }

        private QuadTreeGlobalEdgesSpliterator(Rect2D searchRect, boolean approximate, Set<QuadTreeNode> overlappingQuadNodes, Spliterator<Edge> baseSpliterator, int expectedVersion, Predicate<? super Edge> additionalPredicate) {
            this.searchRect = searchRect;
            this.approximate = approximate;
            this.overlappingQuadNodes = overlappingQuadNodes;
            this.baseSpliterator = baseSpliterator;
            this.expectedVersion = expectedVersion;
            this.additionalPredicate = additionalPredicate;
        }

        private boolean shouldIncludeEdgeAllWithPredicate(EdgeImpl edge) {
            this.checkForComodification();
            return this.additionalPredicate.test(edge);
        }

        private boolean shouldIncludeEdge(EdgeImpl edge) {
            this.checkForComodification();
            boolean spatialMatch = false;
            SpatialNodeDataImpl sourceSpatialData = edge.source.getSpatialData();
            SpatialNodeDataImpl targetSpatialData = edge.target.getSpatialData();
            if (sourceSpatialData != null && sourceSpatialData.quadTreeNode != null) {
                spatialMatch = this.overlappingQuadNodes.contains(sourceSpatialData.quadTreeNode);
            }
            if (!spatialMatch && targetSpatialData != null && targetSpatialData.quadTreeNode != null) {
                spatialMatch = this.overlappingQuadNodes.contains(targetSpatialData.quadTreeNode);
            }
            if (spatialMatch && (this.additionalPredicate == null || this.additionalPredicate.test(edge))) {
                if (this.approximate) {
                    return true;
                }
                boolean sourceIntersects = sourceSpatialData != null && this.searchRect.intersects(sourceSpatialData.minX, sourceSpatialData.minY, sourceSpatialData.maxX, sourceSpatialData.maxY);
                boolean targetIntersects = targetSpatialData != null && this.searchRect.intersects(targetSpatialData.minX, targetSpatialData.minY, targetSpatialData.maxX, targetSpatialData.maxY);
                return sourceIntersects || targetIntersects;
            }
            return false;
        }

        private void checkForComodification() {
            if (this.expectedVersion != NodesQuadTree.this.version) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Edge> action) {
            return this.baseSpliterator.tryAdvance(action);
        }

        @Override
        public Spliterator<Edge> trySplit() {
            Spliterator<Edge> splitBase = this.baseSpliterator.trySplit();
            if (splitBase == null) {
                return null;
            }
            return new QuadTreeGlobalEdgesSpliterator(this.searchRect, this.approximate, this.overlappingQuadNodes, splitBase, this.expectedVersion, this.additionalPredicate);
        }

        @Override
        public long estimateSize() {
            return this.baseSpliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.baseSpliterator.characteristics();
        }
    }

    private class FilteredQuadTreeEdgesSpliterator
    extends FilteredSpliterator<Edge, QuadTreeEdgesSpliterator, FilteredQuadTreeEdgesSpliterator> {
        public FilteredQuadTreeEdgesSpliterator(QuadTreeNode root, Rect2D searchRect, boolean approximate, Predicate<? super Edge> predicate) {
            super(new QuadTreeEdgesSpliterator(root, searchRect, approximate), predicate);
        }

        private FilteredQuadTreeEdgesSpliterator(QuadTreeEdgesSpliterator parentSpliterator, Predicate<? super Edge> predicate) {
            super(parentSpliterator, predicate);
        }

        @Override
        protected FilteredQuadTreeEdgesSpliterator createSplitInstance(QuadTreeEdgesSpliterator splitParent, Predicate<? super Edge> predicate) {
            return new FilteredQuadTreeEdgesSpliterator(splitParent, predicate);
        }

        @Override
        protected boolean testPredicate(Edge element) {
            return this.predicate == null || this.predicate.test(element);
        }
    }

    private class QuadTreeEdgesSpliterator
    extends AbstractQuadTreeSpliterator<Edge> {
        public QuadTreeEdgesSpliterator(QuadTreeNode root, Rect2D searchRect) {
            this(root, searchRect, false);
        }

        public QuadTreeEdgesSpliterator(QuadTreeNode root, Rect2D searchRect, boolean approximate) {
            super(root, searchRect, approximate);
        }

        private QuadTreeEdgesSpliterator(QuadTreeNode node, Rect2D searchRect, boolean approximate, int expectedVersion, boolean fullyContained, int size) {
            super(node, searchRect, approximate, expectedVersion, fullyContained, size);
        }

        @Override
        protected Iterator<?> createIteratorForNode(QuadTreeNode node) {
            if (node.objects == null) {
                return Collections.emptyIterator();
            }
            return NodesQuadTree.this.graphStore.edgeStore.edgeIterator(new ArrayIterator(node.objects, node.objectCount), false);
        }

        @Override
        protected boolean checkElementSpatialMatch(Object element) {
            Edge edge = (Edge)element;
            if (this.approximate || this.currentFullyContained || this.searchRect == null) {
                return true;
            }
            Node source = edge.getSource();
            Node target = edge.getTarget();
            SpatialNodeDataImpl sourceSpatialData = ((NodeImpl)source).getSpatialData();
            SpatialNodeDataImpl targetSpatialData = ((NodeImpl)target).getSpatialData();
            return sourceSpatialData != null && this.searchRect.intersects(sourceSpatialData.minX, sourceSpatialData.minY, sourceSpatialData.maxX, sourceSpatialData.maxY) || targetSpatialData != null && this.searchRect.intersects(targetSpatialData.minX, targetSpatialData.minY, targetSpatialData.maxX, targetSpatialData.maxY);
        }

        @Override
        protected AbstractQuadTreeSpliterator<Edge> createSplitInstance(QuadTreeNode node, Rect2D searchRect, boolean approximate, int expectedVersion, boolean fullyContained, int size) {
            return new QuadTreeEdgesSpliterator(node, searchRect, approximate, expectedVersion, fullyContained, size);
        }

        @Override
        protected boolean findNext() {
            while (this.currentIterator != null || !this.nodesStack.isEmpty()) {
                if (this.currentIterator != null) {
                    if (this.currentIterator.hasNext()) {
                        Edge edge = (Edge)this.currentIterator.next();
                        if (!this.checkElementSpatialMatch(edge)) continue;
                        this.next = edge;
                        return true;
                    }
                    this.currentIterator = null;
                    continue;
                }
                QuadTreeNode pointer = (QuadTreeNode)this.nodesStack.pop();
                boolean bl = this.currentFullyContained = (Boolean)this.fullyContainedStack.pop() != false || this.searchRect != null && this.searchRect.contains(pointer.rect);
                if (!this.currentFullyContained && this.searchRect != null && !pointer.rect.intersects(this.searchRect)) continue;
                this.addNode(pointer, this.currentFullyContained);
                this.currentIterator = this.createIteratorForNode(pointer);
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 256;
        }
    }

    private class FilteredQuadTreeNodesSpliterator
    extends FilteredSpliterator<Node, QuadTreeNodesSpliterator, FilteredQuadTreeNodesSpliterator> {
        public FilteredQuadTreeNodesSpliterator(QuadTreeNode root, Rect2D searchRect, boolean approximate, Predicate<? super Node> predicate) {
            super(new QuadTreeNodesSpliterator(root, searchRect, approximate), predicate);
        }

        private FilteredQuadTreeNodesSpliterator(QuadTreeNodesSpliterator parentSpliterator, Predicate<? super Node> predicate) {
            super(parentSpliterator, predicate);
        }

        @Override
        protected FilteredQuadTreeNodesSpliterator createSplitInstance(QuadTreeNodesSpliterator splitParent, Predicate<? super Node> predicate) {
            return new FilteredQuadTreeNodesSpliterator(splitParent, predicate);
        }

        @Override
        protected boolean testPredicate(Node element) {
            return this.predicate == null || this.predicate.test(element);
        }
    }

    private static abstract class FilteredSpliterator<T, S extends Spliterator<T>, P extends Spliterator<T>>
    implements Spliterator<T> {
        protected final S parentSpliterator;
        protected final Predicate<? super T> predicate;
        protected final Object[] holder = new Object[1];

        protected FilteredSpliterator(S parentSpliterator, Predicate<? super T> predicate) {
            this.parentSpliterator = parentSpliterator;
            this.predicate = predicate;
        }

        protected abstract P createSplitInstance(S var1, Predicate<? super T> var2);

        protected abstract boolean testPredicate(T var1);

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Object t;
            do {
                boolean advanced;
                if (advanced = this.parentSpliterator.tryAdvance(e -> {
                    this.holder[0] = e;
                })) continue;
                return false;
            } while (!this.testPredicate(t = this.holder[0]));
            action.accept(t);
            return true;
        }

        @Override
        public Spliterator<T> trySplit() {
            Spliterator splitParent = this.parentSpliterator.trySplit();
            if (splitParent != null) {
                return this.createSplitInstance(splitParent, this.predicate);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.parentSpliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.parentSpliterator.characteristics() & 0xFFFFBFBF;
        }
    }

    private class QuadTreeNodesSpliterator
    extends AbstractQuadTreeSpliterator<Node> {
        public QuadTreeNodesSpliterator(QuadTreeNode root, Rect2D searchRect, boolean approximate) {
            super(root, searchRect, approximate);
        }

        private QuadTreeNodesSpliterator(QuadTreeNode node, Rect2D searchRect, boolean approximate, int expectedVersion, boolean fullyContained, int size) {
            super(node, searchRect, approximate, expectedVersion, fullyContained, size);
        }

        @Override
        protected Iterator<?> createIteratorForNode(QuadTreeNode node) {
            return node.objects != null ? new ArrayIterator(node.objects, node.objectCount) : null;
        }

        @Override
        protected boolean checkElementSpatialMatch(Object element) {
            NodeImpl elem = (NodeImpl)element;
            if (this.approximate || this.currentFullyContained || this.searchRect == null) {
                return true;
            }
            SpatialNodeDataImpl spatialData = elem.getSpatialData();
            return this.searchRect.intersects(spatialData.minX, spatialData.minY, spatialData.maxX, spatialData.maxY);
        }

        @Override
        protected AbstractQuadTreeSpliterator<Node> createSplitInstance(QuadTreeNode node, Rect2D searchRect, boolean approximate, int expectedVersion, boolean fullyContained, int size) {
            return new QuadTreeNodesSpliterator(node, searchRect, approximate, expectedVersion, fullyContained, size);
        }

        @Override
        protected boolean findNext() {
            while (this.currentIterator != null || !this.nodesStack.isEmpty()) {
                if (this.currentIterator != null) {
                    while (this.currentIterator.hasNext()) {
                        NodeImpl elem = (NodeImpl)this.currentIterator.next();
                        if (!this.checkElementSpatialMatch(elem)) continue;
                        this.next = elem;
                        return true;
                    }
                    this.currentIterator = null;
                    continue;
                }
                QuadTreeNode pointer = (QuadTreeNode)this.nodesStack.pop();
                boolean bl = this.currentFullyContained = (Boolean)this.fullyContainedStack.pop() != false || this.searchRect != null && this.searchRect.contains(pointer.rect);
                if (!this.currentFullyContained && this.searchRect != null && !pointer.rect.intersects(this.searchRect)) continue;
                this.addNode(pointer, this.currentFullyContained);
                this.currentIterator = this.createIteratorForNode(pointer);
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 16705;
        }
    }

    private abstract class AbstractQuadTreeSpliterator<T>
    implements Spliterator<T> {
        protected final Rect2D searchRect;
        protected final boolean approximate;
        protected final Deque<QuadTreeNode> nodesStack = new ArrayDeque<QuadTreeNode>();
        protected final Deque<Boolean> fullyContainedStack = new ArrayDeque<Boolean>();
        protected final int expectedVersion;
        protected Iterator<?> currentIterator;
        protected boolean currentFullyContained;
        protected T next;
        protected int remainingSize;

        protected AbstractQuadTreeSpliterator(QuadTreeNode root, Rect2D searchRect, boolean approximate) {
            this.searchRect = searchRect;
            this.approximate = approximate;
            this.expectedVersion = NodesQuadTree.this.version;
            this.currentFullyContained = searchRect == null;
            this.addNode(root, this.currentFullyContained);
            this.currentIterator = this.createIteratorForNode(root);
            this.remainingSize = searchRect == null ? root.size : (approximate ? this.countNodesInRectApproximate(root, searchRect) : this.countNodesInRect(root, searchRect));
        }

        protected AbstractQuadTreeSpliterator(QuadTreeNode node, Rect2D searchRect, boolean approximate, int expectedVersion, boolean fullyContained, int size) {
            this.searchRect = searchRect;
            this.approximate = approximate;
            this.expectedVersion = expectedVersion;
            this.remainingSize = size;
            this.currentFullyContained = fullyContained;
            if (node != null) {
                this.addNode(node, fullyContained);
                this.currentIterator = this.createIteratorForNode(node);
            } else {
                this.currentIterator = null;
            }
        }

        protected void checkForComodification() {
            if (NodesQuadTree.this.version != this.expectedVersion) {
                throw new ConcurrentModificationException();
            }
        }

        protected void addNode(QuadTreeNode node, boolean fullyContained) {
            if (node.childTL != null) {
                this.nodesStack.push(node.childBR);
                this.nodesStack.push(node.childBL);
                this.nodesStack.push(node.childTR);
                this.nodesStack.push(node.childTL);
                this.fullyContainedStack.push(fullyContained);
                this.fullyContainedStack.push(fullyContained);
                this.fullyContainedStack.push(fullyContained);
                this.fullyContainedStack.push(fullyContained);
            }
        }

        protected int countNodesInRect(QuadTreeNode node, Rect2D rect) {
            int count = 0;
            if (node.objects != null) {
                for (int i = 0; i < node.objectCount; ++i) {
                    NodeImpl obj = node.objects[i];
                    SpatialNodeDataImpl spatialData = obj.getSpatialData();
                    if (!rect.intersects(spatialData.minX, spatialData.minY, spatialData.maxX, spatialData.maxY)) continue;
                    ++count;
                }
            }
            if (node.childTL != null) {
                if (rect.contains(node.childTL.rect)) {
                    count += node.childTL.size;
                } else if (node.childTL.rect.intersects(rect)) {
                    count += this.countNodesInRect(node.childTL, rect);
                }
                if (rect.contains(node.childTR.rect)) {
                    count += node.childTR.size;
                } else if (node.childTR.rect.intersects(rect)) {
                    count += this.countNodesInRect(node.childTR, rect);
                }
                if (rect.contains(node.childBL.rect)) {
                    count += node.childBL.size;
                } else if (node.childBL.rect.intersects(rect)) {
                    count += this.countNodesInRect(node.childBL, rect);
                }
                if (rect.contains(node.childBR.rect)) {
                    count += node.childBR.size;
                } else if (node.childBR.rect.intersects(rect)) {
                    count += this.countNodesInRect(node.childBR, rect);
                }
            }
            return count;
        }

        protected int countNodesInRectApproximate(QuadTreeNode node, Rect2D rect) {
            int count = 0;
            if (node.objects != null) {
                count += node.objectCount;
            }
            if (node.childTL != null) {
                if (rect.containsOrIntersects(node.childTL.rect)) {
                    count += node.childTL.size;
                }
                if (rect.containsOrIntersects(node.childTR.rect)) {
                    count += node.childTR.size;
                }
                if (rect.containsOrIntersects(node.childBL.rect)) {
                    count += node.childBL.size;
                }
                if (rect.containsOrIntersects(node.childBR.rect)) {
                    count += node.childBR.size;
                }
            }
            return count;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            this.checkForComodification();
            if (this.next != null || this.findNext()) {
                action.accept(this.next);
                this.next = null;
                --this.remainingSize;
                return true;
            }
            return false;
        }

        protected abstract boolean findNext();

        protected abstract Iterator<?> createIteratorForNode(QuadTreeNode var1);

        protected abstract boolean checkElementSpatialMatch(Object var1);

        protected abstract AbstractQuadTreeSpliterator<T> createSplitInstance(QuadTreeNode var1, Rect2D var2, boolean var3, int var4, boolean var5, int var6);

        @Override
        public Spliterator<T> trySplit() {
            int nodesToSplit;
            this.checkForComodification();
            if (!this.nodesStack.isEmpty() && this.remainingSize > 1 && (nodesToSplit = Math.min(this.nodesStack.size() / 2, this.remainingSize / 2)) > 0) {
                ArrayDeque<QuadTreeNode> splitNodes = new ArrayDeque<QuadTreeNode>();
                ArrayDeque<Boolean> splitContained = new ArrayDeque<Boolean>();
                int splitSize = 0;
                for (int i = 0; i < nodesToSplit; ++i) {
                    QuadTreeNode node = this.nodesStack.removeLast();
                    boolean contained = this.fullyContainedStack.removeLast();
                    splitNodes.addFirst(node);
                    splitContained.addFirst(contained);
                    if (this.searchRect == null || contained) {
                        splitSize += node.size;
                        continue;
                    }
                    if (this.approximate) {
                        splitSize += this.countNodesInRectApproximate(node, this.searchRect);
                        continue;
                    }
                    splitSize += this.countNodesInRect(node, this.searchRect);
                }
                this.remainingSize -= splitSize;
                AbstractQuadTreeSpliterator<T> split = this.createSplitInstance(null, this.searchRect, this.approximate, this.expectedVersion, false, splitSize);
                while (!splitNodes.isEmpty()) {
                    split.nodesStack.push((QuadTreeNode)splitNodes.removeLast());
                    split.fullyContainedStack.push((Boolean)splitContained.removeLast());
                }
                return split;
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.remainingSize;
        }
    }

    private static class ArrayIterator
    implements Iterator<NodeImpl> {
        private final NodeImpl[] array;
        private final int size;
        private final Predicate<? super NodeImpl> predicate;
        private int index = 0;
        private NodeImpl next;

        public ArrayIterator(NodeImpl[] array, int size) {
            this(array, size, null);
        }

        public ArrayIterator(NodeImpl[] array, int size, Predicate<? super NodeImpl> predicate) {
            this.array = array;
            this.size = size;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.index < this.size) {
                NodeImpl candidate = this.array[this.index++];
                if (this.predicate != null && !this.predicate.test(candidate)) continue;
                this.next = candidate;
                return true;
            }
            return false;
        }

        @Override
        public NodeImpl next() {
            if (this.next == null && !this.hasNext()) {
                throw new IllegalStateException("No more elements");
            }
            NodeImpl result = this.next;
            this.next = null;
            return result;
        }
    }

    private class QuadTreeNodesIterator
    implements Iterator<Node> {
        private final Rect2D searchRect;
        private final boolean approximate;
        private final Predicate<? super Node> predicate;
        private final Deque<QuadTreeNode> nodesStack = new ArrayDeque<QuadTreeNode>();
        private final Deque<Boolean> fullyContainedStack = new ArrayDeque<Boolean>();
        private Iterator<NodeImpl> currentIterator;
        private boolean currentFullyContained;
        private boolean finished = false;
        private NodeImpl next;

        public QuadTreeNodesIterator(QuadTreeNode root, Rect2D searchRect, boolean approximate) {
            this(root, searchRect, approximate, null);
        }

        public QuadTreeNodesIterator(QuadTreeNode root, Rect2D searchRect, boolean approximate, Predicate<? super Node> predicate) {
            this.searchRect = searchRect;
            this.approximate = approximate;
            this.predicate = predicate;
            NodesQuadTree.this.readLock();
            this.currentFullyContained = searchRect == null;
            this.addChildrenToVisit(root, this.currentFullyContained);
            this.currentIterator = root.objects != null ? new ArrayIterator(root.objects, root.objectCount) : null;
        }

        private void addChildrenToVisit(QuadTreeNode quadTreeNode, boolean fullyContained) {
            if (quadTreeNode.childTL != null) {
                this.nodesStack.push(quadTreeNode.childBR);
                this.nodesStack.push(quadTreeNode.childBL);
                this.nodesStack.push(quadTreeNode.childTR);
                this.nodesStack.push(quadTreeNode.childTL);
                this.fullyContainedStack.push(fullyContained);
                this.fullyContainedStack.push(fullyContained);
                this.fullyContainedStack.push(fullyContained);
                this.fullyContainedStack.push(fullyContained);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.finished) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            while (this.currentIterator != null || !this.nodesStack.isEmpty()) {
                if (this.currentIterator != null) {
                    while (this.currentIterator.hasNext()) {
                        boolean spatialMatch;
                        NodeImpl elem = this.currentIterator.next();
                        if (this.approximate || this.currentFullyContained) {
                            spatialMatch = true;
                        } else {
                            SpatialNodeDataImpl spatialData = elem.getSpatialData();
                            spatialMatch = this.searchRect.intersects(spatialData.minX, spatialData.minY, spatialData.maxX, spatialData.maxY);
                        }
                        if (!spatialMatch || this.predicate != null && !this.predicate.test(elem)) continue;
                        this.next = elem;
                        return true;
                    }
                    this.currentIterator = null;
                    continue;
                }
                QuadTreeNode pointer = this.nodesStack.pop();
                boolean bl = this.currentFullyContained = this.fullyContainedStack.pop() != false || this.searchRect.contains(pointer.rect);
                if (this.currentFullyContained || pointer.rect.intersects(this.searchRect)) {
                    this.addChildrenToVisit(pointer, this.currentFullyContained);
                    this.currentIterator = pointer.objects != null ? new ArrayIterator(pointer.objects, pointer.objectCount) : null;
                    continue;
                }
                this.currentIterator = null;
            }
            NodesQuadTree.this.readUnlock();
            this.finished = true;
            return false;
        }

        @Override
        public NodeImpl next() {
            if (this.next == null) {
                throw new IllegalStateException("No next available!");
            }
            NodeImpl node = this.next;
            this.next = null;
            return node;
        }
    }

    private class QuadTreeEdgesIterator
    implements Iterator<Edge> {
        private final EdgeStore.EdgeInOutMultiIterator edgeIterator;
        private final Predicate<? super Edge> predicate;
        private boolean finished = false;
        private Edge next;

        public QuadTreeEdgesIterator(QuadTreeNode root, Rect2D searchRect, boolean approximate) {
            this(root, searchRect, approximate, null);
        }

        public QuadTreeEdgesIterator(QuadTreeNode root, Rect2D searchRect, boolean approximate, Predicate<? super Edge> predicate) {
            this.predicate = predicate;
            NodesQuadTree.this.readLock();
            final QuadTreeNodesIterator nodeIterator = new QuadTreeNodesIterator(root, searchRect, approximate);
            this.edgeIterator = NodesQuadTree.this.graphStore.edgeStore.edgeIterator(new Iterator<NodeImpl>(){

                @Override
                public boolean hasNext() {
                    return nodeIterator.hasNext();
                }

                @Override
                public NodeImpl next() {
                    return nodeIterator.next();
                }
            }, true);
        }

        @Override
        public boolean hasNext() {
            if (this.finished) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            while (this.edgeIterator != null && this.edgeIterator.hasNext()) {
                EdgeImpl edge = this.edgeIterator.next();
                if (this.predicate != null && !this.predicate.test(edge)) continue;
                this.next = edge;
                return true;
            }
            NodesQuadTree.this.readUnlock();
            this.finished = true;
            return false;
        }

        @Override
        public Edge next() {
            if (this.next == null && !this.hasNext()) {
                throw new IllegalStateException("No next available!");
            }
            Edge result = this.next;
            this.next = null;
            return result;
        }
    }

    private class QuadTreeEdgesIterable
    implements EdgeIterable {
        protected final Rect2D searchRect;
        protected final boolean approximate;

        public QuadTreeEdgesIterable(Rect2D searchRect) {
            this(searchRect, false);
        }

        public QuadTreeEdgesIterable(Rect2D searchRect, boolean approximate) {
            this.searchRect = searchRect;
            this.approximate = approximate;
        }

        @Override
        public Iterator<Edge> iterator() {
            return new QuadTreeEdgesIterator(NodesQuadTree.this.quadTreeRoot, this.searchRect, this.approximate);
        }

        protected boolean useDirectIterator(int nodeCount) {
            return (float)nodeCount / (float)NodesQuadTree.this.quadTreeRoot.size > 0.3f;
        }

        @Override
        public Spliterator<Edge> spliterator() {
            if (this.searchRect == null) {
                return new QuadTreeGlobalEdgesSpliterator(null, this.approximate, null, null);
            }
            HashSet<QuadTreeNode> overlappingNodes = new HashSet<QuadTreeNode>();
            int nodeCount = NodesQuadTree.this.collectOverlapping(NodesQuadTree.this.quadTreeRoot, this.searchRect, overlappingNodes);
            if (this.approximate && nodeCount == NodesQuadTree.this.quadTreeRoot.size) {
                return new QuadTreeGlobalEdgesSpliterator(null, true, null, null);
            }
            if (this.useDirectIterator(nodeCount)) {
                return new QuadTreeGlobalEdgesSpliterator(this.searchRect, this.approximate, overlappingNodes, null);
            }
            return new QuadTreeEdgesSpliterator(NodesQuadTree.this.quadTreeRoot, this.searchRect, this.approximate);
        }

        @Override
        public Edge[] toArray() {
            return this.toCollection().toArray(new Edge[0]);
        }

        @Override
        public Collection<Edge> toCollection() {
            ArrayList<Edge> list = new ArrayList<Edge>();
            for (Edge edge : this) {
                list.add(edge);
            }
            return list;
        }

        @Override
        public Set<Edge> toSet() {
            HashSet<Edge> set = new HashSet<Edge>();
            for (Edge edge : this) {
                set.add(edge);
            }
            return set;
        }

        @Override
        public void doBreak() {
            NodesQuadTree.this.readUnlock();
        }
    }

    private class FilteredQuadTreeEdgeIterable
    extends QuadTreeEdgesIterable {
        private final Predicate<? super Edge> predicate;

        public FilteredQuadTreeEdgeIterable(Rect2D searchRect, boolean approximate, Predicate<? super Edge> predicate) {
            super(searchRect, approximate);
            this.predicate = predicate;
        }

        @Override
        public Iterator<Edge> iterator() {
            return new QuadTreeEdgesIterator(NodesQuadTree.this.quadTreeRoot, this.searchRect, this.approximate, this.predicate);
        }

        @Override
        public Spliterator<Edge> spliterator() {
            HashSet<QuadTreeNode> overlappingNodes = new HashSet<QuadTreeNode>();
            int nodeCount = NodesQuadTree.this.collectOverlapping(NodesQuadTree.this.quadTreeRoot, this.searchRect, overlappingNodes);
            if (this.useDirectIterator(nodeCount)) {
                return new QuadTreeGlobalEdgesSpliterator(this.searchRect, this.approximate, overlappingNodes, this.predicate);
            }
            return new FilteredQuadTreeEdgesSpliterator(NodesQuadTree.this.quadTreeRoot, this.searchRect, this.approximate, this.predicate);
        }
    }

    private class QuadTreeNodesIterable
    implements NodeIterable {
        protected final Rect2D searchRect;
        protected final boolean approximate;

        public QuadTreeNodesIterable(Rect2D searchRect) {
            this(searchRect, false);
        }

        public QuadTreeNodesIterable(Rect2D searchRect, boolean approximate) {
            this.searchRect = searchRect;
            this.approximate = approximate;
        }

        @Override
        public Iterator<Node> iterator() {
            return new QuadTreeNodesIterator(NodesQuadTree.this.quadTreeRoot, this.searchRect, this.approximate);
        }

        @Override
        public Spliterator<Node> spliterator() {
            return new QuadTreeNodesSpliterator(NodesQuadTree.this.quadTreeRoot, this.searchRect, this.approximate);
        }

        @Override
        public Node[] toArray() {
            return this.toCollection().toArray(new Node[0]);
        }

        @Override
        public Collection<Node> toCollection() {
            ArrayList<Node> list = new ArrayList<Node>();
            for (Node node : this) {
                list.add(node);
            }
            return list;
        }

        @Override
        public Set<Node> toSet() {
            HashSet<Node> set = new HashSet<Node>();
            for (Node node : this) {
                set.add(node);
            }
            return set;
        }

        @Override
        public void doBreak() {
            NodesQuadTree.this.readUnlock();
        }
    }

    private class FilteredQuadTreeNodeIterable
    extends QuadTreeNodesIterable {
        private final Predicate<? super Node> predicate;

        public FilteredQuadTreeNodeIterable(Rect2D searchRect, boolean approximate, Predicate<? super Node> predicate) {
            super(searchRect, approximate);
            this.predicate = predicate;
        }

        @Override
        public Iterator<Node> iterator() {
            return new QuadTreeNodesIterator(NodesQuadTree.this.quadTreeRoot, this.searchRect, this.approximate, this.predicate);
        }

        @Override
        public Spliterator<Node> spliterator() {
            return new FilteredQuadTreeNodesSpliterator(NodesQuadTree.this.quadTreeRoot, this.searchRect, this.approximate, this.predicate);
        }
    }
}

