/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.impl.ElementIterableWrapper;
import org.gephi.graph.impl.GraphLockImpl;

public class NodeIterableWrapper
extends ElementIterableWrapper<Node>
implements NodeIterable {
    public NodeIterableWrapper(Supplier<Iterator<Node>> iteratorSupplier, GraphLockImpl lock) {
        super(iteratorSupplier, lock);
    }

    public NodeIterableWrapper(Supplier<Iterator<Node>> iteratorSupplier, Supplier<Spliterator<Node>> spliteratorSupplier, GraphLockImpl lock) {
        super(iteratorSupplier, spliteratorSupplier, lock);
    }

    @Override
    public Node[] toArray() {
        if (this.parallelPossible && this.lock != null) {
            this.lock.readLock();
            try {
                Node[] nodeArray = (Node[])StreamSupport.stream(this.spliterator(), true).toArray(Node[]::new);
                return nodeArray;
            }
            finally {
                this.lock.readUnlock();
            }
        }
        return (Node[])StreamSupport.stream(this.spliterator(), this.parallelPossible).toArray(Node[]::new);
    }
}

