/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnIndex;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Index;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnIndexImpl;
import org.gephi.graph.impl.ColumnNoIndexImpl;
import org.gephi.graph.impl.ColumnStandardIndexImpl;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.DefaultColumnsImpl;
import org.gephi.graph.impl.DegreeNoIndexImpl;
import org.gephi.graph.impl.EdgeTypeNoIndexImpl;

public class IndexImpl<T extends Element>
implements Index<T> {
    protected final ColumnStore<T> columnStore;
    protected final Graph graph;
    protected ColumnIndexImpl[] columns;
    protected int columnsCount;

    public IndexImpl(ColumnStore<T> columnStore) {
        this(columnStore, columnStore.graphStore);
    }

    public IndexImpl(ColumnStore<T> columnStore, Graph graph) {
        this.columnStore = columnStore;
        this.graph = graph;
        this.columns = new ColumnIndexImpl[0];
    }

    @Override
    public Class<T> getIndexClass() {
        return this.columnStore.elementType;
    }

    @Override
    public String getIndexName() {
        return "index_" + this.columnStore.elementType.getCanonicalName();
    }

    @Override
    public ColumnIndex getColumnIndex(Column column) {
        return this.getIndex(column);
    }

    @Override
    public int count(Column column, Object value) {
        this.checkNonNullColumnObject(column);
        ColumnIndexImpl index = this.getIndex(column);
        if (index != null) {
            return index.count(value);
        }
        return 0;
    }

    public int count(String key, Object value) {
        this.checkNonNullObject(key);
        return this.count(this.columnStore.getColumn(key), value);
    }

    @Override
    public Iterable<T> get(Column column, Object value) {
        this.checkNonNullColumnObject(column);
        ColumnIndexImpl index = this.getIndex(column);
        if (index != null) {
            return index.get(value);
        }
        return Collections.EMPTY_LIST;
    }

    public Iterable<T> get(String key, Object value) {
        this.checkNonNullObject(key);
        return this.get(this.columnStore.getColumn(key), value);
    }

    @Override
    public boolean isSortable(Column column) {
        this.checkNonNullColumnObject(column);
        ColumnIndexImpl index = this.getIndex(column);
        if (index != null) {
            return index.isSortable();
        }
        return false;
    }

    @Override
    public Number getMinValue(Column column) {
        this.checkNonNullColumnObject(column);
        ColumnIndexImpl index = this.getIndex(column);
        if (index != null) {
            return index.getMinValue();
        }
        return null;
    }

    @Override
    public Number getMaxValue(Column column) {
        this.checkNonNullColumnObject(column);
        ColumnIndexImpl index = this.getIndex(column);
        if (index != null) {
            return index.getMaxValue();
        }
        return null;
    }

    public Iterable<Map.Entry<Object, Set<T>>> get(Column column) {
        this.checkNonNullColumnObject(column);
        return this.getIndex(column);
    }

    @Override
    public Collection values(Column column) {
        this.checkNonNullColumnObject(column);
        ColumnIndexImpl index = this.getIndex(column);
        if (index != null) {
            return index.values();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public int countValues(Column column) {
        this.checkNonNullColumnObject(column);
        ColumnIndexImpl index = this.getIndex(column);
        if (index != null) {
            return index.countValues();
        }
        return 0;
    }

    @Override
    public int countElements(Column column) {
        this.checkNonNullColumnObject(column);
        ColumnIndexImpl index = this.getIndex(column);
        if (index != null) {
            return index.countElements();
        }
        return 0;
    }

    public Object put(String key, Object value, T element) {
        this.checkNonNullObject(key);
        return this.put(this.columnStore.getColumn(key), value, element);
    }

    public Object put(Column column, Object value, T element) {
        this.checkNonNullColumnObject(column);
        return this.getIndex(column).putValue(element, value);
    }

    public void remove(String key, Object value, T element) {
        this.checkNonNullObject(key);
        this.remove(this.columnStore.getColumn(key), value, element);
    }

    public void remove(Column column, Object value, T element) {
        this.checkNonNullColumnObject(column);
        this.getIndex(column).removeValue(element, value);
    }

    public Object set(String key, Object oldValue, Object value, T element) {
        this.checkNonNullObject(key);
        return this.set(this.columnStore.getColumn(key), oldValue, value, element);
    }

    public Object set(Column column, Object oldValue, Object value, T element) {
        this.checkNonNullColumnObject(column);
        return this.getIndex(column).replaceValue(element, oldValue, value);
    }

    public void clear() {
        for (ColumnIndexImpl ai : this.columns) {
            if (ai == null) continue;
            ai.clear();
        }
    }

    protected void addColumn(ColumnImpl col) {
        ColumnIndexImpl index;
        this.ensureColumnSize(col.storeId);
        this.columns[col.storeId] = index = this.createIndex(col);
        ++this.columnsCount;
    }

    protected void addAllColumns(ColumnImpl[] cols) {
        this.ensureColumnSize(cols.length);
        for (ColumnImpl col : cols) {
            ColumnIndexImpl index = this.createIndex(col);
            this.ensureColumnSize(col.storeId);
            this.columns[col.storeId] = index;
            ++this.columnsCount;
        }
    }

    protected void removeColumn(ColumnImpl col) {
        ColumnIndexImpl index = this.columns[col.storeId];
        index.destroy();
        this.columns[col.storeId] = null;
        --this.columnsCount;
    }

    protected boolean hasColumn(ColumnImpl col) {
        int id = col.storeId;
        return id != -1 && this.columns.length > id && this.columns[id].getColumn() == col;
    }

    protected ColumnIndexImpl getIndex(Column col) {
        ColumnIndexImpl index;
        int id = col.getIndex();
        if (id != -1 && this.columns.length > id && (index = this.columns[id]) != null && index.getColumn() == col) {
            return index;
        }
        if (col.isProperty()) {
            DefaultColumnsImpl defaultColumns = this.columnStore.graphStore.defaultColumns;
            if (col == defaultColumns.degreeColumn) {
                return new DegreeNoIndexImpl(this.graph, DegreeNoIndexImpl.DegreeType.DEGREE);
            }
            if (col == defaultColumns.inDegreeColumn) {
                return new DegreeNoIndexImpl(this.graph, DegreeNoIndexImpl.DegreeType.IN_DEGREE);
            }
            if (col == defaultColumns.outDegreeColumn) {
                return new DegreeNoIndexImpl(this.graph, DegreeNoIndexImpl.DegreeType.OUT_DEGREE);
            }
            if (col == defaultColumns.typeColumn) {
                return new EdgeTypeNoIndexImpl(this.graph);
            }
        }
        return null;
    }

    protected ColumnIndexImpl getIndex(String key) {
        return this.getIndex(this.columnStore.getColumn(key));
    }

    protected void destroy() {
        for (ColumnIndexImpl ai : this.columns) {
            if (ai == null) continue;
            ai.destroy();
        }
        this.columns = new ColumnIndexImpl[0];
        this.columnsCount = 0;
    }

    protected int size() {
        return this.columnsCount;
    }

    ColumnIndexImpl createIndex(ColumnImpl col) {
        return col.isIndexed() && ColumnStandardIndexImpl.isSupportedType(col) ? this.createStandardIndex(col) : this.createNoIndex(col, this.graph);
    }

    ColumnNoIndexImpl createNoIndex(ColumnImpl column, Graph graph) {
        return new ColumnNoIndexImpl(column, graph, this.columnStore.elementType);
    }

    ColumnStandardIndexImpl createStandardIndex(ColumnImpl column) {
        if (column.getTypeClass().equals(Byte.class)) {
            return new ColumnStandardIndexImpl.ByteStandardIndex(column);
        }
        if (column.getTypeClass().equals(Short.class)) {
            return new ColumnStandardIndexImpl.ShortStandardIndex(column);
        }
        if (column.getTypeClass().equals(Integer.class)) {
            return new ColumnStandardIndexImpl.IntegerStandardIndex(column);
        }
        if (column.getTypeClass().equals(Long.class)) {
            return new ColumnStandardIndexImpl.LongStandardIndex(column);
        }
        if (column.getTypeClass().equals(Float.class)) {
            return new ColumnStandardIndexImpl.FloatStandardIndex(column);
        }
        if (column.getTypeClass().equals(Double.class)) {
            return new ColumnStandardIndexImpl.DoubleStandardIndex(column);
        }
        if (Number.class.isAssignableFrom(column.getTypeClass())) {
            return new ColumnStandardIndexImpl.GenericNumberStandardIndex(column);
        }
        if (column.getTypeClass().equals(Boolean.class)) {
            return new ColumnStandardIndexImpl.BooleanStandardIndex(column);
        }
        if (column.getTypeClass().equals(Character.class)) {
            return new ColumnStandardIndexImpl.CharStandardIndex(column);
        }
        if (column.getTypeClass().equals(String.class)) {
            return new ColumnStandardIndexImpl.DefaultStandardIndex(column);
        }
        if (column.getTypeClass().equals(byte[].class)) {
            return new ColumnStandardIndexImpl.ByteArrayStandardIndex(column);
        }
        if (column.getTypeClass().equals(short[].class)) {
            return new ColumnStandardIndexImpl.ShortArrayStandardIndex(column);
        }
        if (column.getTypeClass().equals(int[].class)) {
            return new ColumnStandardIndexImpl.IntegerArrayStandardIndex(column);
        }
        if (column.getTypeClass().equals(long[].class)) {
            return new ColumnStandardIndexImpl.LongArrayStandardIndex(column);
        }
        if (column.getTypeClass().equals(float[].class)) {
            return new ColumnStandardIndexImpl.FloatArrayStandardIndex(column);
        }
        if (column.getTypeClass().equals(double[].class)) {
            return new ColumnStandardIndexImpl.DoubleArrayStandardIndex(column);
        }
        if (column.getTypeClass().equals(boolean[].class)) {
            return new ColumnStandardIndexImpl.BooleanArrayStandardIndex(column);
        }
        if (column.getTypeClass().equals(char[].class)) {
            return new ColumnStandardIndexImpl.CharArrayStandardIndex(column);
        }
        if (column.getTypeClass().equals(String[].class)) {
            return new ColumnStandardIndexImpl.DefaultArrayStandardIndex(column);
        }
        if (column.getTypeClass().isArray()) {
            return new ColumnStandardIndexImpl.DefaultArrayStandardIndex(column);
        }
        return new ColumnStandardIndexImpl.DefaultStandardIndex(column);
    }

    private void ensureColumnSize(int index) {
        if (index >= this.columns.length) {
            ColumnIndexImpl[] newArray = new ColumnIndexImpl[index + 1];
            System.arraycopy(this.columns, 0, newArray, 0, this.columns.length);
            this.columns = newArray;
        }
    }

    void checkNonNullObject(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    void checkNonNullColumnObject(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof ColumnImpl)) {
            throw new ClassCastException("Must be ColumnImpl object");
        }
    }
}

