/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.function.Predicate;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Subgraph;
import org.gephi.graph.api.UndirectedSubgraph;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.GraphObserverImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphViewImpl;
import org.gephi.graph.impl.IndexStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.TimeIndexStore;

public class GraphViewStore {
    protected static final int NULL_VIEW = -1;
    protected static final int DEFAULT_VIEWS = 0;
    protected final IntSortedSet garbageQueue;
    protected final GraphStore graphStore;
    protected GraphViewImpl[] views;
    protected int length;
    protected GraphView visibleView;

    public GraphViewStore(GraphStore graphStore) {
        if (graphStore == null) {
            throw new NullPointerException();
        }
        this.graphStore = graphStore;
        this.views = new GraphViewImpl[0];
        this.garbageQueue = new IntRBTreeSet();
        this.visibleView = graphStore.mainGraphView;
    }

    public GraphViewImpl createView() {
        return this.createView(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphViewImpl createView(Predicate<Node> nodeFilter, Predicate<Edge> edgeFilter) {
        this.graphStore.autoWriteLock();
        try {
            GraphViewImpl graphView = new GraphViewImpl(this.graphStore, nodeFilter, edgeFilter);
            this.addView(graphView);
            GraphViewImpl graphViewImpl = graphView;
            return graphViewImpl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphViewImpl createView(boolean nodes, boolean edges) {
        this.graphStore.autoWriteLock();
        try {
            GraphViewImpl graphView = new GraphViewImpl(this.graphStore, nodes, edges);
            this.addView(graphView);
            GraphViewImpl graphViewImpl = graphView;
            return graphViewImpl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    public GraphViewImpl createView(GraphView view) {
        return this.createView(view, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphViewImpl createView(GraphView view, boolean nodes, boolean edges) {
        if (view.isMainView()) {
            this.graphStore.autoWriteLock();
            try {
                GraphViewImpl graphView = new GraphViewImpl(this.graphStore, nodes, edges);
                graphView.fill();
                this.addView(graphView);
                GraphViewImpl graphViewImpl = graphView;
                return graphViewImpl;
            }
            finally {
                this.graphStore.autoWriteUnlock();
            }
        }
        this.checkNonNullViewObject(view);
        this.checkGraphViewObject(view);
        this.checkViewExist((GraphViewImpl)view);
        this.graphStore.autoWriteLock();
        try {
            GraphViewImpl graphView = new GraphViewImpl((GraphViewImpl)view, nodes, edges);
            this.addView(graphView);
            GraphViewImpl graphViewImpl = graphView;
            return graphViewImpl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyView(GraphView view) {
        if (view.isMainView()) {
            throw new IllegalArgumentException("Can't delete the main view");
        }
        this.graphStore.autoWriteLock();
        try {
            IndexStore edgeIndexStore;
            IndexStore nodeIndexStore;
            TimeIndexStore edgeTimeStore;
            this.checkNonNullViewObject(view);
            this.checkGraphViewObject(view);
            TimeIndexStore nodeTimeStore = this.graphStore.timeStore.nodeIndexStore;
            if (nodeTimeStore != null) {
                nodeTimeStore.deleteViewIndex(((GraphViewImpl)view).getDirectedGraph());
            }
            if ((edgeTimeStore = this.graphStore.timeStore.edgeIndexStore) != null) {
                edgeTimeStore.deleteViewIndex(((GraphViewImpl)view).getDirectedGraph());
            }
            if ((nodeIndexStore = this.graphStore.nodeTable.store.indexStore) != null) {
                nodeIndexStore.deleteViewIndex(((GraphViewImpl)view).getDirectedGraph());
            }
            if ((edgeIndexStore = this.graphStore.edgeTable.store.indexStore) != null) {
                edgeIndexStore.deleteViewIndex(((GraphViewImpl)view).getDirectedGraph());
            }
            this.removeView((GraphViewImpl)view);
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeInterval(GraphView view, Interval interval) {
        this.checkNonNullViewObject(view);
        this.checkViewExist((GraphViewImpl)view);
        this.graphStore.autoWriteLock();
        try {
            GraphViewImpl graphView = (GraphViewImpl)view;
            graphView.setTimeInterval(interval);
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(GraphView view) {
        this.graphStore.autoReadLock();
        try {
            this.checkNonNullViewObject(view);
            GraphViewImpl viewImpl = (GraphViewImpl)view;
            int id = viewImpl.storeId;
            if (id != -1 && id < this.length && this.views[id] == view) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    public int size() {
        return this.length - this.garbageQueue.size();
    }

    public Subgraph getGraph(GraphView view) {
        this.checkNonNullViewObject(view);
        this.checkGraphViewObject(view);
        if (this.graphStore.isUndirected()) {
            if (view.isMainView()) {
                return this.graphStore.undirectedDecorator;
            }
            return ((GraphViewImpl)view).getUndirectedGraph();
        }
        if (view.isMainView()) {
            return this.graphStore;
        }
        return ((GraphViewImpl)view).getDirectedGraph();
    }

    public DirectedSubgraph getDirectedGraph(GraphView view) {
        this.checkNonNullViewObject(view);
        this.checkGraphViewObject(view);
        if (view.isMainView()) {
            return this.graphStore;
        }
        this.checkDirectedAllowed();
        return ((GraphViewImpl)view).getDirectedGraph();
    }

    public UndirectedSubgraph getUndirectedGraph(GraphView view) {
        this.checkNonNullViewObject(view);
        this.checkGraphViewObject(view);
        if (view.isMainView()) {
            return this.graphStore.undirectedDecorator;
        }
        return ((GraphViewImpl)view).getUndirectedGraph();
    }

    public GraphView getVisibleView() {
        return this.visibleView;
    }

    public void setVisibleView(GraphView view) {
        if (view == null || view == this.graphStore.mainGraphView) {
            this.visibleView = this.graphStore.mainGraphView;
        } else {
            this.checkNonNullViewObject(view);
            this.checkViewExist((GraphViewImpl)view);
            this.visibleView = view;
        }
    }

    public GraphObserverImpl createGraphObserver(Graph graph, boolean withDiff) {
        GraphViewImpl graphViewImpl = (GraphViewImpl)graph.getView();
        this.checkViewExist(graphViewImpl);
        return graphViewImpl.createGraphObserver(graph, withDiff);
    }

    public void destroyGraphObserver(GraphObserverImpl graphObserver) {
        GraphViewImpl graphViewImpl = (GraphViewImpl)graphObserver.graph.getView();
        if (graphObserver.graphStore != this.graphStore) {
            throw new RuntimeException("This observer doesn't belong to this store");
        }
        graphViewImpl.destroyGraphObserver(graphObserver);
    }

    protected void removeNode(NodeImpl node) {
        for (GraphViewImpl view : this.views) {
            if (view == null) continue;
            view.removeNode(node);
        }
    }

    protected void addEdge(EdgeImpl edge) {
        for (GraphViewImpl view : this.views) {
            if (view == null || !view.nodeView || view.edgeView) continue;
            view.addEdgeInNodeView(edge);
        }
    }

    protected void setEdgeType(EdgeImpl edge, int oldType, boolean wasMutual) {
        for (GraphViewImpl view : this.views) {
            if (view == null || (!view.nodeView || view.edgeView) && (!view.edgeView || !view.containsEdge(edge))) continue;
            view.setEdgeType(edge, oldType, wasMutual);
        }
    }

    protected void removeEdge(EdgeImpl edge) {
        for (GraphViewImpl view : this.views) {
            if (view == null) continue;
            view.removeEdge((Edge)edge);
        }
    }

    protected int addView(GraphViewImpl view) {
        int id;
        this.checkNonNullViewObject(view);
        if (!this.garbageQueue.isEmpty()) {
            id = this.garbageQueue.firstInt();
            this.garbageQueue.remove(id);
        } else {
            id = this.length++;
            this.ensureArraySize(id);
        }
        this.views[id] = view;
        view.storeId = id;
        return id;
    }

    protected void removeView(GraphViewImpl view) {
        this.checkViewExist(view);
        int id = view.storeId;
        this.views[id] = null;
        this.garbageQueue.add(id);
        view.storeId = -1;
        view.destroyAllObservers();
        if (this.visibleView == view) {
            this.visibleView = this.graphStore.mainGraphView;
        }
    }

    private void ensureArraySize(int index) {
        if (index >= this.views.length) {
            GraphViewImpl[] newArray = new GraphViewImpl[index + 1];
            System.arraycopy(this.views, 0, newArray, 0, this.views.length);
            this.views = newArray;
        }
    }

    public int deepHashCode() {
        int hash = 5;
        for (GraphViewImpl view : this.views) {
            hash = 67 * hash + view.deepHashCode();
        }
        hash = 67 * hash + this.length;
        return hash;
    }

    public boolean deepEquals(GraphViewStore obj) {
        if (obj == null) {
            return false;
        }
        if (this.length != obj.length) {
            return false;
        }
        int l = this.views.length;
        if (l != obj.views.length) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            GraphViewImpl e1 = this.views[i];
            GraphViewImpl e2 = obj.views[i];
            if (e1 == e2) continue;
            if (e1 == null) {
                return false;
            }
            if (e1.deepEquals(e2)) continue;
            return false;
        }
        return true;
    }

    protected void checkNonNullViewObject(GraphView o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    protected void checkGraphViewObject(GraphView o) {
        if (!o.isMainView() && !(o instanceof GraphViewImpl)) {
            throw new IllegalArgumentException("The view is not from this implementation");
        }
    }

    protected void checkViewExist(GraphViewImpl view) {
        int id = view.storeId;
        if (id == -1 || id >= this.length || this.views[id] != view) {
            throw new IllegalArgumentException("The view doesn't exist");
        }
    }

    private void checkDirectedAllowed() {
        if (this.graphStore.isUndirected()) {
            throw new RuntimeException("Can't get a directed subgraph from an undirected graph");
        }
    }
}

