/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import org.gephi.graph.api.Graph;
import org.gephi.graph.impl.GraphObserverImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphViewImpl;

public class GraphVersion {
    protected final Graph graph;
    protected int nodeVersion = -2147483647;
    protected int edgeVersion = -2147483647;

    public GraphVersion(Graph graph) {
        this.graph = graph;
    }

    public int incrementAndGetNodeVersion() {
        ++this.nodeVersion;
        if (this.nodeVersion == Integer.MAX_VALUE) {
            this.nodeVersion = -2147483647;
            this.handleNodeReset();
        }
        return this.nodeVersion;
    }

    public int incrementAndGetEdgeVersion() {
        ++this.edgeVersion;
        if (this.edgeVersion == Integer.MAX_VALUE) {
            this.edgeVersion = -2147483647;
            this.handleEdgeReset();
        }
        return this.edgeVersion;
    }

    public int getNodeVersion() {
        return this.nodeVersion;
    }

    public int getEdgeVersion() {
        return this.edgeVersion;
    }

    private void handleNodeReset() {
        block3: {
            block4: {
                if (this.graph == null) break block3;
                if (!this.graph.getView().isMainView()) break block4;
                GraphStore graphStore = (GraphStore)this.graph;
                if (graphStore.observers == null) break block3;
                for (GraphObserverImpl observer : graphStore.observers) {
                    observer.resetNodeVersion();
                }
                break block3;
            }
            GraphViewImpl view = (GraphViewImpl)this.graph.getView();
            if (view.observers != null) {
                for (GraphObserverImpl observer : view.observers) {
                    observer.resetNodeVersion();
                }
            }
        }
    }

    private void handleEdgeReset() {
        block3: {
            block4: {
                if (this.graph == null) break block3;
                if (!this.graph.getView().isMainView()) break block4;
                GraphStore graphStore = (GraphStore)this.graph;
                if (graphStore.observers == null) break block3;
                for (GraphObserverImpl observer : graphStore.observers) {
                    observer.resetEdgeVersion();
                }
                break block3;
            }
            GraphViewImpl view = (GraphViewImpl)this.graph.getView();
            if (view.observers != null) {
                for (GraphObserverImpl observer : view.observers) {
                    observer.resetEdgeVersion();
                }
            }
        }
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 17 * hash + this.nodeVersion;
        hash = 17 * hash + this.edgeVersion;
        return hash;
    }

    public boolean deepEquals(GraphVersion obj) {
        if (obj == null) {
            return false;
        }
        GraphVersion other = obj;
        if (this.nodeVersion != other.nodeVersion) {
            return false;
        }
        return this.edgeVersion == other.edgeVersion;
    }
}

