/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.SpatialIndex;
import org.gephi.graph.api.Subgraph;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ConfigurationImpl;
import org.gephi.graph.impl.DefaultColumnsImpl;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.EdgeIterableWrapper;
import org.gephi.graph.impl.EdgeStore;
import org.gephi.graph.impl.EdgeTypeStore;
import org.gephi.graph.impl.GraphAttributesImpl;
import org.gephi.graph.impl.GraphFactoryImpl;
import org.gephi.graph.impl.GraphLockImpl;
import org.gephi.graph.impl.GraphModelImpl;
import org.gephi.graph.impl.GraphObserverImpl;
import org.gephi.graph.impl.GraphStoreConfiguration;
import org.gephi.graph.impl.GraphVersion;
import org.gephi.graph.impl.GraphViewStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.NodeIterableWrapper;
import org.gephi.graph.impl.NodeStore;
import org.gephi.graph.impl.SpatialIndexImpl;
import org.gephi.graph.impl.TableImpl;
import org.gephi.graph.impl.TimeStore;
import org.gephi.graph.impl.UndirectedDecorator;

public class GraphStore
implements DirectedGraph,
DirectedSubgraph {
    protected final GraphModelImpl graphModel;
    protected final ConfigurationImpl configuration;
    protected final NodeStore nodeStore;
    protected final EdgeStore edgeStore;
    protected final EdgeTypeStore edgeTypeStore;
    protected final TableImpl<Node> nodeTable;
    protected final TableImpl<Edge> edgeTable;
    protected final GraphViewStore viewStore;
    protected final TimeStore timeStore;
    protected final GraphAttributesImpl attributes;
    protected final GraphFactoryImpl factory;
    protected final GraphLockImpl lock;
    protected final GraphVersion version;
    protected final List<GraphObserverImpl> observers;
    protected final UndirectedDecorator undirectedDecorator;
    protected final GraphView mainGraphView;
    protected TimeFormat timeFormat;
    protected ZoneId timeZone;
    protected SpatialIndexImpl spatialIndex;
    protected final DefaultColumnsImpl defaultColumns;

    public GraphStore() {
        this(null, new ConfigurationImpl());
    }

    public GraphStore(GraphModelImpl model) {
        this(model, model.configuration);
    }

    protected GraphStore(GraphModelImpl model, Configuration config) {
        this(model, new ConfigurationImpl(config));
    }

    protected GraphStore(GraphModelImpl model, ConfigurationImpl config) {
        this.configuration = config;
        this.graphModel = model;
        this.lock = new GraphLockImpl();
        this.edgeTypeStore = new EdgeTypeStore();
        this.mainGraphView = new MainGraphView();
        this.viewStore = new GraphViewStore(this);
        this.version = this.configuration.isEnableObservers() ? new GraphVersion(this) : null;
        this.observers = this.configuration.isEnableObservers() ? new ArrayList() : null;
        this.spatialIndex = this.configuration.isEnableSpatialIndex() ? new SpatialIndexImpl(this) : null;
        this.edgeStore = new EdgeStore(this.edgeTypeStore, this.spatialIndex, this.configuration, this.configuration.isEnableAutoLocking() ? this.lock : null, this.viewStore, this.configuration.isEnableObservers() ? this.version : null);
        this.nodeStore = new NodeStore(this.edgeStore, this.spatialIndex, this.configuration.isEnableAutoLocking() ? this.lock : null, this.viewStore, this.configuration.isEnableObservers() ? this.version : null);
        this.nodeTable = new TableImpl<Node>(this, Node.class);
        this.edgeTable = new TableImpl<Edge>(this, Edge.class);
        this.timeStore = new TimeStore(this, this.configuration.isEnableIndexTime());
        this.attributes = new GraphAttributesImpl();
        this.factory = new GraphFactoryImpl(this);
        this.timeFormat = GraphStoreConfiguration.DEFAULT_TIME_FORMAT;
        this.timeZone = GraphStoreConfiguration.DEFAULT_TIME_ZONE;
        this.undirectedDecorator = new UndirectedDecorator(this);
        this.nodeTable.store.addColumn(new ColumnImpl(this.nodeTable, "id", this.configuration.getNodeIdType(), "Id", null, Origin.PROPERTY, false, true));
        this.edgeTable.store.addColumn(new ColumnImpl(this.edgeTable, "id", this.configuration.getEdgeIdType(), "Id", null, Origin.PROPERTY, false, true));
        this.nodeTable.store.addColumn(new ColumnImpl(this.nodeTable, "label", String.class, "Label", null, Origin.PROPERTY, false, false));
        this.edgeTable.store.addColumn(new ColumnImpl(this.edgeTable, "label", String.class, "Label", null, Origin.PROPERTY, false, false));
        if (this.configuration.getTimeRepresentation().equals((Object)TimeRepresentation.TIMESTAMP)) {
            this.nodeTable.store.addColumn(new ColumnImpl(this.nodeTable, "timeset", TimestampSet.class, "Timestamp", null, Origin.PROPERTY, false, false));
            this.edgeTable.store.addColumn(new ColumnImpl(this.edgeTable, "timeset", TimestampSet.class, "Timestamp", null, Origin.PROPERTY, false, false));
        } else {
            this.nodeTable.store.addColumn(new ColumnImpl(this.nodeTable, "timeset", IntervalSet.class, "Interval", null, Origin.PROPERTY, false, false));
            this.edgeTable.store.addColumn(new ColumnImpl(this.edgeTable, "timeset", IntervalSet.class, "Interval", null, Origin.PROPERTY, false, false));
        }
        if (this.configuration.isEdgeWeightColumn()) {
            this.edgeTable.store.addColumn(new ColumnImpl(this.edgeTable, "weight", this.configuration.getEdgeWeightType(), "Weight", null, Origin.PROPERTY, false, false));
        } else {
            ++this.edgeTable.store.length;
        }
        this.defaultColumns = new DefaultColumnsImpl(this);
    }

    @Override
    public boolean addNode(Node node) {
        this.autoWriteLock();
        try {
            boolean bl = this.nodeStore.add(node);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public boolean addAllNodes(Collection<? extends Node> nodes) {
        this.autoWriteLock();
        try {
            boolean bl = this.nodeStore.addAll(nodes);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public boolean addEdge(Edge edge) {
        this.autoWriteLock();
        try {
            boolean bl = this.edgeStore.add(edge);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public boolean addAllEdges(Collection<? extends Edge> edges) {
        this.autoWriteLock();
        try {
            boolean bl = this.edgeStore.addAll(edges);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public NodeImpl getNode(Object id) {
        this.autoReadLock();
        try {
            NodeImpl nodeImpl = this.nodeStore.get(id);
            return nodeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public NodeImpl getNodeByStoreId(int id) {
        this.autoReadLock();
        try {
            NodeImpl nodeImpl = this.nodeStore.getForGetByStoreId(id);
            return nodeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public boolean hasNode(Object id) {
        return this.getNode(id) != null;
    }

    @Override
    public EdgeImpl getEdge(Object id) {
        this.autoReadLock();
        try {
            EdgeImpl edgeImpl = this.edgeStore.get(id);
            return edgeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public EdgeImpl getEdgeByStoreId(int id) {
        this.autoReadLock();
        try {
            EdgeImpl edgeImpl = this.edgeStore.getForGetByStoreId(id);
            return edgeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public boolean hasEdge(Object id) {
        return this.getEdge(id) != null;
    }

    @Override
    public Edge getMutualEdge(Edge edge) {
        this.autoReadLock();
        try {
            EdgeImpl edgeImpl = this.edgeStore.getMutualEdge(edge);
            return edgeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public NodeIterable getNodes() {
        return this.nodeStore;
    }

    @Override
    public EdgeIterable getEdges() {
        return this.edgeStore;
    }

    protected ElementIterable<?> getElements(Table table) {
        return table.isNodeTable() ? this.nodeStore : this.edgeStore;
    }

    @Override
    public EdgeIterable getEdges(int type) {
        return new EdgeIterableWrapper(() -> this.edgeStore.iteratorType(type, false), () -> this.edgeStore.spliteratorType(type, false), this.getAutoLock());
    }

    @Override
    public EdgeIterable getSelfLoops() {
        return new EdgeIterableWrapper(this.edgeStore::iteratorSelfLoop, this.edgeStore::spliteratorSelfLoop, this.getAutoLock());
    }

    @Override
    public boolean removeNode(Node node) {
        this.autoWriteLock();
        try {
            this.nodeStore.checkNonNullNodeObject(node);
            EdgeStore.EdgeInOutIterator edgeIterator = this.edgeStore.edgeIterator(node, false);
            while (edgeIterator.hasNext()) {
                edgeIterator.next();
                edgeIterator.remove();
            }
            boolean bl = this.nodeStore.remove(node);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public boolean removeEdge(Edge edge) {
        this.autoWriteLock();
        try {
            boolean bl = this.edgeStore.remove(edge);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllNodes(Collection<? extends Node> nodes) {
        this.autoWriteLock();
        try {
            for (Node node : nodes) {
                this.nodeStore.checkNonNullNodeObject(node);
                EdgeStore.EdgeInOutIterator edgeIterator = this.edgeStore.edgeIterator(node, false);
                while (edgeIterator.hasNext()) {
                    edgeIterator.next();
                    edgeIterator.remove();
                }
            }
            boolean bl = this.nodeStore.removeAll(nodes);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public boolean retainNodes(Collection<? extends Node> nodes) {
        this.autoWriteLock();
        try {
            boolean bl = this.nodeStore.retainAll(nodes);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public boolean removeAllEdges(Collection<? extends Edge> edges) {
        this.autoWriteLock();
        try {
            boolean bl = this.edgeStore.removeAll(edges);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public boolean retainEdges(Collection<? extends Edge> edges) {
        this.autoWriteLock();
        try {
            boolean bl = this.edgeStore.retainAll(edges);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    public NodeStore getNodeStore() {
        return this.nodeStore;
    }

    public EdgeStore getEdgeStore() {
        return this.edgeStore;
    }

    @Override
    public boolean contains(Node node) {
        this.autoReadLock();
        try {
            boolean bl = this.nodeStore.contains(node);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public boolean contains(Edge edge) {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.contains(edge);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdge(Node node1, Node node2, int type) {
        this.autoReadLock();
        try {
            EdgeImpl edgeImpl = this.edgeStore.get(node1, node2, type, false);
            return edgeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public EdgeIterable getEdges(Node node1, Node node2, int type) {
        return new EdgeIterableWrapper(() -> this.edgeStore.getAll(node1, node2, type, false), this.getAutoLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdge(Node node1, Node node2) {
        this.autoReadLock();
        try {
            EdgeImpl edgeImpl = this.edgeStore.get(node1, node2, false);
            return edgeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public EdgeIterable getEdges(Node node1, Node node2) {
        return new EdgeIterableWrapper(() -> this.edgeStore.getAll(node1, node2, false), this.getAutoLock());
    }

    @Override
    public NodeIterable getNeighbors(Node node) {
        return new NodeIterableWrapper(() -> this.edgeStore.neighborIterator(node), this.getAutoLock());
    }

    @Override
    public NodeIterable getNeighbors(Node node, int type) {
        return new NodeIterableWrapper(() -> this.edgeStore.neighborIterator(node, type), this.getAutoLock());
    }

    @Override
    public NodeIterable getPredecessors(Node node) {
        return new NodeIterableWrapper(() -> this.edgeStore.neighborInIterator(node), this.getAutoLock());
    }

    @Override
    public NodeIterable getPredecessors(Node node, int type) {
        return new NodeIterableWrapper(() -> this.edgeStore.neighborInIterator(node, type), this.getAutoLock());
    }

    @Override
    public NodeIterable getSuccessors(Node node) {
        return new NodeIterableWrapper(() -> this.edgeStore.neighborOutIterator(node), this.getAutoLock());
    }

    @Override
    public NodeIterable getSuccessors(Node node, int type) {
        return new NodeIterableWrapper(() -> this.edgeStore.neighborOutIterator(node, type), this.getAutoLock());
    }

    @Override
    public EdgeIterable getEdges(Node node) {
        return new EdgeIterableWrapper(() -> this.edgeStore.edgeIterator(node, true), this.getAutoLock());
    }

    @Override
    public EdgeIterable getEdges(Node node, int type) {
        return new EdgeIterableWrapper(() -> this.edgeStore.edgeIterator(node, type), this.getAutoLock());
    }

    @Override
    public EdgeIterable getInEdges(Node node) {
        return new EdgeIterableWrapper(() -> this.edgeStore.edgeInIterator(node), this.getAutoLock());
    }

    @Override
    public EdgeIterable getInEdges(Node node, int type) {
        return new EdgeIterableWrapper(() -> this.edgeStore.edgeInIterator(node, type), this.getAutoLock());
    }

    @Override
    public EdgeIterable getOutEdges(Node node) {
        return new EdgeIterableWrapper(() -> this.edgeStore.edgeOutIterator(node), this.getAutoLock());
    }

    @Override
    public EdgeIterable getOutEdges(Node node, int type) {
        return new EdgeIterableWrapper(() -> this.edgeStore.edgeOutIterator(node, type), this.getAutoLock());
    }

    @Override
    public int getNodeCount() {
        return this.nodeStore.size();
    }

    @Override
    public int getEdgeCount() {
        return this.edgeStore.size();
    }

    @Override
    public int getEdgeCount(int type) {
        this.autoReadLock();
        try {
            if (this.edgeTypeStore.contains(type)) {
                int n = this.edgeStore.size(type);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public Node getOpposite(Node node, Edge edge) {
        this.nodeStore.checkNonNullNodeObject(node);
        this.edgeStore.checkNonNullEdgeObject(edge);
        return edge.getSource() == node ? edge.getTarget() : edge.getSource();
    }

    @Override
    public int getDegree(Node node) {
        this.nodeStore.checkNonNullNodeObject(node);
        return ((NodeImpl)node).getDegree();
    }

    public int getUndirectedDegree(Node node) {
        this.nodeStore.checkNonNullNodeObject(node);
        return ((NodeImpl)node).getUndirectedDegree();
    }

    @Override
    public int getInDegree(Node node) {
        this.nodeStore.checkNonNullNodeObject(node);
        return ((NodeImpl)node).getInDegree();
    }

    @Override
    public int getOutDegree(Node node) {
        this.nodeStore.checkNonNullNodeObject(node);
        return ((NodeImpl)node).getOutDegree();
    }

    @Override
    public boolean isSelfLoop(Edge edge) {
        return edge.isSelfLoop();
    }

    @Override
    public boolean isDirected(Edge edge) {
        return edge.isDirected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdjacent(Node node1, Node node2) {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.isAdjacent(node1, node2);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdjacent(Node node1, Node node2, int type) {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.isAdjacent(node1, node2, type);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIncident(Edge edge1, Edge edge2) {
        this.autoReadLock();
        try {
            this.edgeStore.checkNonNullEdgeObject(edge1);
            this.edgeStore.checkNonNullEdgeObject(edge2);
            boolean bl = this.edgeStore.isIncident((EdgeImpl)edge1, (EdgeImpl)edge2);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIncident(Node node, Edge edge) {
        this.autoReadLock();
        try {
            this.nodeStore.checkNonNullNodeObject(node);
            this.edgeStore.checkNonNullEdgeObject(edge);
            boolean bl = this.edgeStore.isIncident((NodeImpl)node, (EdgeImpl)edge);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public void clearEdges(Node node) {
        this.autoWriteLock();
        try {
            EdgeStore.EdgeInOutIterator itr = this.edgeStore.edgeIterator(node, false);
            while (itr.hasNext()) {
                itr.next();
                itr.remove();
            }
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEdges(Node node, int type) {
        this.autoWriteLock();
        try {
            EdgeStore.EdgeTypeInOutIterator itr = this.edgeStore.edgeIterator(node, type);
            while (itr.hasNext()) {
                itr.next();
                itr.remove();
            }
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public void clear() {
        this.autoWriteLock();
        try {
            this.edgeStore.clear();
            this.nodeStore.clear();
            this.edgeTypeStore.clear();
            this.edgeTable.store.indexStore.clear();
            this.nodeTable.store.indexStore.clear();
            this.timeStore.clear();
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public void clearEdges() {
        this.autoWriteLock();
        try {
            this.edgeStore.clear();
            this.edgeTypeStore.clear();
            this.edgeTable.store.indexStore.clear();
            this.timeStore.clearEdges();
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public GraphView getView() {
        return this.mainGraphView;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.getValue(key);
    }

    @Override
    public Object getAttribute(String key, double timestamp) {
        return this.attributes.getValue(key, timestamp);
    }

    @Override
    public Object getAttribute(String key, Interval interval) {
        return this.attributes.getValue(key, interval);
    }

    @Override
    public Set<String> getAttributeKeys() {
        return this.attributes.getKeys();
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.setValue(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.removeValue(key);
    }

    @Override
    public void setAttribute(String key, Object value, double timestamp) {
        this.attributes.setValue(key, value, timestamp);
    }

    @Override
    public void setAttribute(String key, Object value, Interval interval) {
        this.attributes.setValue(key, value, interval);
    }

    @Override
    public void removeAttribute(String key, double timestamp) {
        this.attributes.removeValue(key, timestamp);
    }

    @Override
    public void removeAttribute(String key, Interval interval) {
        this.attributes.removeValue(key, interval);
    }

    @Override
    public void readLock() {
        this.lock.readLock();
    }

    @Override
    public void readUnlock() {
        this.lock.readUnlock();
    }

    @Override
    public void readUnlockAll() {
        this.lock.readUnlockAll();
    }

    @Override
    public void writeLock() {
        this.lock.writeLock();
    }

    @Override
    public void writeUnlock() {
        this.lock.writeUnlock();
    }

    @Override
    public GraphLockImpl getLock() {
        return this.lock;
    }

    @Override
    public SpatialIndex getSpatialIndex() {
        if (this.spatialIndex == null) {
            throw new UnsupportedOperationException("Spatial index is disabled (from Configuration)");
        }
        return this.spatialIndex;
    }

    protected void autoReadLock() {
        if (this.configuration.isEnableAutoLocking()) {
            this.readLock();
        }
    }

    protected void autoReadUnlock() {
        if (this.configuration.isEnableAutoLocking()) {
            this.readUnlock();
        }
    }

    protected void autoReadUnlockAll() {
        if (this.configuration.isEnableAutoLocking()) {
            this.readUnlockAll();
        }
    }

    protected void autoWriteLock() {
        if (this.configuration.isEnableAutoLocking()) {
            this.writeLock();
        }
    }

    protected void autoWriteUnlock() {
        if (this.configuration.isEnableAutoLocking()) {
            this.writeUnlock();
        }
    }

    @Override
    public GraphModel getModel() {
        return this.graphModel;
    }

    @Override
    public boolean isDirected() {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.isDirectedGraph();
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public boolean isUndirected() {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.isUndirectedGraph();
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public boolean isMixed() {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.isMixedGraph();
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public void union(Subgraph subGraph) {
        throw new UnsupportedOperationException("Not supported for the main view.");
    }

    @Override
    public void intersection(Subgraph subGraph) {
        throw new UnsupportedOperationException("Not supported for the main view.");
    }

    @Override
    public void fill() {
        throw new UnsupportedOperationException("Not supported for the main view.");
    }

    @Override
    public void not() {
        throw new UnsupportedOperationException("Not supported for the main view.");
    }

    @Override
    public Graph getRootGraph() {
        return this;
    }

    @Override
    public int getVersion() {
        return Objects.hash(this.version.nodeVersion, this.version.edgeVersion);
    }

    protected GraphObserverImpl createGraphObserver(Graph graph, boolean withDiff) {
        if (graph.getView() != this.mainGraphView) {
            throw new RuntimeException("This graph doesn't belong to this store");
        }
        if (this.observers != null) {
            GraphObserverImpl observer = new GraphObserverImpl(this, this.version, graph, withDiff);
            this.observers.add(observer);
            return observer;
        }
        return null;
    }

    protected void destroyGraphObserver(GraphObserverImpl observer) {
        if (this.observers != null) {
            if (observer.graph.getView() != this.mainGraphView) {
                throw new RuntimeException("This graph doesn't belong to this store");
            }
            this.observers.remove(observer);
            observer.destroyObserver();
        }
    }

    protected GraphLockImpl getAutoLock() {
        return this.configuration.isEnableAutoLocking() ? this.lock : null;
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 29 * hash + (this.nodeStore != null ? this.nodeStore.deepHashCode() : 0);
        hash = 29 * hash + (this.edgeStore != null ? this.edgeStore.deepHashCode() : 0);
        hash = 29 * hash + (this.edgeTypeStore != null ? this.edgeTypeStore.deepHashCode() : 0);
        hash = 29 * hash + (this.nodeTable != null ? this.nodeTable.deepHashCode() : 0);
        hash = 29 * hash + (this.edgeTable != null ? this.edgeTable.deepHashCode() : 0);
        return hash;
    }

    public boolean deepEquals(GraphStore obj) {
        if (obj == null) {
            return false;
        }
        if (!(this.nodeStore == obj.nodeStore || this.nodeStore != null && this.nodeStore.deepEquals(obj.nodeStore))) {
            return false;
        }
        if (!(this.edgeStore == obj.edgeStore || this.edgeStore != null && this.edgeStore.deepEquals(obj.edgeStore))) {
            return false;
        }
        if (!(this.edgeTypeStore == obj.edgeTypeStore || this.edgeTypeStore != null && this.edgeTypeStore.deepEquals(obj.edgeTypeStore))) {
            return false;
        }
        if (!(this.nodeTable == obj.nodeTable || this.nodeTable != null && this.nodeTable.deepEquals(obj.nodeTable))) {
            return false;
        }
        return this.edgeTable == obj.edgeTable || this.edgeTable != null && this.edgeTable.deepEquals(obj.edgeTable);
    }

    private final class MainGraphView
    implements GraphView {
        private MainGraphView() {
        }

        @Override
        public GraphModel getGraphModel() {
            return GraphStore.this.graphModel;
        }

        @Override
        public boolean isMainView() {
            return true;
        }

        @Override
        public boolean isNodeView() {
            return true;
        }

        @Override
        public boolean isEdgeView() {
            return true;
        }

        @Override
        public boolean isDestroyed() {
            return false;
        }

        @Override
        public Interval getTimeInterval() {
            return Interval.INFINITY_INTERVAL;
        }
    }
}

