/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphFactory;
import org.gephi.graph.api.Node;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphStoreConfiguration;
import org.gephi.graph.impl.NodeImpl;

public class GraphFactoryImpl
implements GraphFactory {
    protected final AtomicInteger NODE_IDS = new AtomicInteger();
    protected final AtomicInteger EDGE_IDS = new AtomicInteger();
    protected final AssignConfiguration nodeAssignConfiguration;
    protected final AssignConfiguration edgeAssignConfiguration;
    protected final GraphStore store;

    public GraphFactoryImpl(GraphStore store) {
        this.store = store;
        this.nodeAssignConfiguration = this.getAssignConfiguration(AttributeUtils.getStandardizedType(store.configuration.getNodeIdType()));
        this.edgeAssignConfiguration = this.getAssignConfiguration(AttributeUtils.getStandardizedType(store.configuration.getEdgeIdType()));
    }

    @Override
    public Edge newEdge(Node source, Node target) {
        return new EdgeImpl(this.nextEdgeId(), this.store, (NodeImpl)source, (NodeImpl)target, 0, GraphStoreConfiguration.DEFAULT_EDGE_WEIGHT, true);
    }

    @Override
    public Edge newEdge(Node source, Node target, boolean directed) {
        return new EdgeImpl(this.nextEdgeId(), this.store, (NodeImpl)source, (NodeImpl)target, 0, GraphStoreConfiguration.DEFAULT_EDGE_WEIGHT, directed);
    }

    @Override
    public Edge newEdge(Node source, Node target, int type, boolean directed) {
        return new EdgeImpl(this.nextEdgeId(), this.store, (NodeImpl)source, (NodeImpl)target, type, GraphStoreConfiguration.DEFAULT_EDGE_WEIGHT, directed);
    }

    @Override
    public Edge newEdge(Node source, Node target, int type, double weight, boolean directed) {
        return new EdgeImpl(this.nextEdgeId(), this.store, (NodeImpl)source, (NodeImpl)target, type, weight, directed);
    }

    @Override
    public Edge newEdge(Object id, Node source, Node target, int type, double weight, boolean directed) {
        EdgeImpl res = new EdgeImpl(id, this.store, (NodeImpl)source, (NodeImpl)target, type, weight, directed);
        switch (this.edgeAssignConfiguration) {
            case INTEGER: {
                Integer idInt = (Integer)id;
                if (idInt < this.EDGE_IDS.get()) break;
                this.EDGE_IDS.set(idInt + 1);
                break;
            }
            case STRING: {
                Integer idStrParsed;
                String idStr = (String)id;
                if (!GraphFactoryImpl.isNumeric(idStr) || (idStrParsed = Integer.valueOf(Integer.parseInt(idStr))) < this.EDGE_IDS.get()) break;
                this.EDGE_IDS.set(idStrParsed + 1);
            }
        }
        return res;
    }

    @Override
    public Node newNode() {
        return new NodeImpl(this.nextNodeId(), this.store);
    }

    @Override
    public Node newNode(Object id) {
        NodeImpl res = new NodeImpl(id, this.store);
        switch (this.nodeAssignConfiguration) {
            case INTEGER: {
                Integer idInt = (Integer)id;
                if (idInt < this.NODE_IDS.get()) break;
                this.NODE_IDS.set(idInt + 1);
                break;
            }
            case STRING: {
                Integer idStrParsed;
                String idStr = (String)id;
                if (!GraphFactoryImpl.isNumeric(idStr) || (idStrParsed = Integer.valueOf(Integer.parseInt(idStr))) < this.NODE_IDS.get()) break;
                this.NODE_IDS.set(idStrParsed + 1);
            }
        }
        return res;
    }

    private Object nextNodeId() {
        switch (this.nodeAssignConfiguration) {
            case INTEGER: {
                return this.NODE_IDS.getAndIncrement();
            }
            case STRING: {
                return String.valueOf(this.NODE_IDS.getAndIncrement());
            }
        }
        throw new UnsupportedOperationException("Automatic node ids assignement isn't available for this type: '" + this.store.configuration.getNodeIdType().getName() + "'");
    }

    private Object nextEdgeId() {
        switch (this.edgeAssignConfiguration) {
            case INTEGER: {
                return this.EDGE_IDS.getAndIncrement();
            }
            case STRING: {
                return String.valueOf(this.EDGE_IDS.getAndIncrement());
            }
        }
        throw new UnsupportedOperationException("Automatic edge ids assignement isn't available for this type: '" + this.store.configuration.getEdgeIdType().getName() + "'");
    }

    protected int getNodeCounter() {
        return this.NODE_IDS.get();
    }

    protected int getEdgeCounter() {
        return this.EDGE_IDS.get();
    }

    protected void setNodeCounter(int count) {
        this.NODE_IDS.set(count);
    }

    protected void setEdgeCounter(int count) {
        this.EDGE_IDS.set(count);
    }

    private static boolean isNumeric(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public int deepHashCode() {
        int hash = 3;
        Integer node = this.NODE_IDS.get();
        Integer edge = this.EDGE_IDS.get();
        hash = 59 * hash + node.hashCode();
        hash = 59 * hash + edge.hashCode();
        return hash;
    }

    public boolean deepEquals(GraphFactoryImpl obj) {
        if (obj == null) {
            return false;
        }
        Integer node = this.NODE_IDS.get();
        Integer edge = this.EDGE_IDS.get();
        Integer otherNode = obj.NODE_IDS.get();
        Integer otherEdge = obj.EDGE_IDS.get();
        if (this.NODE_IDS != obj.NODE_IDS && !node.equals(otherNode)) {
            return false;
        }
        return this.EDGE_IDS == obj.EDGE_IDS || edge.equals(otherEdge);
    }

    protected final AssignConfiguration getAssignConfiguration(Class type) {
        if (type.equals(Integer.class)) {
            return AssignConfiguration.INTEGER;
        }
        if (type.equals(String.class)) {
            return AssignConfiguration.STRING;
        }
        return AssignConfiguration.DISABLED;
    }

    protected static enum AssignConfiguration {
        STRING,
        INTEGER,
        DISABLED;

    }
}

