/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import org.gephi.graph.api.AttributeUtils;

public final class FormattingAndParsingUtils {
    public static final char DYNAMIC_TYPE_LEFT_BOUND = '<';
    public static final char DYNAMIC_TYPE_RIGHT_BOUND = '>';
    public static final char LEFT_BOUND_BRACKET = '(';
    public static final char LEFT_BOUND_SQUARE_BRACKET = '[';
    public static final char RIGHT_BOUND_BRACKET = ')';
    public static final char RIGHT_BOUND_SQUARE_BRACKET = ']';
    public static final char COMMA = ',';
    public static final String EMPTY_VALUE = "<empty>";
    public static final String INFINITY = "Infinity";
    private static final char[] DYNAMIC_SPECIAL_CHARACTERS = " ;,()[]\"'".toCharArray();
    private static final char[] ARRAY_SPECIAL_CHARACTERS = " ,[]\"'".toCharArray();

    public static double parseDateTimeOrTimestamp(String timeStr, ZoneId zoneId) throws DateTimeParseException {
        double value;
        try {
            value = Double.parseDouble(FormattingAndParsingUtils.infinityIgnoreCase(timeStr));
            if (Double.isNaN(value)) {
                throw new IllegalArgumentException("NaN is not allowed as an interval bound");
            }
        }
        catch (Exception ex) {
            value = AttributeUtils.parseDateTime(timeStr, zoneId);
        }
        return value;
    }

    public static double parseDateTimeOrTimestamp(String timeStr) throws DateTimeParseException {
        return FormattingAndParsingUtils.parseDateTimeOrTimestamp(timeStr, null);
    }

    protected static String parseLiteral(StringReader reader, char quote) throws IOException {
        int r;
        StringBuilder sb = new StringBuilder();
        boolean escapeEnabled = false;
        block3: while ((r = reader.read()) != -1) {
            char c = (char)r;
            if (c == quote) {
                if (escapeEnabled) {
                    sb.append(quote);
                    escapeEnabled = false;
                    continue;
                }
                return sb.toString();
            }
            switch (c) {
                case '\\': {
                    if (escapeEnabled) {
                        sb.append('\\');
                        escapeEnabled = false;
                        continue block3;
                    }
                    escapeEnabled = true;
                    continue block3;
                }
            }
            if (escapeEnabled) {
                escapeEnabled = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected static String parseValue(StringReader reader) throws IOException {
        int r;
        StringBuilder sb = new StringBuilder();
        while ((r = reader.read()) != -1) {
            char c = (char)r;
            switch (c) {
                case ')': 
                case ']': {
                    reader.skip(-1L);
                }
                case ',': {
                    return sb.toString().trim();
                }
            }
            sb.append(c);
        }
        return sb.toString().trim();
    }

    protected static <T> T convertValue(Class<T> typeClass, String valString) {
        Object value = typeClass.equals(Byte.class) || typeClass.equals(Byte.TYPE) || typeClass.equals(Short.class) || typeClass.equals(Short.TYPE) || typeClass.equals(Integer.class) || typeClass.equals(Integer.TYPE) || typeClass.equals(Long.class) || typeClass.equals(Long.TYPE) || typeClass.equals(BigInteger.class) ? FormattingAndParsingUtils.parseNumberWithoutDecimals(typeClass, valString) : (typeClass.equals(Float.class) || typeClass.equals(Float.TYPE) || typeClass.equals(Double.class) || typeClass.equals(Double.TYPE) || typeClass.equals(BigDecimal.class) ? FormattingAndParsingUtils.parseNumberWithDecimals(typeClass, valString) : AttributeUtils.parse(valString, typeClass));
        return value;
    }

    private static String infinityIgnoreCase(String value) {
        if ((value = value.trim()).equalsIgnoreCase(INFINITY)) {
            return INFINITY;
        }
        if (value.equalsIgnoreCase("-Infinity")) {
            return "-Infinity";
        }
        return value;
    }

    private static <T extends Number> T parseNumberWithoutDecimals(Class<T> typeClass, String valString) {
        valString = FormattingAndParsingUtils.removeDecimalDigitsFromString(valString);
        return (T)((Number)AttributeUtils.parse(valString, typeClass));
    }

    private static <T extends Number> T parseNumberWithDecimals(Class<T> typeClass, String valString) {
        valString = FormattingAndParsingUtils.infinityIgnoreCase(valString);
        return (T)((Number)AttributeUtils.parse(valString, typeClass));
    }

    private static String removeDecimalDigitsFromString(String s) {
        int firstDotIndex = s.indexOf(46);
        if (firstDotIndex > 0) {
            return s.substring(0, firstDotIndex);
        }
        return s;
    }

    public static boolean containsDynamicSpecialCharacters(String value) {
        for (char c : DYNAMIC_SPECIAL_CHARACTERS) {
            if (value.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    public static <T> String printArray(Object arr) {
        if (arr == null) {
            return null;
        }
        int size = Array.getLength(arr);
        if (size == 0) {
            return EMPTY_VALUE;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < size; ++i) {
            Object value = Array.get(arr, i);
            if (value != null) {
                String stringValue = value.toString();
                if (stringValue.equals("null") || FormattingAndParsingUtils.containsArraySpecialCharacters(stringValue) || stringValue.trim().isEmpty()) {
                    sb.append('\"');
                    sb.append(stringValue.replace("\\", "\\\\").replace("\"", "\\\""));
                    sb.append('\"');
                } else {
                    sb.append(stringValue);
                }
            } else {
                sb.append("null");
            }
            if (i >= size - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    private static boolean containsArraySpecialCharacters(String value) {
        for (char c : ARRAY_SPECIAL_CHARACTERS) {
            if (value.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }
}

