/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.impl.GraphLockImpl;

public abstract class ElementIterableWrapper<T extends Element>
implements ElementIterable<T> {
    protected final Supplier<Iterator<T>> iteratorSupplier;
    protected final Supplier<Spliterator<T>> spliteratorSupplier;
    protected final GraphLockImpl lock;
    protected final boolean parallelPossible;

    public ElementIterableWrapper(Supplier<Iterator<T>> iteratorSupplier, GraphLockImpl lock) {
        this.iteratorSupplier = iteratorSupplier;
        this.spliteratorSupplier = () -> Spliterators.spliteratorUnknownSize((Iterator)iteratorSupplier.get(), 272);
        this.lock = lock;
        this.parallelPossible = false;
    }

    public ElementIterableWrapper(Supplier<Iterator<T>> iteratorSupplier, Supplier<Spliterator<T>> spliteratorSupplier, GraphLockImpl lock) {
        this.iteratorSupplier = iteratorSupplier;
        this.spliteratorSupplier = spliteratorSupplier;
        this.lock = lock;
        this.parallelPossible = true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iteratorSupplier.get();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.spliteratorSupplier.get();
    }

    @Override
    public Stream<T> parallelStream() {
        if (!this.parallelPossible) {
            throw new UnsupportedOperationException("Parallel stream not supported for this operation.");
        }
        return ElementIterable.super.parallelStream();
    }

    @Override
    public abstract T[] toArray();

    @Override
    public Collection<T> toCollection() {
        if (this.parallelPossible && this.lock != null) {
            this.lock.readLock();
            try {
                Collection collection = StreamSupport.stream(this.spliterator(), true).collect(Collectors.toList());
                return collection;
            }
            finally {
                this.lock.readUnlock();
            }
        }
        return StreamSupport.stream(this.spliterator(), this.parallelPossible).collect(Collectors.toList());
    }

    @Override
    public Set<T> toSet() {
        if (this.parallelPossible && this.lock != null) {
            this.lock.readLock();
            try {
                Set set = StreamSupport.stream(this.spliterator(), true).collect(Collectors.toSet());
                return set;
            }
            finally {
                this.lock.readUnlock();
            }
        }
        return StreamSupport.stream(this.spliterator(), this.parallelPossible).collect(Collectors.toSet());
    }

    @Override
    public void doBreak() {
        if (this.lock != null) {
            this.lock.readUnlock();
        }
    }
}

