/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.impl.ElementIterableWrapper;
import org.gephi.graph.impl.GraphLockImpl;

public class EdgeIterableWrapper
extends ElementIterableWrapper<Edge>
implements EdgeIterable {
    public EdgeIterableWrapper(Supplier<Iterator<Edge>> iteratorSupplier, GraphLockImpl lock) {
        super(iteratorSupplier, lock);
    }

    public EdgeIterableWrapper(Supplier<Iterator<Edge>> iteratorSupplier, Supplier<Spliterator<Edge>> spliteratorSupplier, GraphLockImpl lock) {
        super(iteratorSupplier, spliteratorSupplier, lock);
    }

    @Override
    public Edge[] toArray() {
        if (this.parallelPossible && this.lock != null) {
            this.lock.readLock();
            try {
                Edge[] edgeArray = (Edge[])StreamSupport.stream(this.spliterator(), true).toArray(Edge[]::new);
                return edgeArray;
            }
            finally {
                this.lock.readUnlock();
            }
        }
        return (Edge[])StreamSupport.stream(this.spliterator(), this.parallelPossible).toArray(Edge[]::new);
    }
}

