/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.impl.ColumnIndexImpl;
import org.gephi.graph.impl.GraphModelImpl;

public class DegreeNoIndexImpl
implements ColumnIndexImpl<Integer, Node> {
    protected final DegreeType degreeType;
    protected final Graph graph;

    protected DegreeNoIndexImpl(Graph graph, DegreeType degreeType) {
        this.graph = graph;
        this.degreeType = degreeType;
    }

    @Override
    public int count(Integer value) {
        this.checkNull(value);
        Iterator<Node> nodeIterator = this.graph.getNodes().iterator();
        int count = 0;
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.next();
            int degree = this.getDegree(node);
            if (value != degree) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterable<Node> get(Integer degree) {
        this.checkNull(degree);
        return new NodeWithDegreeIterable(degree);
    }

    @Override
    public Collection<Integer> values() {
        Iterator<Node> nodeIterator = this.graph.getNodes().iterator();
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.next();
            int degree = this.getDegree(node);
            set.add(degree);
        }
        return set;
    }

    @Override
    public int countValues() {
        return this.values().size();
    }

    @Override
    public int countElements() {
        return this.graph.getNodeCount();
    }

    @Override
    public boolean isSortable() {
        return true;
    }

    @Override
    public Integer getMinValue() {
        Integer min = null;
        Iterator<Node> nodeIterator = this.graph.getNodes().iterator();
        int minN = Integer.MAX_VALUE;
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.next();
            int degree = this.getDegree(node);
            if (min != null && degree >= minN) continue;
            minN = degree;
            min = degree;
        }
        return min;
    }

    @Override
    public Integer getMaxValue() {
        Integer max = null;
        Iterator<Node> nodeIterator = this.graph.getNodes().iterator();
        int maxN = Integer.MIN_VALUE;
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.next();
            int degree = this.getDegree(node);
            if (max != null && degree <= maxN) continue;
            maxN = degree;
            max = degree;
        }
        return max;
    }

    @Override
    public Column getColumn() {
        switch (this.degreeType) {
            case DEGREE: {
                return this.graph.getModel().defaultColumns().degree();
            }
            case IN_DEGREE: {
                return this.graph.getModel().defaultColumns().inDegree();
            }
            case OUT_DEGREE: {
                return this.graph.getModel().defaultColumns().outDegree();
            }
        }
        return null;
    }

    @Override
    public int getVersion() {
        return ((GraphModelImpl)this.graph.getModel()).store.version.nodeVersion;
    }

    @Override
    public Iterator<Map.Entry<Integer, ? extends Set<Node>>> iterator() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void clear() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Integer putValue(Node element, Integer value) {
        return value;
    }

    @Override
    public Integer replaceValue(Node element, Integer oldValue, Integer newValue) {
        return newValue;
    }

    @Override
    public void removeValue(Node element, Integer value) {
    }

    private int getDegree(Node node) {
        switch (this.degreeType) {
            case DEGREE: {
                return this.graph.getDegree(node);
            }
            case IN_DEGREE: {
                return ((DirectedGraph)this.graph).getInDegree(node);
            }
            case OUT_DEGREE: {
                return ((DirectedGraph)this.graph).getOutDegree(node);
            }
        }
        throw new RuntimeException();
    }

    private void checkNull(Integer value) {
        if (value == null) {
            throw new NullPointerException();
        }
    }

    public static enum DegreeType {
        DEGREE,
        IN_DEGREE,
        OUT_DEGREE;

    }

    private class NodeWithDegreeIterable
    implements Iterable<Node> {
        private final Integer value;

        public NodeWithDegreeIterable(Integer degree) {
            this.value = degree;
        }

        @Override
        public Iterator<Node> iterator() {
            return new NodeWithDegreeIterator(this.value);
        }
    }

    private class NodeWithDegreeIterator
    implements Iterator<Node> {
        private final Iterator<Node> itr;
        private final Integer value;
        private Node pointer;

        public NodeWithDegreeIterator(Integer value) {
            this.itr = DegreeNoIndexImpl.this.graph.getNodes().iterator();
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            while (this.pointer == null && this.itr.hasNext()) {
                Node node = this.itr.next();
                int degree = DegreeNoIndexImpl.this.getDegree(node);
                if (this.value != degree) continue;
                this.pointer = node;
            }
            return this.pointer != null;
        }

        @Override
        public Node next() {
            Node res = this.pointer;
            this.pointer = null;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

