/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.chars.Char2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.doubles.Double2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.floats.Float2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.gephi.graph.api.Element;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnIndexImpl;
import org.gephi.graph.impl.TableLockImpl;

public abstract class ColumnStandardIndexImpl<K, T extends Element>
implements ColumnIndexImpl<K, T> {
    protected final TableLockImpl lock;
    protected final ColumnImpl column;
    protected final ValueSet<K, T> nullSet;
    protected Map<K, ValueSet<K, T>> map;
    protected int elements;
    protected final AtomicInteger version = new AtomicInteger(Integer.MIN_VALUE);

    protected ColumnStandardIndexImpl(ColumnImpl column) {
        this.column = column;
        this.nullSet = new ValueSet(null);
        this.lock = column.table != null && column.table.configuration.isEnableAutoLocking() ? new TableLockImpl() : null;
    }

    protected static boolean isSupportedType(ColumnImpl col) {
        return !col.isDynamicAttribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K putValue(T element, K value) {
        this.lock();
        try {
            if (value == null) {
                if (this.nullSet.add(element)) {
                    ++this.elements;
                    this.version.incrementAndGet();
                }
            } else {
                ValueSet<K, T> set = this.getValueSet(value);
                if (set == null) {
                    set = this.addValue(value);
                }
                value = set.value;
                if (set.add(element)) {
                    ++this.elements;
                    this.version.incrementAndGet();
                }
            }
        }
        finally {
            this.unlock();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValue(T element, K value) {
        this.lock();
        try {
            if (value == null) {
                if (this.nullSet.remove(element)) {
                    --this.elements;
                    this.version.incrementAndGet();
                }
            } else {
                ValueSet<K, T> set = this.getValueSet(value);
                if (set.remove(element)) {
                    --this.elements;
                    this.version.incrementAndGet();
                }
                if (set.isEmpty()) {
                    this.removeValue(value);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public K replaceValue(T element, K oldValue, K newValue) {
        this.removeValue(element, oldValue);
        return this.putValue(element, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCount(K value) {
        this.lock();
        try {
            if (value == null) {
                int n = this.nullSet.size();
                return n;
            }
            ValueSet<K, T> valueSet = this.getValueSet(value);
            if (valueSet != null) {
                int n = valueSet.size();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int count(K value) {
        return this.getCount(value);
    }

    @Override
    public Collection<K> values() {
        this.lock();
        try {
            ArrayList arrayList = new ArrayList(new WithNullDecorator());
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int countValues() {
        return (this.nullSet.isEmpty() ? 0 : 1) + this.map.size();
    }

    @Override
    public int countElements() {
        return this.elements;
    }

    @Override
    public Number getMinValue() {
        this.lock();
        try {
            if (this.isSortable()) {
                if (this.map.isEmpty()) {
                    Number number = null;
                    return number;
                }
                Number number = (Number)((SortedMap)this.map).firstKey();
                return number;
            }
            throw new UnsupportedOperationException("'" + this.column.getId() + "' is not a sortable column (" + this.column.getTypeClass().getSimpleName() + ").");
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Number getMaxValue() {
        this.lock();
        try {
            if (this.isSortable()) {
                if (this.map.isEmpty()) {
                    Number number = null;
                    return number;
                }
                Number number = (Number)((SortedMap)this.map).lastKey();
                return number;
            }
            throw new UnsupportedOperationException("'" + this.column.getId() + "' is not a sortable column (" + this.column.getTypeClass().getSimpleName() + ").");
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void destroy() {
        this.lock();
        this.map = null;
        this.nullSet.clear();
        this.elements = 0;
        this.version.incrementAndGet();
        this.unlock();
    }

    @Override
    public void clear() {
        this.lock();
        this.map.clear();
        this.nullSet.clear();
        this.elements = 0;
        this.version.incrementAndGet();
        this.unlock();
    }

    @Override
    public Iterator<Map.Entry<K, ? extends Set<T>>> iterator() {
        return new EntryIterator();
    }

    @Override
    public Iterable<T> get(K value) {
        this.lock();
        ValueSet<K, T> valueSet = this.getValueSet(value);
        if (valueSet == null) {
            return ValueSet.EMPTY;
        }
        return new LockableIterable(valueSet.set);
    }

    protected ValueSet<K, T> getValueSet(K value) {
        if (value == null) {
            return this.nullSet;
        }
        return this.map.get(value);
    }

    protected void removeValue(K value) {
        this.map.remove(value);
    }

    protected ValueSet<K, T> addValue(K value) {
        ValueSet valueSet = new ValueSet(value);
        this.map.put(value, valueSet);
        return valueSet;
    }

    @Override
    public boolean isSortable() {
        return Number.class.isAssignableFrom(this.column.getTypeClass()) && this.map instanceof SortedMap;
    }

    @Override
    public ColumnImpl getColumn() {
        return this.column;
    }

    @Override
    public int getVersion() {
        return this.version.get();
    }

    void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    protected static final class ValueSet<K, T>
    implements Set<T> {
        protected static ValueSet EMPTY = new ValueSet(null);
        protected final K value;
        private final Set<T> set;

        public ValueSet(K value) {
            this.value = value;
            this.set = new ObjectOpenHashSet();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return this.set.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            return this.set.toArray(ts);
        }

        @Override
        public boolean add(T e) {
            return this.set.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.set.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> clctn) {
            return this.set.containsAll(clctn);
        }

        @Override
        public boolean addAll(Collection<? extends T> clctn) {
            throw new UnsupportedOperationException("Not supported operation.");
        }

        @Override
        public boolean retainAll(Collection<?> clctn) {
            throw new UnsupportedOperationException("Not supported operation.");
        }

        @Override
        public boolean removeAll(Collection<?> clctn) {
            throw new UnsupportedOperationException("Not supported operation.");
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.set.equals(o);
        }

        @Override
        public int hashCode() {
            return this.set.hashCode();
        }
    }

    protected final class WithNullDecorator
    implements Collection<K> {
        protected WithNullDecorator() {
        }

        private boolean hasNull() {
            return !ColumnStandardIndexImpl.this.nullSet.isEmpty();
        }

        @Override
        public int size() {
            return (this.hasNull() ? 1 : 0) + ColumnStandardIndexImpl.this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return !this.hasNull() && ColumnStandardIndexImpl.this.map.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null && this.hasNull()) {
                return true;
            }
            if (o != null) {
                return ColumnStandardIndexImpl.this.map.containsKey(o);
            }
            return false;
        }

        @Override
        public Iterator<K> iterator() {
            return new WithNullIterator();
        }

        @Override
        public Object[] toArray() {
            if (this.hasNull()) {
                Object[] res = new Object[ColumnStandardIndexImpl.this.map.size() + 1];
                res[0] = null;
                System.arraycopy(ColumnStandardIndexImpl.this.map.keySet().toArray(), 0, res, 1, ColumnStandardIndexImpl.this.map.size());
                return res;
            }
            return ColumnStandardIndexImpl.this.map.keySet().toArray();
        }

        @Override
        public <V> V[] toArray(V[] array) {
            if (this.hasNull()) {
                if (array.length < this.size()) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), ColumnStandardIndexImpl.this.map.size() + 1);
                }
                array[0] = null;
                System.arraycopy(ColumnStandardIndexImpl.this.map.keySet().toArray(), 0, array, 1, ColumnStandardIndexImpl.this.map.size());
                return array;
            }
            return ColumnStandardIndexImpl.this.map.keySet().toArray(array);
        }

        @Override
        public boolean add(K e) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean containsAll(Collection clctn) {
            for (Object o : clctn) {
                if (o == null && ColumnStandardIndexImpl.this.nullSet.isEmpty()) {
                    return false;
                }
                if (o == null || ColumnStandardIndexImpl.this.map.containsKey(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection clctn) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean removeAll(Collection clctn) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean retainAll(Collection clctn) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported");
        }

        private final class WithNullIterator
        implements Iterator<K> {
            private final Iterator<K> mapIterator;
            private boolean hasNull;

            public WithNullIterator() {
                this.hasNull = WithNullDecorator.this.hasNull();
                this.mapIterator = ColumnStandardIndexImpl.this.map.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.hasNull) {
                    return true;
                }
                return this.mapIterator.hasNext();
            }

            @Override
            public K next() {
                if (this.hasNull) {
                    this.hasNull = false;
                    return null;
                }
                return this.mapIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported operation.");
            }
        }
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<K, ? extends Set<T>>> {
        private final Iterator<Map.Entry<K, ValueSet<K, T>>> mapIterator;
        private NullEntry nullEntry;

        public EntryIterator() {
            if (!ColumnStandardIndexImpl.this.nullSet.isEmpty()) {
                this.nullEntry = new NullEntry();
            }
            this.mapIterator = ColumnStandardIndexImpl.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.nullEntry != null) {
                return true;
            }
            return this.mapIterator.hasNext();
        }

        @Override
        public Map.Entry<K, ? extends Set<T>> next() {
            if (this.nullEntry != null) {
                NullEntry ne = this.nullEntry;
                this.nullEntry = null;
                return ne;
            }
            return this.mapIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported operation.");
        }
    }

    private class LockableIterable<E>
    implements Iterable<E> {
        private final Iterable<E> ite;

        public LockableIterable(Iterable<E> ite) {
            this.ite = ite;
        }

        @Override
        public Iterator<E> iterator() {
            return new LockableIterator<E>(this.ite.iterator());
        }
    }

    private class LockableIterator<E>
    implements Iterator<E> {
        private final Iterator<E> itr;

        public LockableIterator(Iterator<E> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            boolean n = this.itr.hasNext();
            if (!n && ColumnStandardIndexImpl.this.lock != null) {
                ColumnStandardIndexImpl.this.lock.unlock();
            }
            return n;
        }

        @Override
        public E next() {
            return this.itr.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private class NullEntry
    implements Map.Entry<K, Set<T>> {
        private NullEntry() {
        }

        @Override
        public K getKey() {
            return null;
        }

        @Override
        public Set<T> getValue() {
            return ColumnStandardIndexImpl.this.nullSet;
        }

        @Override
        public Set<T> setValue(Set<T> v) {
            throw new UnsupportedOperationException("Not supported operation.");
        }
    }

    protected static class CharArrayStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<char[], T> {
        public CharArrayStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(CharArrays.HASH_STRATEGY);
        }
    }

    protected static class ByteArrayStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<byte[], T> {
        public ByteArrayStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(ByteArrays.HASH_STRATEGY);
        }
    }

    protected static class ShortArrayStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<short[], T> {
        public ShortArrayStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(ShortArrays.HASH_STRATEGY);
        }
    }

    protected static class LongArrayStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<long[], T> {
        public LongArrayStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(LongArrays.HASH_STRATEGY);
        }
    }

    protected static class FloatArrayStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<float[], T> {
        public FloatArrayStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(FloatArrays.HASH_STRATEGY);
        }
    }

    protected static class IntegerArrayStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<int[], T> {
        public IntegerArrayStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(IntArrays.HASH_STRATEGY);
        }
    }

    protected static class DoubleArrayStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<double[], T> {
        public DoubleArrayStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(DoubleArrays.HASH_STRATEGY);
        }
    }

    protected static class BooleanArrayStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<boolean[], T> {
        public BooleanArrayStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(BooleanArrays.HASH_STRATEGY);
        }
    }

    protected static class DefaultArrayStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<Object[], T> {
        public DefaultArrayStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(ObjectArrays.HASH_STRATEGY);
        }
    }

    protected static class CharStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<Character, T> {
        public CharStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Char2ObjectAVLTreeMap();
        }
    }

    protected static class GenericNumberStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<Number, T> {
        public GenericNumberStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectAVLTreeMap();
        }
    }

    protected static class ByteStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<Byte, T> {
        public ByteStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Byte2ObjectAVLTreeMap();
        }
    }

    protected static class ShortStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<Short, T> {
        public ShortStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Short2ObjectAVLTreeMap();
        }
    }

    protected static class LongStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<Long, T> {
        public LongStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Long2ObjectAVLTreeMap();
        }
    }

    protected static class FloatStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<Float, T> {
        public FloatStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Float2ObjectAVLTreeMap();
        }
    }

    protected static class IntegerStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<Integer, T> {
        public IntegerStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Int2ObjectAVLTreeMap();
        }
    }

    protected static class DoubleStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<Double, T> {
        public DoubleStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Double2ObjectAVLTreeMap();
        }
    }

    protected static class BooleanStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<Boolean, T> {
        public BooleanStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenHashMap();
        }
    }

    protected static class DefaultStandardIndex<T extends Element>
    extends ColumnStandardIndexImpl<Object, T> {
        public DefaultStandardIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenHashMap();
        }
    }
}

