/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.BitSet;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnDiff;
import org.gephi.graph.api.ColumnObserver;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.EdgeIterableWrapper;
import org.gephi.graph.impl.ElementImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.NodeIterableWrapper;

public class ColumnObserverImpl
implements ColumnObserver {
    protected final GraphStore graphStore;
    protected final ColumnImpl column;
    protected int version = Integer.MIN_VALUE;
    protected boolean destroyed;
    protected final boolean withDiff;
    protected BitSet bitVector;
    protected ColumnDiffImpl columnDiff;

    public ColumnObserverImpl(GraphStore store, ColumnImpl column, boolean withDiff) {
        this.column = column;
        this.graphStore = store;
        this.version = column.version.version.get();
        this.withDiff = withDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasColumnChanged() {
        if (!this.destroyed) {
            this.readLock();
            try {
                int v = this.column.version.version.get();
                boolean changed = v != this.version;
                this.version = v;
                if (this.withDiff && changed) {
                    this.refreshDiff();
                }
                boolean bl = changed;
                return bl;
            }
            finally {
                this.readUnlock();
            }
        }
        return false;
    }

    @Override
    public ColumnDiff getDiff() {
        if (!this.withDiff) {
            throw new RuntimeException("This observer doesn't compute diffs, set diff setting to true");
        }
        if (this.columnDiff == null) {
            throw new IllegalStateException("The hasGraphChanged() method should be called first and getDiff() only once then");
        }
        ColumnDiffImpl diff = this.columnDiff;
        this.columnDiff = null;
        return diff;
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    @Override
    public void destroy() {
        this.column.destroyColumnObserver(this);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void destroyObserver() {
        this.destroyed = true;
        this.columnDiff = null;
        this.bitVector = null;
    }

    private void refreshDiff() {
        boolean node = AttributeUtils.isNodeColumn(this.column);
        this.columnDiff = node ? new NodeColumnDiffImpl() : new EdgeColumnDiffImpl();
        int size = this.bitVector.length();
        for (int i = 0; i < size; ++i) {
            EdgeImpl e;
            boolean t = this.bitVector.get(i);
            if (t && node) {
                NodeImpl n;
                if (!this.graphStore.nodeStore.isValidIndex(i) || (n = this.graphStore.nodeStore.get(i)).getStoreId() != i) continue;
                this.columnDiff.addElement(n);
                continue;
            }
            if (!t || node || !this.graphStore.edgeStore.isValidIndex(i) || (e = this.graphStore.edgeStore.get(i)).getStoreId() != i) continue;
            this.columnDiff.addElement(e);
        }
        this.bitVector.clear();
    }

    protected void setElement(ElementImpl element) {
        int storeId = element.getStoreId();
        this.ensureVectorSize(element);
        this.bitVector.set(storeId);
    }

    private void ensureVectorSize(ElementImpl element) {
        int sid = element.getStoreId();
        if (this.bitVector == null) {
            int initialSize = Math.min(Math.max(sid + 1, (int)((double)sid * 1.1)), Integer.MAX_VALUE);
            this.bitVector = new BitSet(initialSize);
        }
    }

    private void readLock() {
        this.graphStore.autoReadLock();
    }

    private void readUnlock() {
        this.graphStore.autoReadUnlock();
    }

    protected abstract class ColumnDiffImpl<K extends Element>
    implements ColumnDiff {
        protected final ObjectList<K> touchedElements = new ObjectArrayList();

        protected void addElement(K element) {
            this.touchedElements.add(element);
        }
    }

    protected final class NodeColumnDiffImpl
    extends ColumnDiffImpl<Node> {
        protected NodeColumnDiffImpl() {
        }

        public NodeIterable getTouchedElements() {
            if (!this.touchedElements.isEmpty()) {
                return new NodeIterableWrapper(() -> ObjectLists.unmodifiable((ObjectList)this.touchedElements).iterator(), () -> ObjectLists.unmodifiable((ObjectList)this.touchedElements).spliterator(), null);
            }
            return NodeIterable.NodeIterableEmpty.EMPTY;
        }
    }

    protected final class EdgeColumnDiffImpl
    extends ColumnDiffImpl<Edge> {
        protected EdgeColumnDiffImpl() {
        }

        public EdgeIterable getTouchedElements() {
            if (!this.touchedElements.isEmpty()) {
                return new EdgeIterableWrapper(() -> ObjectLists.unmodifiable((ObjectList)this.touchedElements).iterator(), () -> ObjectLists.unmodifiable((ObjectList)this.touchedElements).spliterator(), null);
            }
            return EdgeIterable.EdgeIterableEmpty.EMPTY;
        }
    }
}

