/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.TimestampMap;

public final class TimestampShortMap
extends TimestampMap<Short> {
    private short[] values;

    public TimestampShortMap() {
        this.values = new short[0];
    }

    public TimestampShortMap(int capacity) {
        super(capacity);
        this.values = new short[capacity];
    }

    public TimestampShortMap(double[] keys, short[] vals) {
        super(keys);
        this.values = new short[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public TimestampShortMap(TimestampShortMap source) {
        this(source.array, source.values);
    }

    public short getShort(double timestamp) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public short getShort(double timestamp, short defaultValue) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    protected Object getMax(Interval interval) {
        Double max = this.getMaxDouble(interval);
        return max != null ? Short.valueOf(max.shortValue()) : null;
    }

    @Override
    protected Object getMin(Interval interval) {
        Double min = this.getMinDouble(interval);
        return min != null ? Short.valueOf(min.shortValue()) : null;
    }

    @Override
    public Class<Short> getTypeClass() {
        return Short.class;
    }

    public short[] toShortArray() {
        return (short[])this.toPrimitiveArray();
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST, Estimator.AVERAGE);
    }

    @Override
    protected Short getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (short[])array;
    }
}

