/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalMap;

public final class IntervalByteMap
extends IntervalMap<Byte> {
    private byte[] values;

    public IntervalByteMap() {
        this.values = new byte[0];
    }

    public IntervalByteMap(int capacity) {
        super(capacity);
        this.values = new byte[capacity];
    }

    public IntervalByteMap(double[] keys, byte[] vals) {
        super(keys);
        this.values = new byte[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public IntervalByteMap(IntervalByteMap source) {
        this(source.array, source.values);
    }

    public byte getByte(Interval interval) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public byte getByte(Interval interval, byte defaultValue) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        return defaultValue;
    }

    public byte[] toByteArray() {
        return (byte[])this.toNativeArray();
    }

    @Override
    public Class<Byte> getTypeClass() {
        return Byte.class;
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST, Estimator.AVERAGE);
    }

    @Override
    protected Object getMax(Interval interval) {
        Double max = this.getMaxDouble(interval);
        return max != null ? Byte.valueOf(max.byteValue()) : null;
    }

    @Override
    protected Object getMin(Interval interval) {
        Double min = this.getMinDouble(interval);
        return min != null ? Byte.valueOf(min.byteValue()) : null;
    }

    @Override
    protected Object getAverage(Interval interval) {
        Double average = this.getAverageDouble(interval);
        return average != null ? average : null;
    }

    @Override
    protected Byte getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (byte[])array;
    }
}

