/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class Rect2D {
    public final float minX;
    public final float minY;
    public final float maxX;
    public final float maxY;
    private static final DecimalFormat FORMAT = new DecimalFormat("0.###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public Rect2D(Rect2D source) {
        this.minX = source.minX;
        this.minY = source.minY;
        this.maxX = source.maxX;
        this.maxY = source.maxY;
    }

    public Rect2D(float minX, float minY, float maxX, float maxY) {
        if (minX > maxX) {
            throw new IllegalArgumentException("minX > maxX");
        }
        if (minY > maxY) {
            throw new IllegalArgumentException("minX > maxX");
        }
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public float width() {
        return this.maxX - this.minX;
    }

    public float height() {
        return this.maxY - this.minY;
    }

    public float[] center() {
        return new float[]{(this.maxX + this.minX) / 2.0f, (this.maxY + this.minY) / 2.0f};
    }

    public float radius() {
        float width = this.width();
        float height = this.height();
        return (float)Math.sqrt(width * width + height * height) / 2.0f;
    }

    public String toString() {
        return this.toString(FORMAT);
    }

    private String toString(NumberFormat formatter) {
        return "min(x:" + formatter.format(this.minX) + " y:" + formatter.format(this.minY) + ") < max(x:" + formatter.format(this.maxX) + " y:" + formatter.format(this.maxY) + ")";
    }

    public boolean contains(Rect2D rect) {
        if (rect == this) {
            return true;
        }
        return this.contains(rect.minX, rect.minY, rect.maxX, rect.maxY);
    }

    public boolean intersects(Rect2D rect) {
        if (rect == this) {
            return true;
        }
        return this.intersects(rect.minX, rect.minY, rect.maxX, rect.maxY);
    }

    public boolean contains(float minX, float minY, float maxX, float maxY) {
        return this.minX <= minX && this.minY <= minY && this.maxX >= maxX && this.maxY >= maxY;
    }

    public boolean intersects(float minX, float minY, float maxX, float maxY) {
        return this.minX <= maxX && minX <= this.maxX && this.maxY >= minY && maxY >= this.minY;
    }

    public boolean containsOrIntersects(Rect2D rect) {
        if (rect == this) {
            return true;
        }
        return this.containsOrIntersects(rect.minX, rect.minY, rect.maxX, rect.maxY);
    }

    public boolean containsOrIntersects(float minX, float minY, float maxX, float maxY) {
        return this.minX <= maxX && minX <= this.maxX && this.maxY >= minY && maxY >= this.minY;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Rect2D rect2D = (Rect2D)obj;
        return Float.compare(rect2D.minX, this.minX) == 0 && Float.compare(rect2D.minY, this.minY) == 0 && Float.compare(rect2D.maxX, this.maxX) == 0 && Float.compare(rect2D.maxY, this.maxY) == 0;
    }

    public int hashCode() {
        int result = this.minX != 0.0f ? Float.floatToIntBits(this.minX) : 0;
        result = 31 * result + (this.minY != 0.0f ? Float.floatToIntBits(this.minY) : 0);
        result = 31 * result + (this.maxX != 0.0f ? Float.floatToIntBits(this.maxX) : 0);
        result = 31 * result + (this.maxY != 0.0f ? Float.floatToIntBits(this.maxY) : 0);
        return result;
    }
}

