/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.api.Node;

public interface NodeIterable
extends ElementIterable<Node> {
    public static final NodeIterable EMPTY = new NodeIterableEmpty();

    @Override
    public Iterator<Node> iterator();

    public Node[] toArray();

    @Override
    public Collection<Node> toCollection();

    @Override
    public Set<Node> toSet();

    @Override
    default public Spliterator<Node> spliterator() {
        return ElementIterable.super.spliterator();
    }

    public static final class NodeIterableEmpty
    implements Iterator<Node>,
    NodeIterable {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Node next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Iterator<Node> iterator() {
            return this;
        }

        @Override
        public Spliterator<Node> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        public Node[] toArray() {
            return new Node[0];
        }

        @Override
        public Collection<Node> toCollection() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public Set<Node> toSet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public void doBreak() {
        }
    }
}

