/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.ZoneId;
import java.util.function.Predicate;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphBridge;
import org.gephi.graph.api.GraphFactory;
import org.gephi.graph.api.GraphObserver;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Index;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Subgraph;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeIndex;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.graph.api.UndirectedSubgraph;
import org.gephi.graph.impl.GraphModelImpl;

public interface GraphModel {
    public GraphFactory factory();

    public GraphBridge bridge();

    public Graph getGraph();

    public Graph getGraphVisible();

    public Subgraph getGraph(GraphView var1);

    public DirectedGraph getDirectedGraph();

    public DirectedGraph getDirectedGraphVisible();

    public UndirectedGraph getUndirectedGraph();

    public UndirectedGraph getUndirectedGraphVisible();

    public DirectedSubgraph getDirectedGraph(GraphView var1);

    public UndirectedSubgraph getUndirectedGraph(GraphView var1);

    public GraphView getVisibleView();

    public void setVisibleView(GraphView var1);

    public DefaultColumns defaultColumns();

    public int addEdgeType(Object var1);

    public int getEdgeType(Object var1);

    public Object getEdgeTypeLabel(int var1);

    public int getEdgeTypeCount();

    public int[] getEdgeTypes();

    public Object[] getEdgeTypeLabels();

    public Object[] getEdgeTypeLabels(boolean var1);

    public boolean isDirected();

    public boolean isUndirected();

    public boolean isMixed();

    public boolean isDynamic();

    public boolean isMultiGraph();

    public GraphView createView();

    public GraphView createView(Predicate<Node> var1, Predicate<Edge> var2);

    public GraphView createView(boolean var1, boolean var2);

    public GraphView copyView(GraphView var1);

    public GraphView copyView(GraphView var1, boolean var2, boolean var3);

    public void destroyView(GraphView var1);

    public void setTimeInterval(GraphView var1, Interval var2);

    public Table getNodeTable();

    public Table getEdgeTable();

    public Index<Node> getNodeIndex();

    public Index<Node> getNodeIndex(GraphView var1);

    public Index<Edge> getEdgeIndex();

    public Index<Edge> getEdgeIndex(GraphView var1);

    public Index<Element> getElementIndex(Table var1);

    public Index<Element> getElementIndex(Table var1, GraphView var2);

    public TimeIndex<Node> getNodeTimeIndex();

    public TimeIndex<Node> getNodeTimeIndex(GraphView var1);

    public TimeIndex<Edge> getEdgeTimeIndex();

    public TimeIndex<Edge> getEdgeTimeIndex(GraphView var1);

    public Interval getTimeBounds();

    public Interval getTimeBoundsVisible();

    public Interval getTimeBounds(GraphView var1);

    public GraphObserver createGraphObserver(Graph var1, boolean var2);

    public TimeFormat getTimeFormat();

    public void setTimeFormat(TimeFormat var1);

    public ZoneId getTimeZone();

    public void setTimeZone(ZoneId var1);

    public Configuration getConfiguration();

    @Deprecated
    public void setConfiguration(Configuration var1);

    public int getMaxNodeStoreId();

    public int getMaxEdgeStoreId();

    public static interface DefaultColumns {
        public Column nodeId();

        public Column edgeId();

        public Column nodeLabel();

        public Column edgeLabel();

        public Column edgeWeight();

        public Column nodeTimeSet();

        public Column edgeTimeSet();

        public Column degree();

        public Column inDegree();

        public Column outDegree();

        public Column edgeType();
    }

    public static class Serialization {
        public static GraphModel read(DataInput input) throws IOException {
            try {
                org.gephi.graph.impl.Serialization s = new org.gephi.graph.impl.Serialization();
                return s.deserializeGraphModel(input);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public static GraphModel read(DataInput input, GraphModel graphModel) throws IOException {
            try {
                org.gephi.graph.impl.Serialization s = new org.gephi.graph.impl.Serialization();
                return s.deserializeGraphModel(input, graphModel);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public static GraphModel readWithoutVersionHeader(DataInput input, float graphStoreVersion) throws IOException {
            try {
                org.gephi.graph.impl.Serialization s = new org.gephi.graph.impl.Serialization();
                return s.deserializeGraphModelWithoutVersionPrefix(input, graphStoreVersion);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public static void write(DataOutput output, GraphModel graphModel) throws IOException {
            org.gephi.graph.impl.Serialization s = new org.gephi.graph.impl.Serialization();
            s.serializeGraphModel(output, (GraphModelImpl)graphModel);
        }
    }

    public static class Factory {
        public static GraphModelImpl newInstance() {
            return new GraphModelImpl();
        }

        public static GraphModelImpl newInstance(Configuration config) {
            return new GraphModelImpl(config);
        }
    }
}

