/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.ElementIterable;

public interface EdgeIterable
extends ElementIterable<Edge> {
    public static final EdgeIterable EMPTY = new EdgeIterableEmpty();

    @Override
    public Iterator<Edge> iterator();

    public Edge[] toArray();

    @Override
    public Collection<Edge> toCollection();

    @Override
    public Set<Edge> toSet();

    @Override
    default public Spliterator<Edge> spliterator() {
        return ElementIterable.super.spliterator();
    }

    public static final class EdgeIterableEmpty
    implements Iterator<Edge>,
    EdgeIterable {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Edge next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Iterator<Edge> iterator() {
            return this;
        }

        @Override
        public Spliterator<Edge> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        public Edge[] toArray() {
            return new Edge[0];
        }

        @Override
        public Collection<Edge> toCollection() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public Set<Edge> toSet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public void doBreak() {
        }
    }
}

