/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.appearance;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.spi.TransformerCategory;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.desktop.appearance.AppearanceUIController;
import org.gephi.desktop.appearance.AppearanceUIModel;
import org.gephi.desktop.appearance.AppearanceUIModelEvent;
import org.gephi.desktop.appearance.AppearanceUIModelListener;
import org.gephi.ui.utils.UIUtils;
import org.openide.util.NbBundle;

public class AppearanceToolbar
implements AppearanceUIModelListener {
    protected final AppearanceUIController controller;
    private final CategoryToolbar categoryToolbar;
    private final TransformerToolbar transformerToolbar;
    private final ControlToolbar controlToolbar;
    protected AppearanceUIModel model;

    public AppearanceToolbar(AppearanceUIController controller) {
        this.controller = controller;
        this.categoryToolbar = new CategoryToolbar();
        this.transformerToolbar = new TransformerToolbar();
        this.controlToolbar = new ControlToolbar();
        controller.addPropertyChangeListener(this);
        AppearanceUIModel uimodel = controller.getModel();
        if (uimodel != null) {
            this.setup(uimodel);
        }
    }

    public JToolBar getCategoryToolbar() {
        return this.categoryToolbar;
    }

    public JToolBar getTransformerToolbar() {
        return this.transformerToolbar;
    }

    public JToolBar getControlToolbar() {
        return this.controlToolbar;
    }

    public void addRankingControl(AbstractButton btn) {
        this.controlToolbar.addRankingButton(btn);
    }

    public void addPartitionControl(AbstractButton btn) {
        this.controlToolbar.addPartitionButton(btn);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals(AppearanceUIModelEvent.MODEL)) {
            this.setup((AppearanceUIModel)pce.getNewValue());
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.SELECTED_ELEMENT_CLASS)) {
            this.refreshSelectedElementClass((String)pce.getNewValue());
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.SELECTED_CATEGORY)) {
            this.refreshSelectedCategory((TransformerCategory)pce.getNewValue());
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.SELECTED_FUNCTION)) {
            this.refreshSelectedFunction((Function)pce.getNewValue());
        } else if (pce.getPropertyName().equals(AppearanceUIModelEvent.SELECTED_TRANSFORMER_UI)) {
            this.refreshSelectedTransformerUI();
        }
    }

    private void setup(final AppearanceUIModel model) {
        this.model = model;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppearanceToolbar.this.categoryToolbar.setEnabled(model != null);
                AppearanceToolbar.this.categoryToolbar.setup();
                AppearanceToolbar.this.categoryToolbar.refreshSelectedElmntGroup();
                AppearanceToolbar.this.categoryToolbar.refreshTransformers();
                AppearanceToolbar.this.transformerToolbar.setEnabled(model != null);
                AppearanceToolbar.this.transformerToolbar.setup();
                AppearanceToolbar.this.transformerToolbar.refreshTransformers();
                AppearanceToolbar.this.controlToolbar.setEnabled(model != null);
                AppearanceToolbar.this.controlToolbar.setup();
                AppearanceToolbar.this.controlToolbar.refreshControls();
            }
        });
    }

    private void refreshSelectedElementClass(String elementClass) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppearanceToolbar.this.categoryToolbar.refreshSelectedElmntGroup();
                AppearanceToolbar.this.categoryToolbar.refreshTransformers();
                AppearanceToolbar.this.transformerToolbar.refreshTransformers();
                AppearanceToolbar.this.controlToolbar.refreshControls();
            }
        });
    }

    private void refreshSelectedCategory(TransformerCategory category) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppearanceToolbar.this.categoryToolbar.refreshTransformers();
                AppearanceToolbar.this.transformerToolbar.refreshTransformers();
                AppearanceToolbar.this.controlToolbar.refreshControls();
            }
        });
    }

    private void refreshSelectedFunction(Function ui) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppearanceToolbar.this.transformerToolbar.refreshTransformers();
                AppearanceToolbar.this.controlToolbar.refreshControls();
            }
        });
    }

    private void refreshSelectedTransformerUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppearanceToolbar.this.controlToolbar.refreshControls();
            }
        });
    }

    private void fixAquaSelectedState(final JToggleButton btn) {
        if (UIUtils.isAquaLookAndFeel()) {
            btn.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        Font font = btn.getFont().deriveFont(Collections.singletonMap(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD));
                        btn.setFont(font);
                    } else {
                        Font font = btn.getFont().deriveFont(Collections.singletonMap(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR));
                        btn.setFont(font);
                    }
                }
            });
        }
    }

    private class CategoryToolbar
    extends AbstractToolbar {
        private final List<ButtonGroup> buttonGroups;
        private final JLabel box;
        private final ButtonGroup elementGroup;

        public CategoryToolbar() {
            this.buttonGroups = new ArrayList<ButtonGroup>();
            this.elementGroup = new ButtonGroup();
            for (final String elmtType : AppearanceUIController.ELEMENT_CLASSES) {
                JToggleButton btn = new JToggleButton();
                btn.setFocusPainted(false);
                String btnLabel = elmtType;
                try {
                    btnLabel = NbBundle.getMessage(AppearanceToolbar.class, (String)("AppearanceToolbar." + elmtType + ".label"));
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                btn.setText(btnLabel);
                btn.setEnabled(false);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AppearanceToolbar.this.controller.setSelectedElementClass(elmtType);
                    }
                });
                AppearanceToolbar.this.fixAquaSelectedState(btn);
                this.elementGroup.add(btn);
                this.add(btn);
            }
            this.box = new JLabel();
            this.addSeparator();
            this.box.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            this.add(this.box);
        }

        private void clear() {
            for (ButtonGroup bg : this.buttonGroups) {
                Enumeration<AbstractButton> btns = bg.getElements();
                while (btns.hasMoreElements()) {
                    AbstractButton btn = btns.nextElement();
                    this.remove(btn);
                }
            }
            this.buttonGroups.clear();
        }

        protected void setup() {
            this.clear();
            if (AppearanceToolbar.this.model != null) {
                for (String elmtType : AppearanceUIController.ELEMENT_CLASSES) {
                    ButtonGroup buttonGroup = new ButtonGroup();
                    for (final TransformerCategory c : AppearanceToolbar.this.controller.getCategories(elmtType)) {
                        Icon icon = c.getIcon();
                        JToggleButton btn = new JToggleButton(icon);
                        btn.setToolTipText(c.getDisplayName());
                        btn.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                AppearanceToolbar.this.controller.setSelectedCategory(c);
                            }
                        });
                        btn.setName(c.getDisplayName());
                        btn.setFocusPainted(false);
                        buttonGroup.add(btn);
                        this.add(btn);
                    }
                    this.buttonGroups.add(buttonGroup);
                }
            } else {
                this.elementGroup.clearSelection();
            }
        }

        protected void refreshTransformers() {
            if (AppearanceToolbar.this.model != null) {
                int index = 0;
                for (String elmtType : AppearanceUIController.ELEMENT_CLASSES) {
                    ButtonGroup g = this.buttonGroups.get(index);
                    boolean active = AppearanceToolbar.this.model.getSelectedElementClass().equals(elmtType);
                    g.clearSelection();
                    TransformerCategory c = AppearanceToolbar.this.model.getSelectedCategory();
                    String selected = c.getDisplayName();
                    Enumeration<AbstractButton> btns = g.getElements();
                    while (btns.hasMoreElements()) {
                        AbstractButton btn = btns.nextElement();
                        btn.setVisible(active);
                        if (!active || !btn.getName().equals(selected)) continue;
                        g.setSelected(btn.getModel(), true);
                    }
                    ++index;
                }
            }
        }

        protected void refreshSelectedElmntGroup() {
            String selected = AppearanceToolbar.this.model == null ? null : AppearanceToolbar.this.model.getSelectedElementClass();
            ButtonModel buttonModel = null;
            Enumeration<AbstractButton> en = this.elementGroup.getElements();
            for (String elmtType : AppearanceUIController.ELEMENT_CLASSES) {
                if (selected == null || elmtType.equals(selected)) {
                    buttonModel = en.nextElement().getModel();
                    break;
                }
                en.nextElement();
            }
            this.elementGroup.setSelected(buttonModel, true);
        }
    }

    private class TransformerToolbar
    extends AbstractToolbar {
        private final List<ButtonGroup> buttonGroups;

        public TransformerToolbar() {
            this.buttonGroups = new ArrayList<ButtonGroup>();
        }

        private void clear() {
            for (ButtonGroup bg : this.buttonGroups) {
                Enumeration<AbstractButton> btns = bg.getElements();
                while (btns.hasMoreElements()) {
                    AbstractButton btn = btns.nextElement();
                    this.remove(btn);
                }
            }
            this.buttonGroups.clear();
        }

        protected void setup() {
            this.clear();
            if (AppearanceToolbar.this.model != null) {
                for (String elmtType : AppearanceUIController.ELEMENT_CLASSES) {
                    for (TransformerCategory c : AppearanceToolbar.this.controller.getCategories(elmtType)) {
                        ButtonGroup buttonGroup = new ButtonGroup();
                        LinkedHashMap<String, TransformerUI> titles = new LinkedHashMap<String, TransformerUI>();
                        for (TransformerUI transformerUI : AppearanceToolbar.this.controller.getTransformerUIs(elmtType, c)) {
                            titles.put(transformerUI.getDisplayName(), transformerUI);
                        }
                        for (Map.Entry entry : titles.entrySet()) {
                            final TransformerUI value = (TransformerUI)entry.getValue();
                            Icon icon = ((TransformerUI)entry.getValue()).getIcon();
                            JToggleButton btn = new JToggleButton(icon);
                            btn.setToolTipText(((TransformerUI)entry.getValue()).getDescription());
                            btn.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    AppearanceToolbar.this.controller.setSelectedTransformerUI(value);
                                }
                            });
                            AppearanceToolbar.this.fixAquaSelectedState(btn);
                            btn.setName((String)entry.getKey());
                            btn.setText((String)entry.getKey());
                            btn.setFocusPainted(false);
                            buttonGroup.add(btn);
                            this.add(btn);
                        }
                        this.buttonGroups.add(buttonGroup);
                    }
                }
            }
        }

        protected void refreshTransformers() {
            if (AppearanceToolbar.this.model != null) {
                int index = 0;
                for (String elmtType : AppearanceUIController.ELEMENT_CLASSES) {
                    for (TransformerCategory c : AppearanceToolbar.this.controller.getCategories(elmtType)) {
                        ButtonGroup g = this.buttonGroups.get(index);
                        boolean active = AppearanceToolbar.this.model.getSelectedElementClass().equals(elmtType) && AppearanceToolbar.this.model.getSelectedCategory().equals(c);
                        g.clearSelection();
                        TransformerUI t = AppearanceToolbar.this.model.getSelectedTransformerUI();
                        Enumeration<AbstractButton> btns = g.getElements();
                        while (btns.hasMoreElements()) {
                            AbstractButton btn = btns.nextElement();
                            btn.setVisible(active);
                            if (t == null || !active || !btn.getName().equals(t.getDisplayName())) continue;
                            g.setSelected(btn.getModel(), true);
                        }
                        ++index;
                    }
                }
            }
        }
    }

    private class ControlToolbar
    extends AbstractToolbar {
        private final transient Set<AbstractButton> rankingSouthControls;
        private final transient Set<AbstractButton> partitionSouthControls;
        private final transient Set<AbstractButton> controlButtons;

        public ControlToolbar() {
            this.rankingSouthControls = new LinkedHashSet<AbstractButton>();
            this.partitionSouthControls = new LinkedHashSet<AbstractButton>();
            this.controlButtons = new LinkedHashSet<AbstractButton>();
        }

        public void addRankingButton(AbstractButton btn) {
            this.removeAll();
            this.rankingSouthControls.add(btn);
        }

        public void addPartitionButton(AbstractButton btn) {
            this.removeAll();
            this.partitionSouthControls.add(btn);
        }

        private void clear() {
            for (AbstractButton btn : this.rankingSouthControls) {
                this.remove(btn);
            }
            for (AbstractButton btn : this.partitionSouthControls) {
                this.remove(btn);
            }
        }

        private void clearControlButtons() {
            for (AbstractButton btn : this.controlButtons) {
                this.remove(btn);
            }
            this.controlButtons.clear();
        }

        protected void setup() {
            this.clear();
            if (AppearanceToolbar.this.model != null) {
                this.removeAll();
                for (AbstractButton btn : this.rankingSouthControls) {
                    this.add(btn);
                }
                for (AbstractButton btn : this.partitionSouthControls) {
                    if (this.rankingSouthControls.contains(btn)) continue;
                    this.add(btn);
                }
                JLabel box = new JLabel();
                box.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
                this.addSeparator();
                this.add(box);
            }
        }

        protected void refreshControls() {
            if (AppearanceToolbar.this.model != null) {
                AbstractButton[] bb;
                Function selectedColumn;
                for (AbstractButton btn : this.partitionSouthControls) {
                    btn.setVisible(false);
                }
                for (AbstractButton btn : this.rankingSouthControls) {
                    btn.setVisible(false);
                }
                TransformerUI u = AppearanceToolbar.this.model.getSelectedTransformerUI();
                if (u != null && AppearanceToolbar.this.model.isAttributeTransformerUI(u) && (selectedColumn = AppearanceToolbar.this.model.getSelectedFunction()) != null) {
                    if (selectedColumn.isRanking()) {
                        for (AbstractButton btn : this.rankingSouthControls) {
                            btn.setVisible(true);
                        }
                    } else if (selectedColumn.isPartition()) {
                        for (AbstractButton btn : this.partitionSouthControls) {
                            btn.setVisible(true);
                        }
                    }
                }
                this.clearControlButtons();
                if (u != null && (selectedColumn = AppearanceToolbar.this.model.getSelectedFunction()) != null && (bb = selectedColumn.getUI().getControlButton()) != null) {
                    for (AbstractButton b : bb) {
                        this.add(b);
                        b.setEnabled(true);
                        this.controlButtons.add(b);
                    }
                }
            }
        }
    }

    private class AbstractToolbar
    extends JToolBar {
        public AbstractToolbar() {
            this.setFloatable(false);
            this.setRollover(true);
            Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
            this.setBorder(b);
            this.setOpaque(true);
        }

        @Override
        public void setEnabled(final boolean enabled) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Component c : AbstractToolbar.this.getComponents()) {
                        c.setEnabled(enabled);
                    }
                }
            });
        }
    }
}

