/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.screenshot;

import java.awt.Cursor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.gephi.ui.utils.DialogFileFilter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.gephi.visualization.screenshot.ScreenshotControllerImpl;
import org.gephi.visualization.screenshot.ScreenshotModelImpl;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class ScreenshotTask
implements LongTask,
Runnable {
    private static final String DATE_FORMAT_NOW = "HHmmss";
    private ProgressTicket progressTicket;
    private final ScreenshotModelImpl model;
    private final JOGLRenderingTarget renderingTarget;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final BooleanSupplier isCancelled = this.cancelled::get;
    private File file;

    public ScreenshotTask(VizEngine<JOGLRenderingTarget, ?> engine, ScreenshotModelImpl model) {
        this.model = model;
        this.renderingTarget = (JOGLRenderingTarget)engine.getRenderingTarget();
    }

    @Override
    public void run() {
        this.beforeTaking();
        int scaleFactor = this.model.getScaleFactor();
        boolean transparentBackground = this.model.isTransparentBackground();
        try {
            BufferedImage image = (BufferedImage)this.renderingTarget.requestScreenshot(scaleFactor, transparentBackground, this.isCancelled).get();
            SwingUtilities.invokeAndWait(() -> {
                if (!this.model.isAutoSave()) {
                    String lastPathDefault = NbPreferences.forModule(ScreenshotTask.class).get("ScreenshotMaker_Last_Path_Default", null);
                    String lastPath = NbPreferences.forModule(ScreenshotTask.class).get("ScreenshotMaker_Last_Path", lastPathDefault);
                    JFileChooser chooser = new JFileChooser(lastPath);
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.setDialogTitle(NbBundle.getMessage(ScreenshotTask.class, (String)"ScreenshotMaker.filechooser.title"));
                    DialogFileFilter dialogFileFilter = new DialogFileFilter(NbBundle.getMessage(ScreenshotTask.class, (String)"ScreenshotMaker.filechooser.pngDescription"));
                    dialogFileFilter.addExtension("png");
                    chooser.addChoosableFileFilter((FileFilter)dialogFileFilter);
                    File selectedFile = new File(chooser.getCurrentDirectory(), ScreenshotTask.getDefaultFileName() + ".png");
                    chooser.setSelectedFile(selectedFile);
                    int returnFile = chooser.showSaveDialog(null);
                    if (returnFile == 0) {
                        this.file = chooser.getSelectedFile();
                        if (!this.file.getPath().endsWith(".png")) {
                            this.file = new File(this.file.getPath() + ".png");
                        }
                        NbPreferences.forModule(ScreenshotTask.class).put("ScreenshotMaker_Last_Path", this.file.getParentFile().getAbsolutePath());
                    } else {
                        this.file = null;
                    }
                } else {
                    this.file = new File(this.model.getDefaultDirectory(), ScreenshotTask.getDefaultFileName() + ".png");
                }
            });
            if (this.file != null) {
                ImageIO.write((RenderedImage)image, "png", this.file);
            }
        }
        catch (CancellationException e) {
            String msg = NbBundle.getMessage(ScreenshotControllerImpl.class, (String)"ScreenshotMaker.progress.cancelled");
            StatusDisplayer.getDefault().setStatusText(msg);
        }
        catch (IOException | InterruptedException | InvocationTargetException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.afterTaking();
        }
    }

    private void beforeTaking() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    private void afterTaking() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().setCursor(Cursor.getDefaultCursor());
                if (ScreenshotTask.this.file != null) {
                    if (ScreenshotTask.this.model.isAutoSave()) {
                        String msg = NbBundle.getMessage(ScreenshotControllerImpl.class, (String)"ScreenshotMaker.finishedMessage.message", (Object)ScreenshotTask.this.file.getAbsolutePath());
                        StatusDisplayer.getDefault().setStatusText(msg);
                    } else {
                        String msg = NbBundle.getMessage(ScreenshotControllerImpl.class, (String)"ScreenshotMaker.finishedMessage.message", (Object)ScreenshotTask.this.file.getName());
                        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), msg, NbBundle.getMessage(ScreenshotControllerImpl.class, (String)"ScreenshotMaker.finishedMessage.title"), 1);
                    }
                }
            }
        });
    }

    private static String getDefaultFileName() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_NOW);
        String datetime = dateFormat.format(cal.getTime());
        return "screenshot_" + datetime;
    }

    public boolean cancel() {
        this.cancelled.set(true);
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

