/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.screenshot;

import java.io.File;
import org.gephi.visualization.VizConfig;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.api.ScreenshotModel;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.screenshot.ScreenshotControllerImpl;
import org.openide.util.NbPreferences;

public class ScreenshotModelImpl
implements ScreenshotModel {
    protected static final String LAST_PATH = "ScreenshotMaker_Last_Path";
    protected static final String LAST_PATH_DEFAULT = "ScreenshotMaker_Last_Path_Default";
    private final VizModel vizModel;
    private int scaleFactor;
    private boolean transparentBackground;
    private boolean autoSave;
    private String defaultDirectory;

    public ScreenshotModelImpl(VizModel vizModel) {
        this.vizModel = vizModel;
        String lastPathDefault = NbPreferences.forModule(ScreenshotControllerImpl.class).get(LAST_PATH_DEFAULT, null);
        this.defaultDirectory = NbPreferences.forModule(ScreenshotControllerImpl.class).get(LAST_PATH, lastPathDefault);
        this.scaleFactor = VizConfig.getDefaultScreenshotScaleFactor();
        this.transparentBackground = VizConfig.isDefaultScreenshotTransparentBackground();
        this.autoSave = VizConfig.isDefaultScreenshotAutoSave();
    }

    public VisualizationModel getVisualizationModel() {
        return this.vizModel;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(int scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public String getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public void setDefaultDirectory(File directory) {
        if (directory != null && directory.exists()) {
            this.defaultDirectory = directory.getAbsolutePath();
            NbPreferences.forModule(ScreenshotControllerImpl.class).put(LAST_PATH, this.defaultDirectory);
        }
    }
}

