/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.screenshot;

import java.io.File;
import org.gephi.desktop.visualization.screenshot.ScreenshotSettingsPanel;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.visualization.VizController;
import org.gephi.visualization.api.ScreenshotController;
import org.gephi.visualization.screenshot.ScreenshotModelImpl;
import org.gephi.visualization.screenshot.ScreenshotTask;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ScreenshotControllerImpl
implements ScreenshotController {
    private final VizController vizController;
    private final LongTaskExecutor executor;

    public ScreenshotControllerImpl(VizController vizController) {
        this.vizController = vizController;
        this.executor = new LongTaskExecutor(true, "Screenshot Maker");
    }

    private ScreenshotModelImpl getModel() {
        return this.vizController.getModel().getScreenshotModel();
    }

    public void setAutoSave(boolean autoSave) {
        this.getModel().setAutoSave(autoSave);
    }

    public void setDefaultDirectory(File directory) {
        this.getModel().setDefaultDirectory(directory);
    }

    public void setTransparentBackground(boolean transparentBackground) {
        this.getModel().setTransparentBackground(transparentBackground);
    }

    public void setScaleFactor(int scaleFactor) {
        this.getModel().setScaleFactor(scaleFactor);
    }

    public void takeScreenshot() {
        this.vizController.getModel().getEngine().ifPresent(engine -> {
            ScreenshotTask task = new ScreenshotTask((VizEngine<JOGLRenderingTarget, ?>)engine, this.getModel());
            this.executor.execute((LongTask)task, (Runnable)task, NbBundle.getMessage(ScreenshotControllerImpl.class, (String)"ScreenshotMaker.progress.message"), null);
        });
    }

    public int getSurfaceWidth() {
        return this.vizController.getEngine().map(engine -> ((JOGLRenderingTarget)engine.getRenderingTarget()).getDrawable().getSurfaceWidth()).orElse(0);
    }

    public int getSurfaceHeight() {
        return this.vizController.getEngine().map(engine -> ((JOGLRenderingTarget)engine.getRenderingTarget()).getDrawable().getSurfaceHeight()).orElse(0);
    }

    public void configure() {
        ScreenshotSettingsPanel panel = new ScreenshotSettingsPanel(this);
        panel.setup(this.getModel());
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ScreenshotControllerImpl.class, (String)"ScreenshotMaker.configure.title"));
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result == NotifyDescriptor.OK_OPTION) {
            panel.unsetup();
        }
    }
}

