/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.events;

import com.jogamp.newt.event.MouseEvent;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.Node;
import org.gephi.visualization.VizConfig;
import org.gephi.visualization.VizController;
import org.gephi.visualization.api.VisualizationEvent;
import org.gephi.visualization.api.VisualizationEventListener;
import org.gephi.visualization.component.VizEngineGraphCanvasManager;
import org.gephi.visualization.contextmenu.GraphContextMenu;
import org.gephi.visualization.events.VizEvent;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.structure.GraphIndex;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.openide.util.Lookup;

public class StandardVizEventManager {
    private static final short MOUSE_LEFT_BUTTON = 1;
    private static final short MOUSE_WHEEL_BUTTON = 2;
    private static final short MOUSE_RIGHT_BUTTON = 3;
    private final Vector2i dragStartMouseScreenPosition = new Vector2i(0, 0);
    private final Vector2f dragStartMouseWorldPosition2d = new Vector2f(0.0f, 0.0f);
    private final Vector2i previousMouseScreenPosition = new Vector2i(0, 0);
    private final Vector2f previousMouseWorldPosition2d = new Vector2f(0.0f, 0.0f);
    private final Vector2i mouseScreenPosition = new Vector2i(0, 0);
    private final Vector2f mouseWorldPosition = new Vector2f(0.0f, 0.0f);
    private static final int PRESSING_FREQUENCY = 7;
    private Thread pressingThread;
    private volatile boolean shouldStopPressing = false;
    private final Object pressingLock = new Object();
    private final VisualizationEventTypeHandler[] handlers;
    private boolean dragging = false;

    public StandardVizEventManager() {
        ArrayList<VisualizationEventTypeHandler> handlersList = new ArrayList<VisualizationEventTypeHandler>();
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.MOUSE_LEFT_CLICK, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.MOUSE_LEFT_PRESS, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.MOUSE_MIDDLE_CLICK, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.MOUSE_MIDDLE_PRESS, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.MOUSE_RIGHT_CLICK, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.MOUSE_RIGHT_PRESS, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.MOUSE_MOVE, true));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.START_DRAG, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.DRAG, true));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.STOP_DRAG, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.NODE_LEFT_CLICK, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.MOUSE_LEFT_PRESSING, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.MOUSE_RELEASED, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.NODE_LEFT_PRESS, false));
        handlersList.add(new VisualizationEventTypeHandler(VisualizationEvent.Type.NODE_LEFT_PRESSING, false));
        handlersList.sort((o1, o2) -> {
            VisualizationEvent.Type t1 = o1.type;
            VisualizationEvent.Type t2 = o2.type;
            return t1.compareTo((Enum)t2);
        });
        this.handlers = handlersList.toArray(new VisualizationEventTypeHandler[0]);
    }

    public boolean processMouseEvent(Component parentComponent, VizEngineGraphCanvasManager canvasManager, VizEngine engine, MouseEvent mouseEvent) {
        this.previousMouseScreenPosition.set((Vector2ic)this.mouseScreenPosition);
        this.previousMouseWorldPosition2d.set((Vector2fc)this.mouseWorldPosition);
        this.mouseScreenPosition.set(mouseEvent.getX(), mouseEvent.getY());
        engine.screenCoordinatesToWorldCoordinates(this.mouseScreenPosition.x, this.mouseScreenPosition.y, this.mouseWorldPosition);
        switch (mouseEvent.getEventType()) {
            case 206: {
                boolean startDragConsumed;
                if (mouseEvent.getButton() != 1) {
                    return false;
                }
                if (!this.dragging) {
                    this.dragStartMouseScreenPosition.set((Vector2ic)this.mouseScreenPosition);
                    this.dragStartMouseWorldPosition2d.set((Vector2fc)this.mouseWorldPosition);
                    this.dragging = true;
                    startDragConsumed = this.startDrag(engine);
                } else {
                    startDragConsumed = false;
                }
                return this.drag(engine) || startDragConsumed;
            }
            case 205: {
                return this.mouseMove(engine);
            }
            case 200: {
                switch (mouseEvent.getButton()) {
                    case 1: {
                        return this.mouseLeftClick(engine);
                    }
                    case 3: {
                        return this.mouseRightClick(parentComponent, canvasManager, engine);
                    }
                    case 2: {
                        return this.mouseMiddleClick(engine);
                    }
                }
                return false;
            }
            case 203: {
                switch (mouseEvent.getButton()) {
                    case 1: {
                        return this.mouseLeftPress(engine);
                    }
                    case 3: {
                        return this.mouseRightPress(engine);
                    }
                    case 2: {
                        return this.mouseMiddlePress(engine);
                    }
                }
                return false;
            }
            case 207: {
                return false;
            }
            case 204: {
                if (this.dragging) {
                    this.dragging = false;
                    this.stopDrag(engine);
                }
                this.mouseReleased(engine);
                if (mouseEvent.getButton() == 1) {
                    this.stopPressingThread();
                }
                return false;
            }
            case 202: {
                this.stopPressingThread();
            }
        }
        return false;
    }

    public boolean mouseLeftClick(VizEngine engine) {
        GraphIndex graphIndex = engine.getGraphIndex();
        GraphSelection graphSelection = engine.getGraphSelection();
        Node[] clickedNodes = null;
        clickedNodes = !graphSelection.getMode().equals((Object)GraphSelection.GraphSelectionMode.CUSTOM_SELECTION) ? graphSelection.getSelectedNodes().toArray(new Node[0]) : graphIndex.getNodesUnderPosition(this.mouseWorldPosition.x, this.mouseWorldPosition.y).toArray();
        VisualizationEventTypeHandler nodeLeftClickHandler = this.handlers[VisualizationEvent.Type.NODE_LEFT_CLICK.ordinal()];
        if (nodeLeftClickHandler.hasListeners() && clickedNodes.length > 0 && nodeLeftClickHandler.dispatch(clickedNodes)) {
            return true;
        }
        VisualizationEventTypeHandler mouseLeftClickHandler = this.handlers[VisualizationEvent.Type.MOUSE_LEFT_CLICK.ordinal()];
        if (mouseLeftClickHandler.hasListeners() && clickedNodes.length == 0) {
            return mouseLeftClickHandler.dispatch(this.getScreenAndWorldPositionsArray(this.mouseScreenPosition, this.mouseWorldPosition));
        }
        return false;
    }

    private float[] getScreenAndWorldPositionsArray(Vector2i screenPosition, Vector2f worldPosition) {
        return new float[]{screenPosition.x(), screenPosition.y(), worldPosition.x(), worldPosition.y()};
    }

    public boolean mouseLeftPress(VizEngine engine) {
        Collection selectedNodes;
        Collection selectedNodes2;
        GraphSelection selectionIndex = engine.getGraphSelection();
        VisualizationEventTypeHandler nodeLefPressingHandler = this.handlers[VisualizationEvent.Type.NODE_LEFT_PRESSING.ordinal()];
        if (nodeLefPressingHandler.hasListeners() && !(selectedNodes2 = selectionIndex.getSelectedNodes()).isEmpty()) {
            this.startPressingThread(engine);
            return nodeLefPressingHandler.dispatch(this.toArray(selectedNodes2));
        }
        VisualizationEventTypeHandler nodeLefPressHandler = this.handlers[VisualizationEvent.Type.NODE_LEFT_PRESS.ordinal()];
        if (nodeLefPressHandler.hasListeners() && !(selectedNodes = selectionIndex.getSelectedNodes()).isEmpty()) {
            return nodeLefPressHandler.dispatch(this.toArray(selectedNodes));
        }
        return this.handlers[VisualizationEvent.Type.MOUSE_LEFT_PRESS.ordinal()].dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPressingThread(VizEngine engine) {
        GraphSelection selectionIndex = engine.getGraphSelection();
        Object object = this.pressingLock;
        synchronized (object) {
            this.stopPressingThread();
            this.shouldStopPressing = false;
            this.pressingThread = new Thread(() -> {
                long intervalMs = 142L;
                while (!this.shouldStopPressing && !Thread.currentThread().isInterrupted()) {
                    try {
                        Collection selectedNodes;
                        Thread.sleep(142L);
                        if (this.shouldStopPressing || (selectedNodes = selectionIndex.getSelectedNodes()).isEmpty()) continue;
                        Node[] nodesArray = this.toArray(selectedNodes);
                        this.handlers[VisualizationEvent.Type.NODE_LEFT_PRESSING.ordinal()].dispatch(nodesArray);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            });
            this.pressingThread.setDaemon(true);
            this.pressingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPressingThread() {
        Object object = this.pressingLock;
        synchronized (object) {
            this.shouldStopPressing = true;
            if (this.pressingThread != null && this.pressingThread.isAlive()) {
                this.pressingThread.interrupt();
                try {
                    this.pressingThread.join(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.pressingThread = null;
        }
    }

    private Node[] toArray(Collection<Node> selectedNodes) {
        return selectedNodes.toArray(new Node[0]);
    }

    public boolean mouseMiddleClick(VizEngine engine) {
        return this.handlers[VisualizationEvent.Type.MOUSE_MIDDLE_CLICK.ordinal()].dispatch();
    }

    public boolean mouseMiddlePress(VizEngine engine) {
        return this.handlers[VisualizationEvent.Type.MOUSE_MIDDLE_PRESS.ordinal()].dispatch();
    }

    public boolean mouseMove(VizEngine engine) {
        return this.handlers[VisualizationEvent.Type.MOUSE_MOVE.ordinal()].dispatch();
    }

    public boolean mouseRightClick(Component parentComponent, VizEngineGraphCanvasManager canvasManager, VizEngine engine) {
        VizController controller = (VizController)Lookup.getDefault().lookup(VizController.class);
        if (controller != null && controller.getModel() != null && VizConfig.isEnableContextMenu()) {
            GraphContextMenu popupMenu = new GraphContextMenu();
            float globalScale = canvasManager.getSurfaceScale().orElse(Float.valueOf(1.0f)).floatValue();
            int x = (int)((float)this.mouseScreenPosition.x / globalScale);
            int y = (int)((float)this.mouseScreenPosition.y / globalScale);
            popupMenu.getMenu(engine).show(parentComponent, x, y);
        }
        return this.handlers[VisualizationEvent.Type.MOUSE_RIGHT_CLICK.ordinal()].dispatch();
    }

    public boolean mouseRightPress(VizEngine engine) {
        return this.handlers[VisualizationEvent.Type.MOUSE_RIGHT_PRESS.ordinal()].dispatch();
    }

    public boolean startDrag(VizEngine engine) {
        return this.handlers[VisualizationEvent.Type.START_DRAG.ordinal()].dispatch();
    }

    public void stopDrag(VizEngine engine) {
        this.handlers[VisualizationEvent.Type.STOP_DRAG.ordinal()].dispatch();
    }

    public boolean drag(VizEngine engine) {
        VisualizationEventTypeHandler handler = this.handlers[VisualizationEvent.Type.DRAG.ordinal()];
        if (handler.hasListeners()) {
            Vector2i dragScreenDisplacement = new Vector2i((Vector2ic)this.mouseScreenPosition);
            dragScreenDisplacement.sub((Vector2ic)this.dragStartMouseScreenPosition);
            Vector2f dragWorldDisplacement = new Vector2f((Vector2fc)this.mouseWorldPosition);
            dragWorldDisplacement.sub((Vector2fc)this.dragStartMouseWorldPosition2d);
            return handler.dispatch(this.getScreenAndWorldPositionsArray(dragScreenDisplacement, dragWorldDisplacement));
        }
        return false;
    }

    public void mouseReleased(VizEngine engine) {
        this.handlers[VisualizationEvent.Type.MOUSE_RELEASED.ordinal()].dispatch();
    }

    public boolean hasListeners(VisualizationEvent.Type type) {
        return this.handlers[type.ordinal()].hasListeners();
    }

    public void addListener(VisualizationEventListener listener) {
        this.handlers[listener.getType().ordinal()].addListener(listener);
    }

    public void removeListener(VisualizationEventListener listener) {
        this.handlers[listener.getType().ordinal()].removeListener(listener);
    }

    private static class VisualizationEventTypeHandler {
        protected final VisualizationEvent.Type type;
        private final boolean limitRunning;
        protected List<WeakReference<VisualizationEventListener>> listeners;
        protected Runnable runnable;
        protected boolean running;

        public VisualizationEventTypeHandler(VisualizationEvent.Type type, boolean limitRunning) {
            this.limitRunning = limitRunning;
            this.type = type;
            this.listeners = new ArrayList<WeakReference<VisualizationEventListener>>();
        }

        protected synchronized void addListener(VisualizationEventListener listener) {
            if (listener == null) {
                return;
            }
            WeakReference<VisualizationEventListener> weakListener = new WeakReference<VisualizationEventListener>(listener);
            this.listeners.add(weakListener);
        }

        protected synchronized void removeListener(VisualizationEventListener listener) {
            this.listeners.removeIf(li -> li.get() == listener);
        }

        protected boolean dispatch() {
            if (this.limitRunning && this.running) {
                return false;
            }
            if (!this.listeners.isEmpty()) {
                this.running = true;
                boolean consumed = this.fireVisualizationEvent(null);
                this.running = false;
                return consumed;
            }
            return false;
        }

        protected boolean dispatch(Object data) {
            if (this.limitRunning && this.running) {
                return false;
            }
            if (!this.listeners.isEmpty()) {
                this.running = true;
                try {
                    boolean consumed = this.fireVisualizationEvent(data);
                    this.running = false;
                    return consumed;
                }
                catch (Exception e) {
                    Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.SEVERE, null, e);
                }
            }
            return false;
        }

        protected boolean isRunning() {
            return this.running;
        }

        private synchronized boolean fireVisualizationEvent(Object data) {
            VizEvent event = new VizEvent(this, this.type, data);
            for (WeakReference<VisualizationEventListener> weakListener : this.listeners) {
                boolean consumed;
                VisualizationEventListener listener = (VisualizationEventListener)weakListener.get();
                if (listener == null || !(consumed = listener.handleEvent((VisualizationEvent)event))) continue;
                return true;
            }
            return false;
        }

        public boolean hasListeners() {
            return !this.listeners.isEmpty();
        }

        protected int getIndex() {
            return this.type.ordinal();
        }
    }
}

