/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.contextmenu.items;

import javax.swing.Icon;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.visualization.contextmenu.items.BasicItem;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SelectInDataLaboratory
extends BasicItem {
    private DataTablesController dtc;

    @Override
    public void setup(Graph graph, Node[] nodes) {
        this.nodes = nodes;
        this.dtc = (DataTablesController)Lookup.getDefault().lookup(DataTablesController.class);
        if (!this.dtc.isDataTablesReady()) {
            this.dtc.prepareDataTables();
        }
    }

    public void execute() {
        this.dtc.setNodeTableSelection(this.nodes);
        this.dtc.selectNodesTable();
    }

    public String getName() {
        return NbBundle.getMessage(SelectInDataLaboratory.class, (String)"GraphContextMenu_SelectInDataLaboratory");
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public boolean canExecute() {
        return this.nodes.length >= 1 && this.dtc.isDataTablesReady();
    }

    public int getType() {
        return 400;
    }

    public int getPosition() {
        return 100;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"VisualizationImpl/table-select.svg", (boolean)false);
    }

    @Override
    public Integer getMnemonicKey() {
        return 76;
    }
}

