/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.contextmenu.items;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.gephi.datalab.spi.nodes.NodesManipulator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.visualization.contextmenu.items.BasicItem;
import org.gephi.visualization.contextmenu.items.CopyOrMoveToWorkspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CopyOrMoveToWorkspaceSubItem
extends BasicItem
implements NodesManipulator {
    private final Workspace workspace;
    private final boolean canExecute;
    private final int type;
    private final int position;
    private final boolean copy;

    public CopyOrMoveToWorkspaceSubItem(Workspace workspace, boolean canExecute, int type, int position, boolean copy) {
        this.workspace = workspace;
        this.canExecute = canExecute;
        this.type = type;
        this.position = position;
        this.copy = copy;
    }

    @Override
    public void setup(Node[] nodes, Node clickedNode) {
        this.nodes = nodes;
    }

    public void execute() {
        if (this.copy) {
            this.copyToWorkspace(this.workspace);
        } else {
            this.moveToWorkspace(this.workspace);
        }
    }

    public String getName() {
        if (this.workspace != null) {
            return this.workspace.getName();
        }
        return NbBundle.getMessage(CopyOrMoveToWorkspaceSubItem.class, (String)(this.copy ? "GraphContextMenu_CopyToWorkspace_NewWorkspace" : "GraphContextMenu_MoveToWorkspace_NewWorkspace"));
    }

    public boolean canExecute() {
        return this.canExecute;
    }

    public int getType() {
        return this.type;
    }

    public int getPosition() {
        return this.position;
    }

    public Icon getIcon() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyToWorkspace(Workspace workspace) {
        GraphModel targetGraphModel;
        ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        Workspace currentWorkspace = projectController.getCurrentWorkspace();
        GraphModel currentGraphModel = graphController.getGraphModel(currentWorkspace);
        if (workspace == null) {
            workspace = projectController.newWorkspace(currentWorkspace.getProject(), new Object[]{currentGraphModel.getConfiguration().copy()});
            targetGraphModel = graphController.getGraphModel(workspace);
            targetGraphModel.setTimeFormat(currentGraphModel.getTimeFormat());
            targetGraphModel.setTimeZone(currentGraphModel.getTimeZone());
        } else {
            targetGraphModel = graphController.getGraphModel(workspace);
        }
        currentGraphModel.getGraph().readLock();
        try {
            targetGraphModel.bridge().copyNodes(this.nodes);
            Graph targetGraph = targetGraphModel.getGraph();
            Graph visibleCurrentGraph = currentGraphModel.getGraphVisible();
            ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
            for (Edge edge : targetGraph.getEdges()) {
                if (visibleCurrentGraph.hasEdge(edge.getId())) continue;
                edgesToRemove.add(edge);
            }
            if (!edgesToRemove.isEmpty()) {
                targetGraph.removeAllEdges(edgesToRemove);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String error = NbBundle.getMessage(CopyOrMoveToWorkspace.class, (String)"GraphContextMenu_CopyOrMoveToWorkspace_ConfigurationNotCompatible");
            String title = NbBundle.getMessage(CopyOrMoveToWorkspace.class, (String)"GraphContextMenu_CopyOrMoveToWorkspace_ConfigurationNotCompatible_Title");
            JOptionPane.showMessageDialog(null, error, title, 0);
            boolean bl = false;
            return bl;
        }
        finally {
            currentGraphModel.getGraph().readUnlockAll();
        }
    }

    public void moveToWorkspace(Workspace workspace) {
        if (this.copyToWorkspace(workspace)) {
            this.delete();
        }
    }

    public void delete() {
        Graph g = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph();
        g.removeAllNodes(Arrays.asList(this.nodes));
    }
}

