/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.component;

import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.gephi.graph.api.GraphModel;
import org.gephi.project.api.Workspace;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.VizConfig;
import org.gephi.visualization.VizController;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.events.StandardVizEventManager;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineFactory;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.VizEngineJOGLConfigurator;
import org.gephi.viz.engine.spi.InputListener;
import org.gephi.viz.engine.spi.RenderingTarget;
import org.gephi.viz.engine.util.gl.OpenGLOptions;

public class VizEngineGraphCanvasManager {
    private final VizController vizController;
    private GLWindow glWindow;
    private NewtCanvasAWT glCanvas;
    private transient VizEngine<JOGLRenderingTarget, NEWTEvent> engine = null;
    private boolean initialized = false;

    public VizEngineGraphCanvasManager(VizController vizController) {
        this.vizController = Objects.requireNonNull(vizController);
    }

    public Optional<VizEngine<JOGLRenderingTarget, NEWTEvent>> getEngine() {
        return Optional.ofNullable(this.engine);
    }

    public Optional<Float> getSurfaceScale() {
        if (this.glWindow != null) {
            return Optional.of(Float.valueOf(this.glWindow.getCurrentSurfaceScale(new float[2])[0]));
        }
        return Optional.empty();
    }

    public synchronized VizEngine<JOGLRenderingTarget, NEWTEvent> init(JComponent component) {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialized = true;
        GLCapabilities caps = VizEngineJOGLConfigurator.createCapabilities((int)VizConfig.getAntialiasing());
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        this.glWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)caps);
        if (VizConfig.isEngineOpenGLDebug()) {
            this.glWindow.setContextCreationFlags(32);
            Logger logger = Logger.getLogger(VizEngine.class.getSimpleName());
            logger.setLevel(Level.FINE);
            logger.log(Level.FINE, GLProfile.glAvailabilityToString());
        }
        JOGLRenderingTarget renderingTarget = new JOGLRenderingTarget((GLAutoDrawable)this.glWindow);
        this.engine = VizEngineFactory.newEngine((RenderingTarget)renderingTarget, Collections.singletonList(new VizEngineJOGLConfigurator()));
        this.engine.setDarkLaf(UIUtils.isDarkLookAndFeel());
        OpenGLOptions glOptions = this.engine.getOpenGLOptions();
        glOptions.setDisableIndirectDrawing(VizConfig.isEngineDisableIndirectRendering());
        glOptions.setDisableInstancedDrawing(VizConfig.isEngineDisableInstancedRendering());
        glOptions.setDisableVAOS(VizConfig.isEngineDisableVAOs());
        glOptions.setDisableVertexArrayDrawing(VizConfig.isEngineDisableVertexArrayDrawing());
        glOptions.setDebug(VizConfig.isEngineOpenGLDebug());
        this.engine.addInputListener((InputListener)new InputListener<JOGLRenderingTarget, NEWTEvent>(){

            public List<NEWTEvent> processEvents(List<NEWTEvent> inputEvents) {
                if (VizEngineGraphCanvasManager.this.engine != null && VizEngineGraphCanvasManager.this.vizController.getVizEventManager() != null) {
                    StandardVizEventManager vizEventManager = VizEngineGraphCanvasManager.this.vizController.getVizEventManager();
                    ArrayList<NEWTEvent> remainingEvents = new ArrayList<NEWTEvent>();
                    for (NEWTEvent inputEvent : inputEvents) {
                        if (inputEvent instanceof MouseEvent && vizEventManager.processMouseEvent((Component)VizEngineGraphCanvasManager.this.glCanvas, VizEngineGraphCanvasManager.this, VizEngineGraphCanvasManager.this.engine, (MouseEvent)inputEvent)) continue;
                        remainingEvents.add(inputEvent);
                    }
                    return remainingEvents;
                }
                return inputEvents;
            }

            public String getCategory() {
                return "GephiDesktop";
            }

            public int getPreferenceInCategory() {
                return 0;
            }

            public String getName() {
                return "Gephi Viz Event Manager";
            }

            public void init(JOGLRenderingTarget renderingTarget) {
            }

            public int getOrder() {
                return -100;
            }
        });
        this.glCanvas = new NewtCanvasAWT((Window)this.glWindow);
        component.add((Component)this.glCanvas, "Center");
        this.engine.start();
        component.revalidate();
        return this.engine;
    }

    public synchronized VizModel loadWorkspace(Workspace workspace) {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        VizModel model = this.vizController.getModel(workspace);
        GraphModel graphModel = (GraphModel)workspace.getLookup().lookup(GraphModel.class);
        this.engine.setGraphModel(graphModel, model.toGraphRenderingOptions(), model.toGraphSelection());
        return model;
    }

    public synchronized VizModel unloadWorkspace(Workspace workspace) {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        VizModel model = this.vizController.getModel(workspace);
        GraphModel graphModel = (GraphModel)workspace.getLookup().lookup(GraphModel.class);
        if (this.engine.getGraphModel() == graphModel) {
            model.unsetup();
            this.engine.unsetGraphModel(graphModel);
        }
        return model;
    }

    public synchronized void destroy(JComponent component) {
        if (this.glCanvas != null) {
            component.remove((Component)this.glCanvas);
            component.revalidate();
        }
        if (this.glWindow != null) {
            this.glWindow.destroy();
            this.glWindow = null;
            this.glCanvas = null;
        }
        this.initialized = false;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }
}

