/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.component;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gephi.desktop.visualization.collapse.CollapseGroup;
import org.gephi.desktop.visualization.collapse.CollapsePanel;
import org.gephi.desktop.visualization.collapse.EdgeGroup;
import org.gephi.desktop.visualization.collapse.EdgeLabelGroup;
import org.gephi.desktop.visualization.collapse.GlobalGroup;
import org.gephi.desktop.visualization.collapse.NodeGroup;
import org.gephi.desktop.visualization.collapse.NodeLabelGroup;
import org.gephi.desktop.visualization.collapse.VizExtendedBar;
import org.gephi.desktop.visualization.collapse.VizToolbar;
import org.gephi.desktop.visualization.selection.SelectionToolbar;
import org.gephi.desktop.visualization.tools.ActionsToolbar;
import org.gephi.desktop.visualization.tools.DesktopToolController;
import org.gephi.desktop.visualization.tools.PropertiesBar;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.visualization.VizController;
import org.gephi.visualization.VizModel;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="GraphTopComponent", iconBase="VisualizationImpl/graph.svg", persistenceType=0)
public class GraphTopComponent
extends TopComponent
implements AWTEventListener {
    private final VizController controller = (VizController)Lookup.getDefault().lookup(VizController.class);
    private final SelectionToolbar selectionToolbar;
    private final ActionsToolbar actionsToolbar;
    private final JComponent toolbar;
    private final PropertiesBar propertiesBar;
    private final CollapseGroup[] groups;
    private CollapsePanel collapsePanel;
    private JLabel waitingLabel;
    private final ExecutorService vizExecutor;

    public GraphTopComponent() {
        this.setName(NbBundle.getMessage(GraphTopComponent.class, (String)"CTL_GraphTopComponent"));
        this.initComponents();
        this.initKeyEventContextMenuActionMappings();
        this.vizExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "GraphTopComponent-VizExecutor");
            t.setDaemon(true);
            return t;
        });
        this.selectionToolbar = new SelectionToolbar();
        this.actionsToolbar = new ActionsToolbar();
        this.propertiesBar = new PropertiesBar();
        DesktopToolController tc = (DesktopToolController)Lookup.getDefault().lookup(DesktopToolController.class);
        this.toolbar = tc.getToolbar();
        JComponent toolsPropertiesBar = tc.getPropertiesBar();
        this.propertiesBar.addToolsPropertiesBar(toolsPropertiesBar);
        this.groups = this.createCollapseGroups();
        SwingUtilities.invokeLater(() -> {
            this.collapsePanel.init(new VizToolbar(this.groups), new VizExtendedBar(this.groups), false);
            this.initToolPanels();
        });
        this.initEngine();
        this.listenToWorkspaceEvents();
    }

    private CollapseGroup[] createCollapseGroups() {
        CollapseGroup[] groups = new CollapseGroup[]{new GlobalGroup(this.controller), new NodeGroup(), new NodeLabelGroup(), new EdgeGroup(), new EdgeLabelGroup()};
        for (CollapseGroup group : groups) {
            group.disable();
        }
        return groups;
    }

    private void listenToWorkspaceEvents() {
        boolean hasWorkspace;
        ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        projectController.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
                GraphTopComponent.this.activateWorkspaceVizEngine(workspace);
            }

            public void unselect(Workspace workspace) {
                GraphTopComponent.this.deactivateWorkspaceVizEngine(workspace);
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                SwingUtilities.invokeLater(() -> {
                    GraphTopComponent.this.toolbar.setEnabled(false);
                    GraphTopComponent.this.propertiesBar.setEnabled(false);
                    GraphTopComponent.this.actionsToolbar.setEnabled(false);
                    GraphTopComponent.this.selectionToolbar.setEnabled(false);
                });
            }
        });
        boolean bl = hasWorkspace = projectController.getCurrentWorkspace() != null;
        if (hasWorkspace) {
            this.activateWorkspaceVizEngine(projectController.getCurrentWorkspace());
        }
    }

    private void initEngine() {
        this.vizExecutor.submit(this::doInitEngine);
    }

    private void doInitEngine() {
        this.controller.getCanvasManager().init((JComponent)((Object)this));
        SwingUtilities.invokeLater(() -> this.remove(this.waitingLabel));
    }

    private void deactivateWorkspaceVizEngine(Workspace workspace) {
        CompletableFuture.runAsync(() -> this.doDeactivateWorkspaceVizEngine(workspace), this.vizExecutor).whenComplete((v, ex) -> {
            if (ex != null) {
                ex.printStackTrace();
            }
        });
    }

    private void doDeactivateWorkspaceVizEngine(Workspace workspace) {
        if (workspace == null) {
            return;
        }
        VizModel vizModel = this.controller.getCanvasManager().unloadWorkspace(workspace);
        SwingUtilities.invokeLater(() -> {
            for (CollapseGroup group : this.groups) {
                group.unsetup(vizModel);
            }
            this.selectionToolbar.unsetup(vizModel);
            this.propertiesBar.unsetup();
        });
    }

    private void activateWorkspaceVizEngine(Workspace workspace) {
        CompletableFuture.runAsync(() -> this.doActivateWorkspaceVizEngine(workspace), this.vizExecutor).whenComplete((v, ex) -> {
            if (ex != null) {
                ex.printStackTrace();
            }
        });
    }

    private void doActivateWorkspaceVizEngine(Workspace workspace) {
        if (workspace == null) {
            return;
        }
        VizModel vizModel = this.controller.getCanvasManager().loadWorkspace(workspace);
        SwingUtilities.invokeLater(() -> {
            this.toolbar.setEnabled(true);
            this.propertiesBar.setEnabled(true);
            this.actionsToolbar.setEnabled(true);
            this.selectionToolbar.setEnabled(true);
            for (CollapseGroup group : this.groups) {
                group.setup(vizModel);
            }
            this.selectionToolbar.setup(vizModel);
            this.propertiesBar.setup(vizModel);
        });
    }

    private void initKeyEventContextMenuActionMappings() {
    }

    private void initToolPanels() {
        JPanel westPanel = new JPanel(new BorderLayout(0, 0));
        westPanel.add((Component)this.toolbar, "Center");
        westPanel.add((Component)this.selectionToolbar, "North");
        westPanel.add((Component)this.actionsToolbar, "South");
        this.add(this.propertiesBar, "North");
        this.add(westPanel, "West");
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        KeyEvent evt = (KeyEvent)event;
        if (evt.getID() != 402 || (evt.getModifiersEx() & 0x80) == 128) {
            // empty if block
        }
    }

    private void initComponents() {
        this.waitingLabel = new JLabel();
        this.collapsePanel = new CollapsePanel();
        this.setLayout(new BorderLayout());
        this.waitingLabel.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.waitingLabel, (String)NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.waitingLabel.text"));
        this.waitingLabel.setVerticalAlignment(1);
        this.add(this.waitingLabel, "Center");
        this.add(this.collapsePanel, "Last");
    }

    protected void componentActivated() {
        super.componentActivated();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
    }

    protected void componentClosed() {
        super.componentClosed();
        this.deactivateWorkspaceVizEngine(((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace());
    }

    public void shutdown() {
        this.vizExecutor.shutdown();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.deactivateWorkspaceVizEngine(((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace());
    }

    protected void componentShowing() {
        super.componentShowing();
        this.activateWorkspaceVizEngine(((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace());
    }

    protected void componentOpened() {
        super.componentOpened();
        this.activateWorkspaceVizEngine(((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace());
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

