/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization;

import com.jogamp.newt.event.NEWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.SelectionModelImpl;
import org.gephi.visualization.VizConfig;
import org.gephi.visualization.VizController;
import org.gephi.visualization.api.EdgeColorMode;
import org.gephi.visualization.api.LabelColorMode;
import org.gephi.visualization.api.LabelSizeMode;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.gephi.visualization.screenshot.ScreenshotModelImpl;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.status.GraphRenderingOptions;
import org.gephi.viz.engine.status.GraphRenderingOptionsImpl;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.util.ColorUtils;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.openide.util.Lookup;

public class VizModel
implements VisualizationModel {
    private final VizController vizController;
    private final Workspace workspace;
    private final GraphModel graphModel;
    private float zoom;
    private Vector2fc pan;
    private Color backgroundColor;
    private boolean showEdges;
    private float edgeScale;
    private boolean edgeSelectionColor;
    private Color edgeBothSelectionColor;
    private Color edgeInSelectionColor;
    private Color edgeOutSelectionColor;
    private EdgeColorMode edgeColorMode;
    private boolean edgeWeightEnabled;
    private boolean edgeRescaleWeightEnabled;
    private float nodeScale;
    private boolean autoSelectNeighbours;
    private boolean hideNonSelectedEdges;
    private boolean lightenNonSelected;
    private float lightenNonSelectedFactor;
    private boolean showNodeLabels;
    private Font nodeLabelFont;
    private float nodeLabelScale;
    private LabelColorMode nodeLabelColorMode;
    private LabelSizeMode nodeLabelSizeMode;
    private boolean hideNonSelectedNodeLabels;
    private boolean fitNodeLabelsToNodeSize;
    private boolean avoidNodeLabelOverlap;
    private Column[] nodeLabelColumns = new Column[0];
    private boolean showEdgeLabels;
    private Font edgeLabelFont;
    private float edgeLabelScale;
    private LabelColorMode edgeLabelColorMode;
    private LabelSizeMode edgeLabelSizeMode;
    private boolean hideNonSelectedEdgeLabels;
    private Column[] edgeLabelColumns = new Column[0];
    private final SelectionModelImpl selectionModel;
    private final ScreenshotModelImpl screenshotModel;

    public VizModel(VizController controller, Workspace workspace) {
        this.vizController = controller;
        this.workspace = workspace;
        this.graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        this.selectionModel = new SelectionModelImpl(this);
        this.screenshotModel = new ScreenshotModelImpl(this);
        this.defaultValues();
    }

    private void defaultValues() {
        this.backgroundColor = UIUtils.isDarkLookAndFeel() ? VizConfig.getDefaultDarkBackgroundColor() : VizConfig.getDefaultBackgroundColor();
        this.zoom = VizConfig.getDefaultZoom();
        this.pan = VizConfig.getDefaultPan();
        this.showEdges = VizConfig.isDefaultShowEdges();
        this.edgeScale = VizConfig.getDefaultEdgeScale();
        this.edgeSelectionColor = VizConfig.isDefaultEdgeSelectionColor();
        this.edgeInSelectionColor = VizConfig.getDefaultEdgeInSelectedColor();
        this.edgeOutSelectionColor = VizConfig.getDefaultEdgeOutSelectedColor();
        this.edgeBothSelectionColor = VizConfig.getDefaultEdgeBothSelectedColor();
        this.edgeColorMode = VizConfig.getDefaultEdgeColorMode();
        this.edgeWeightEnabled = VizConfig.isDefaultUseEdgeWeight();
        this.edgeRescaleWeightEnabled = VizConfig.isDefaultRescaleEdgeWeight();
        this.nodeScale = VizConfig.getDefaultNodeScale();
        this.autoSelectNeighbours = VizConfig.isDefaultAutoSelectNeighbor();
        this.hideNonSelectedEdges = VizConfig.isDefaultHideNonSelectedEdges();
        this.lightenNonSelected = VizConfig.isDefaultLightenNonSelectedAuto();
        this.lightenNonSelectedFactor = VizConfig.getDefaultLightenNonSelectedFactor();
        this.showNodeLabels = VizConfig.isDefaultShowNodeLabels();
        this.nodeLabelColorMode = VizConfig.getDefaultNodeLabelColorMode();
        this.nodeLabelSizeMode = VizConfig.getDefaultNodeLabelSizeMode();
        this.nodeLabelFont = VizConfig.getDefaultNodeLabelFont();
        this.nodeLabelScale = VizConfig.getDefaultNodeLabelScale();
        this.hideNonSelectedNodeLabels = VizConfig.isDefaultHideNonSelectedNodeLabels();
        this.fitNodeLabelsToNodeSize = VizConfig.isDefaultFitNodeLabelsToNodeSize();
        this.avoidNodeLabelOverlap = VizConfig.isDefaultAvoidNodeLabelOverlap();
        this.nodeLabelColumns = new Column[]{this.graphModel.defaultColumns().nodeLabel()};
        this.showEdgeLabels = VizConfig.isDefaultShowEdgeLabels();
        this.edgeLabelColorMode = VizConfig.getDefaultEdgeLabelColorMode();
        this.edgeLabelSizeMode = VizConfig.getDefaultEdgeLabelSizeMode();
        this.edgeLabelFont = VizConfig.getDefaultEdgeLabelFont();
        this.edgeLabelScale = VizConfig.getDefaultEdgeLabelScale();
        this.hideNonSelectedEdgeLabels = VizConfig.isDefaultHideNonSelectedEdgeLabels();
        this.edgeLabelColumns = new Column[]{this.graphModel.defaultColumns().edgeLabel()};
    }

    public GraphRenderingOptions toGraphRenderingOptions() {
        GraphRenderingOptionsImpl options = new GraphRenderingOptionsImpl();
        options.setZoom(this.getZoom());
        options.setPan(this.getPan());
        options.setAutoSelectNeighbours(this.isAutoSelectNeighbors());
        options.setBackgroundColor(this.getBackgroundColor());
        options.setEdgeBothSelectionColor(this.getEdgeBothSelectionColor());
        options.setEdgeInSelectionColor(this.getEdgeInSelectionColor());
        options.setEdgeOutSelectionColor(this.getEdgeOutSelectionColor());
        options.setEdgeColorMode(GraphRenderingOptions.EdgeColorMode.valueOf((String)this.getEdgeColorMode().name()));
        options.setEdgeScale(this.getEdgeScale());
        options.setEdgeSelectionColor(this.isEdgeSelectionColor());
        options.setEdgeWeightEnabled(this.isUseEdgeWeight());
        options.setEdgeRescaleWeightEnabled(this.isRescaleEdgeWeight());
        options.setHideNonSelectedEdges(this.isHideNonSelectedEdges());
        options.setLightenNonSelected(this.isLightenNonSelectedAuto());
        options.setLightenNonSelectedFactor(this.getLightenNonSelectedFactor());
        options.setNodeScale(this.getNodeScale());
        options.setShowEdges(this.isShowEdges());
        options.setShowEdgeLabels(this.isShowEdgeLabels());
        options.setShowNodeLabels(this.isShowNodeLabels());
        options.setNodeLabelSizeMode(GraphRenderingOptions.LabelSizeMode.valueOf((String)this.getNodeLabelSizeMode().name()));
        options.setNodeLabelColorMode(GraphRenderingOptions.LabelColorMode.valueOf((String)this.getNodeLabelColorMode().name()));
        options.setNodeLabelFont(this.getNodeLabelFont());
        options.setNodeLabelScale(this.getNodeLabelScale());
        options.setNodeLabelFitToNodeSize(this.isNodeLabelFitToNodeSize());
        options.setHideNonSelectedNodeLabels(this.isHideNonSelectedNodeLabels());
        options.setAvoidNodeLabelOverlap(this.isAvoidNodeLabelOverlap());
        options.setNodeLabelColumns(this.getNodeLabelColumns());
        options.setEdgeLabelColorMode(GraphRenderingOptions.LabelColorMode.valueOf((String)this.getEdgeLabelColorMode().name()));
        options.setEdgeLabelSizeMode(GraphRenderingOptions.LabelSizeMode.valueOf((String)this.getEdgeLabelSizeMode().name()));
        options.setEdgeLabelFont(this.getEdgeLabelFont());
        options.setEdgeLabelScale(this.getEdgeLabelScale());
        options.setHideNonSelectedEdgeLabels(this.isHideNonSelectedEdgeLabels());
        options.setEdgeLabelColumns(this.getEdgeLabelColumns());
        return options;
    }

    public GraphSelection toGraphSelection() {
        return this.selectionModel.toGraphSelection();
    }

    public void unsetup() {
        this.getEngine().ifPresent(d -> {
            GraphRenderingOptions options = d.getRenderingOptions();
            this.zoom = options.getZoom();
            this.pan = new Vector2f(options.getPan());
        });
    }

    public SelectionModelImpl getSelectionModel() {
        return this.selectionModel;
    }

    public ScreenshotModelImpl getScreenshotModel() {
        return this.screenshotModel;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Optional<VizEngine<JOGLRenderingTarget, NEWTEvent>> getEngine() {
        return this.vizController.getCanvasManager().getEngine();
    }

    private Optional<GraphRenderingOptions> getRenderingOptions() {
        return this.vizController.getCanvasManager().getEngine().map(VizEngine::getRenderingOptions);
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        float oldValue = this.zoom;
        if (oldValue != zoom) {
            this.zoom = zoom;
            this.getEngine().ifPresent(vizEngine -> vizEngine.setZoom(zoom));
            this.firePropertyChange("zoom", Float.valueOf(oldValue), Float.valueOf(zoom));
        }
    }

    public Vector2fc getPan() {
        return this.pan;
    }

    public int getFps() {
        return this.getEngine().map(VizEngine::getFps).orElse(0);
    }

    public boolean isAutoSelectNeighbors() {
        return this.autoSelectNeighbours;
    }

    public void setAutoSelectNeighbors(boolean autoSelectNeighbor) {
        boolean oldValue = this.autoSelectNeighbours;
        if (oldValue != autoSelectNeighbor) {
            this.autoSelectNeighbours = autoSelectNeighbor;
            this.getRenderingOptions().ifPresent(options -> options.setAutoSelectNeighbours(autoSelectNeighbor));
            this.firePropertyChange("autoSelectNeighbor", oldValue, autoSelectNeighbor);
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isBackgroundColorDark() {
        return ColorUtils.isColorDark((float[])this.backgroundColor.getRGBComponents(null));
    }

    private void setBackgroundColor(float[] bgColor) {
        Color color = new Color(bgColor[0], bgColor[1], bgColor[2], bgColor[3]);
        this.setBackgroundColor(color);
    }

    public void setBackgroundColor(Color backgroundColor) {
        Color oldValue = this.backgroundColor;
        if (oldValue != null && oldValue.equals(backgroundColor)) {
            return;
        }
        this.backgroundColor = backgroundColor;
        this.getEngine().ifPresent(vizEngine -> vizEngine.setBackgroundColor(backgroundColor));
        this.firePropertyChange("backgroundColor", oldValue, backgroundColor);
    }

    public boolean isShowEdges() {
        return this.showEdges;
    }

    public void setShowEdges(boolean showEdges) {
        boolean oldValue = this.showEdges;
        if (oldValue != showEdges) {
            this.showEdges = showEdges;
            this.getRenderingOptions().ifPresent(options -> options.setShowEdges(showEdges));
            this.firePropertyChange("showEdges", oldValue, showEdges);
        }
    }

    public EdgeColorMode getEdgeColorMode() {
        return this.edgeColorMode;
    }

    public void setEdgeColorMode(EdgeColorMode edgeColorMode) {
        EdgeColorMode oldValue = this.getEdgeColorMode();
        if (oldValue != edgeColorMode) {
            this.edgeColorMode = edgeColorMode;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeColorMode(GraphRenderingOptions.EdgeColorMode.valueOf((String)edgeColorMode.name())));
            this.firePropertyChange("edgeColorMode", oldValue, edgeColorMode);
        }
    }

    public boolean isHideNonSelectedEdges() {
        return this.hideNonSelectedEdges;
    }

    public void setHideNonSelectedEdges(boolean hideNonSelectedEdges) {
        boolean oldValue = this.hideNonSelectedEdges;
        if (oldValue != hideNonSelectedEdges) {
            this.hideNonSelectedEdges = hideNonSelectedEdges;
            this.getRenderingOptions().ifPresent(options -> options.setHideNonSelectedEdges(hideNonSelectedEdges));
            this.firePropertyChange("hideNonSelectedEdges", oldValue, hideNonSelectedEdges);
        }
    }

    public Estimator getEdgeWeightEstimator() {
        if (AttributeUtils.isDynamicType((Class)this.graphModel.getConfiguration().getEdgeWeightType())) {
            return this.graphModel.getEdgeTable().getColumn("weight").getEstimator();
        }
        return null;
    }

    public void setEdgeWeightEstimator(Estimator estimator) {
        if (AttributeUtils.isDynamicType((Class)this.graphModel.getConfiguration().getEdgeWeightType())) {
            Estimator oldValue = this.graphModel.getEdgeTable().getColumn("weight").getEstimator();
            this.graphModel.getEdgeTable().getColumn("weight").setEstimator(estimator);
            this.firePropertyChange("edgeWeightEstimator", oldValue, estimator);
        }
    }

    public boolean isLightenNonSelectedAuto() {
        return this.lightenNonSelected;
    }

    public void setLightenNonSelectedAuto(boolean lightenNonSelectedAuto) {
        boolean oldValue = this.lightenNonSelected;
        if (oldValue != lightenNonSelectedAuto) {
            this.lightenNonSelected = lightenNonSelectedAuto;
            this.getRenderingOptions().ifPresent(options -> options.setLightenNonSelected(lightenNonSelectedAuto));
            this.firePropertyChange("lightenNonSelectedAuto", oldValue, lightenNonSelectedAuto);
        }
        this.firePropertyChange("lightenNonSelectedAuto", oldValue, lightenNonSelectedAuto);
    }

    public float getLightenNonSelectedFactor() {
        return this.lightenNonSelectedFactor;
    }

    public void setLightenNonSelectedFactor(float lightenNonSelectedFactor) {
        float oldValue = this.lightenNonSelectedFactor;
        if (oldValue != lightenNonSelectedFactor) {
            this.lightenNonSelectedFactor = lightenNonSelectedFactor;
            this.getRenderingOptions().ifPresent(options -> options.setLightenNonSelectedFactor(lightenNonSelectedFactor));
            this.firePropertyChange("lightenNonSelectedFactor", Float.valueOf(oldValue), Float.valueOf(lightenNonSelectedFactor));
        }
        this.firePropertyChange("lightenNonSelectedFactor", Float.valueOf(oldValue), Float.valueOf(lightenNonSelectedFactor));
    }

    public boolean isEdgeSelectionColor() {
        return this.edgeSelectionColor;
    }

    public void setEdgeSelectionColor(boolean edgeSelectionColor) {
        boolean oldValue = this.edgeSelectionColor;
        if (oldValue != edgeSelectionColor) {
            this.edgeSelectionColor = edgeSelectionColor;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeSelectionColor(edgeSelectionColor));
            this.firePropertyChange("edgeSelectionColor", oldValue, edgeSelectionColor);
        }
        this.firePropertyChange("edgeSelectionColor", oldValue, edgeSelectionColor);
    }

    public Color getEdgeInSelectionColor() {
        return this.edgeInSelectionColor;
    }

    public void setEdgeInSelectionColor(Color edgeInSelectionColor) {
        Color oldValue = this.edgeInSelectionColor;
        if (oldValue != edgeInSelectionColor) {
            this.edgeInSelectionColor = edgeInSelectionColor;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeInSelectionColor(edgeInSelectionColor));
            this.firePropertyChange("edgeInSelectionColor", oldValue, edgeInSelectionColor);
        }
    }

    public Color getEdgeOutSelectionColor() {
        return this.edgeOutSelectionColor;
    }

    public void setEdgeOutSelectionColor(Color edgeOutSelectionColor) {
        Color oldValue = this.edgeOutSelectionColor;
        if (oldValue != edgeOutSelectionColor) {
            this.edgeOutSelectionColor = edgeOutSelectionColor;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeOutSelectionColor(edgeOutSelectionColor));
            this.firePropertyChange("edgeOutSelectionColor", oldValue, edgeOutSelectionColor);
        }
    }

    public Color getEdgeBothSelectionColor() {
        return this.edgeBothSelectionColor;
    }

    public void setEdgeBothSelectionColor(Color edgeBothSelectionColor) {
        Color oldValue = this.edgeBothSelectionColor;
        if (oldValue != edgeBothSelectionColor) {
            this.edgeBothSelectionColor = edgeBothSelectionColor;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeBothSelectionColor(edgeBothSelectionColor));
            this.firePropertyChange("edgeBothSelectionColor", oldValue, edgeBothSelectionColor);
        }
    }

    public float getNodeScale() {
        return this.nodeScale;
    }

    public void setNodeScale(float nodeScale) {
        float oldValue = this.nodeScale;
        if (oldValue != nodeScale) {
            this.nodeScale = nodeScale;
            this.getRenderingOptions().ifPresent(options -> options.setNodeScale(nodeScale));
            this.firePropertyChange("nodeScale", Float.valueOf(oldValue), Float.valueOf(nodeScale));
        }
    }

    public float getEdgeScale() {
        return this.edgeScale;
    }

    public void setEdgeScale(float edgeScale) {
        float oldValue = this.edgeScale;
        if (oldValue != edgeScale) {
            this.edgeScale = edgeScale;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeScale(edgeScale));
            this.firePropertyChange("edgeScale", Float.valueOf(oldValue), Float.valueOf(edgeScale));
        }
    }

    public boolean isUseEdgeWeight() {
        return this.edgeWeightEnabled;
    }

    public void setUseEdgeWeight(boolean useEdgeWeight) {
        boolean oldValue = this.edgeWeightEnabled;
        if (oldValue != useEdgeWeight) {
            this.edgeWeightEnabled = useEdgeWeight;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeWeightEnabled(useEdgeWeight));
            this.firePropertyChange("useEdgeWeight", oldValue, useEdgeWeight);
        }
    }

    public boolean isRescaleEdgeWeight() {
        return this.edgeRescaleWeightEnabled;
    }

    public void setEdgeRescaleWeightEnabled(boolean edgeRescaleWeightEnabled) {
        boolean oldValue = this.edgeRescaleWeightEnabled;
        if (oldValue != edgeRescaleWeightEnabled) {
            this.edgeRescaleWeightEnabled = edgeRescaleWeightEnabled;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeRescaleWeightEnabled(edgeRescaleWeightEnabled));
            this.firePropertyChange("edgeRescaleWeightEnabled", oldValue, edgeRescaleWeightEnabled);
        }
    }

    public boolean isShowNodeLabels() {
        return this.showNodeLabels;
    }

    public void setShowNodeLabels(boolean showNodeLabels) {
        boolean oldValue = this.showNodeLabels;
        if (oldValue != showNodeLabels) {
            this.showNodeLabels = showNodeLabels;
            this.getRenderingOptions().ifPresent(options -> options.setShowNodeLabels(showNodeLabels));
            this.firePropertyChange("showNodeLabels", oldValue, showNodeLabels);
        }
    }

    public boolean isShowEdgeLabels() {
        return this.showEdgeLabels;
    }

    public void setShowEdgeLabels(boolean showEdgeLabels) {
        boolean oldValue = this.showEdgeLabels;
        if (oldValue != showEdgeLabels) {
            this.showEdgeLabels = showEdgeLabels;
            this.getRenderingOptions().ifPresent(options -> options.setShowEdgeLabels(showEdgeLabels));
            this.firePropertyChange("showEdgeLabels", oldValue, showEdgeLabels);
        }
    }

    public LabelColorMode getNodeLabelColorMode() {
        return this.nodeLabelColorMode;
    }

    public void setNodeLabelColorMode(LabelColorMode nodeLabelColorMode) {
        LabelColorMode oldValue = this.nodeLabelColorMode;
        if (oldValue != nodeLabelColorMode) {
            this.nodeLabelColorMode = nodeLabelColorMode;
            this.getRenderingOptions().ifPresent(options -> options.setNodeLabelColorMode(GraphRenderingOptions.LabelColorMode.valueOf((String)nodeLabelColorMode.name())));
            this.firePropertyChange("nodeLabelColorMode", oldValue, nodeLabelColorMode);
        }
    }

    public LabelSizeMode getNodeLabelSizeMode() {
        return this.nodeLabelSizeMode;
    }

    public void setNodeLabelSizeMode(LabelSizeMode nodeLabelSizeMode) {
        LabelSizeMode oldValue = this.nodeLabelSizeMode;
        if (oldValue != nodeLabelSizeMode) {
            this.nodeLabelSizeMode = nodeLabelSizeMode;
            this.getRenderingOptions().ifPresent(options -> options.setNodeLabelSizeMode(GraphRenderingOptions.LabelSizeMode.valueOf((String)nodeLabelSizeMode.name())));
            this.firePropertyChange("nodeLabelSizeMode", oldValue, nodeLabelSizeMode);
        }
    }

    public Font getNodeLabelFont() {
        return this.nodeLabelFont;
    }

    public void setNodeLabelFont(Font nodeLabelFont) {
        Font oldValue = this.nodeLabelFont;
        if (oldValue != nodeLabelFont) {
            this.nodeLabelFont = nodeLabelFont;
            this.getRenderingOptions().ifPresent(options -> options.setNodeLabelFont(nodeLabelFont));
            this.firePropertyChange("nodeLabelFont", oldValue, nodeLabelFont);
        }
    }

    public Font getEdgeLabelFont() {
        return this.edgeLabelFont;
    }

    public void setEdgeLabelFont(Font edgeLabelFont) {
        Font oldValue = this.edgeLabelFont;
        if (oldValue != edgeLabelFont) {
            this.edgeLabelFont = edgeLabelFont;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeLabelFont(edgeLabelFont));
            this.firePropertyChange("edgeLabelFont", oldValue, edgeLabelFont);
        }
    }

    public LabelColorMode getEdgeLabelColorMode() {
        return this.edgeLabelColorMode;
    }

    public void setEdgeLabelColorMode(LabelColorMode edgeLabelColorMode) {
        LabelColorMode oldValue = this.edgeLabelColorMode;
        if (oldValue != edgeLabelColorMode) {
            this.edgeLabelColorMode = edgeLabelColorMode;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeLabelColorMode(GraphRenderingOptions.LabelColorMode.valueOf((String)edgeLabelColorMode.name())));
            this.firePropertyChange("edgeLabelColorMode", oldValue, edgeLabelColorMode);
        }
    }

    public LabelSizeMode getEdgeLabelSizeMode() {
        return this.edgeLabelSizeMode;
    }

    public void setEdgeLabelSizeMode(LabelSizeMode edgeLabelSizeMode) {
        LabelSizeMode oldValue = this.edgeLabelSizeMode;
        if (oldValue != edgeLabelSizeMode) {
            this.edgeLabelSizeMode = edgeLabelSizeMode;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeLabelSizeMode(GraphRenderingOptions.LabelSizeMode.valueOf((String)edgeLabelSizeMode.name())));
            this.firePropertyChange("edgeLabelSizeMode", oldValue, edgeLabelSizeMode);
        }
    }

    public float getNodeLabelScale() {
        return this.nodeLabelScale;
    }

    public void setNodeLabelScale(float nodeLabelScale) {
        float oldValue = this.nodeLabelScale;
        if (oldValue != nodeLabelScale) {
            this.nodeLabelScale = nodeLabelScale;
            this.getRenderingOptions().ifPresent(options -> options.setNodeLabelScale(nodeLabelScale));
            this.firePropertyChange("nodeLabelScale", Float.valueOf(oldValue), Float.valueOf(nodeLabelScale));
        }
    }

    public float getEdgeLabelScale() {
        return this.edgeLabelScale;
    }

    public void setEdgeLabelScale(float edgeLabelScale) {
        float oldValue = this.edgeLabelScale;
        if (oldValue != edgeLabelScale) {
            this.edgeLabelScale = edgeLabelScale;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeLabelScale(edgeLabelScale));
            this.firePropertyChange("edgeLabelScale", Float.valueOf(oldValue), Float.valueOf(edgeLabelScale));
        }
    }

    public boolean isHideNonSelectedNodeLabels() {
        return this.hideNonSelectedNodeLabels;
    }

    public void setHideNonSelectedNodeLabels(boolean hideNonSelectedNodeLabels) {
        boolean oldValue = this.hideNonSelectedNodeLabels;
        if (oldValue != hideNonSelectedNodeLabels) {
            this.hideNonSelectedNodeLabels = hideNonSelectedNodeLabels;
            this.getRenderingOptions().ifPresent(options -> options.setHideNonSelectedNodeLabels(hideNonSelectedNodeLabels));
            this.firePropertyChange("hideNonSelectedNodeLabels", oldValue, hideNonSelectedNodeLabels);
        }
    }

    public boolean isHideNonSelectedEdgeLabels() {
        return this.hideNonSelectedEdgeLabels;
    }

    public void setHideNonSelectedEdgeLabels(boolean hideNonSelectedEdgeLabels) {
        boolean oldValue = this.hideNonSelectedEdgeLabels;
        if (oldValue != hideNonSelectedEdgeLabels) {
            this.hideNonSelectedEdgeLabels = hideNonSelectedEdgeLabels;
            this.getRenderingOptions().ifPresent(options -> options.setHideNonSelectedEdgeLabels(hideNonSelectedEdgeLabels));
            this.firePropertyChange("hideNonSelectedEdgeLabels", oldValue, hideNonSelectedEdgeLabels);
        }
    }

    public boolean isNodeLabelFitToNodeSize() {
        return this.fitNodeLabelsToNodeSize;
    }

    public void setNodeLabelFitToNodeSize(boolean fitNodeLabelsToNodeSize) {
        boolean oldValue = this.fitNodeLabelsToNodeSize;
        if (oldValue != fitNodeLabelsToNodeSize) {
            this.fitNodeLabelsToNodeSize = fitNodeLabelsToNodeSize;
            this.getRenderingOptions().ifPresent(options -> options.setNodeLabelFitToNodeSize(fitNodeLabelsToNodeSize));
            this.firePropertyChange("nodeLabelFitToNodeSize", oldValue, fitNodeLabelsToNodeSize);
        }
    }

    public boolean isAvoidNodeLabelOverlap() {
        return this.avoidNodeLabelOverlap;
    }

    public void setAvoidNodeLabelOverlap(boolean avoidNodeLabelOverlap) {
        boolean oldValue = this.avoidNodeLabelOverlap;
        if (oldValue != avoidNodeLabelOverlap) {
            this.avoidNodeLabelOverlap = avoidNodeLabelOverlap;
            this.getRenderingOptions().ifPresent(options -> options.setAvoidNodeLabelOverlap(avoidNodeLabelOverlap));
            this.firePropertyChange("avoidNodeLabelOverlap", oldValue, avoidNodeLabelOverlap);
        }
    }

    public Column[] getNodeLabelColumns() {
        return this.nodeLabelColumns;
    }

    public void setNodeLabelColumns(Column[] nodeLabelColumns) {
        Column[] oldValue = this.nodeLabelColumns;
        if (oldValue != nodeLabelColumns) {
            this.nodeLabelColumns = nodeLabelColumns;
            this.getRenderingOptions().ifPresent(options -> options.setNodeLabelColumns(nodeLabelColumns));
            this.firePropertyChange("nodeLabelColumns", oldValue, nodeLabelColumns);
        }
    }

    public Column[] getEdgeLabelColumns() {
        return this.edgeLabelColumns;
    }

    public void setEdgeLabelColumns(Column[] edgeLabelColumns) {
        Column[] oldValue = this.edgeLabelColumns;
        if (oldValue != edgeLabelColumns) {
            this.edgeLabelColumns = edgeLabelColumns;
            this.getRenderingOptions().ifPresent(options -> options.setEdgeLabelColumns(edgeLabelColumns));
            this.firePropertyChange("edgeLabelColumns", oldValue, edgeLabelColumns);
        }
    }

    public void fireSelectionChange() {
        VisualizationPropertyChangeListener[] listenersCopy = this.vizController.listeners.toArray(new VisualizationPropertyChangeListener[0]);
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "selection", null, null);
        for (VisualizationPropertyChangeListener l : listenersCopy) {
            l.propertyChange((VisualizationModel)this, evt);
        }
    }

    public void firePropertyChange(String propertyName, Object oldvalue, Object newValue) {
        if (oldvalue == null && newValue == null) {
            return;
        }
        if (oldvalue != null && oldvalue.equals(newValue)) {
            return;
        }
        if (newValue != null && newValue.equals(oldvalue)) {
            return;
        }
        VisualizationPropertyChangeListener[] listenersCopy = this.vizController.listeners.toArray(new VisualizationPropertyChangeListener[0]);
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldvalue, newValue);
        for (VisualizationPropertyChangeListener l : listenersCopy) {
            l.propertyChange((VisualizationModel)this, evt);
        }
    }

    public int getMouseSelectionDiameter() {
        return this.selectionModel.getMouseSelectionDiameter();
    }

    public boolean isMouseSelectionZoomProportional() {
        return this.selectionModel.isMouseSelectionZoomProportional();
    }

    public boolean isRectangleSelection() {
        return this.selectionModel.isRectangleSelection();
    }

    public boolean isDirectMouseSelection() {
        return this.selectionModel.isDirectMouseSelection();
    }

    public boolean isCustomSelection() {
        return this.selectionModel.isCustomSelection();
    }

    public boolean isSelectionEnabled() {
        return this.selectionModel.isSelectionEnabled();
    }

    public boolean isNodeSelection() {
        return this.selectionModel.isNodeSelection();
    }

    public boolean isSingleNodeSelection() {
        return this.selectionModel.isNodeSelection() && this.selectionModel.isSingleNodeSelection();
    }

    public Collection<Node> getSelectedNodes() {
        return this.selectionModel.getSelectedNodes();
    }

    public void readXML(XMLStreamReader reader, Workspace workspace) throws XMLStreamException {
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if ("textmodel".equalsIgnoreCase(name) || "cameraposition".equalsIgnoreCase(name) || "cameratarget".equalsIgnoreCase(name)) break;
                    if ("showedges".equalsIgnoreCase(name)) {
                        this.setShowEdges(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("lightennonselectedauto".equalsIgnoreCase(name)) {
                        this.setLightenNonSelectedAuto(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("autoselectneighbor".equalsIgnoreCase(name)) {
                        this.setAutoSelectNeighbors(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("hidenonselectededges".equalsIgnoreCase(name)) {
                        this.setHideNonSelectedEdges(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("edgeSelectionColor".equalsIgnoreCase(name)) {
                        this.setEdgeSelectionColor(Boolean.parseBoolean(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("backgroundcolor".equalsIgnoreCase(name)) {
                        this.setBackgroundColor(org.gephi.ui.utils.ColorUtils.decode((String)reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("edgeInSelectionColor".equalsIgnoreCase(name)) {
                        this.setEdgeInSelectionColor(org.gephi.ui.utils.ColorUtils.decode((String)reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("edgeOutSelectionColor".equalsIgnoreCase(name)) {
                        this.setEdgeOutSelectionColor(org.gephi.ui.utils.ColorUtils.decode((String)reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("edgeBothSelectionColor".equalsIgnoreCase(name)) {
                        this.setEdgeBothSelectionColor(org.gephi.ui.utils.ColorUtils.decode((String)reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if ("edgeScale".equalsIgnoreCase(name)) {
                        this.setEdgeScale(Float.parseFloat(reader.getAttributeValue(null, "value")));
                        break;
                    }
                    if (!"screenshotMaker".equalsIgnoreCase(name)) break;
                    break;
                }
                case 2: {
                    if (!"vizmodel".equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        Object cameraPosition = null;
        writer.writeStartElement("cameraposition");
        writer.writeAttribute("x", Float.toString(cameraPosition.x()));
        writer.writeAttribute("y", Float.toString(cameraPosition.y()));
        writer.writeAttribute("z", Float.toString(0.0f));
        writer.writeEndElement();
        writer.writeStartElement("showedges");
        writer.writeAttribute("value", String.valueOf(this.isShowEdges()));
        writer.writeEndElement();
        writer.writeStartElement("lightennonselectedauto");
        writer.writeAttribute("value", String.valueOf(this.isLightenNonSelectedAuto()));
        writer.writeEndElement();
        writer.writeStartElement("autoselectneighbor");
        writer.writeAttribute("value", String.valueOf(this.isAutoSelectNeighbors()));
        writer.writeEndElement();
        writer.writeStartElement("hidenonselectededges");
        writer.writeAttribute("value", String.valueOf(this.isHideNonSelectedEdges()));
        writer.writeEndElement();
        writer.writeStartElement("edgeSelectionColor");
        writer.writeAttribute("value", String.valueOf(this.isEdgeSelectionColor()));
        writer.writeEndElement();
        writer.writeStartElement("backgroundcolor");
        writer.writeAttribute("value", org.gephi.ui.utils.ColorUtils.encode((Color)this.getBackgroundColor()));
        writer.writeEndElement();
        writer.writeStartElement("edgeInSelectionColor");
        writer.writeAttribute("value", org.gephi.ui.utils.ColorUtils.encode((Color)this.getEdgeInSelectionColor()));
        writer.writeEndElement();
        writer.writeStartElement("edgeOutSelectionColor");
        writer.writeAttribute("value", org.gephi.ui.utils.ColorUtils.encode((Color)this.getEdgeOutSelectionColor()));
        writer.writeEndElement();
        writer.writeStartElement("edgeBothSelectionColor");
        writer.writeAttribute("value", org.gephi.ui.utils.ColorUtils.encode((Color)this.getEdgeBothSelectionColor()));
        writer.writeEndElement();
        writer.writeStartElement("edgeScale");
        writer.writeAttribute("value", String.valueOf(this.getEdgeScale()));
        writer.writeEndElement();
    }
}

