/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization;

import com.jogamp.newt.event.NEWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.gephi.project.spi.Controller;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.api.EdgeColorMode;
import org.gephi.visualization.api.LabelColorMode;
import org.gephi.visualization.api.LabelSizeMode;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationEventListener;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.gephi.visualization.component.VizEngineGraphCanvasManager;
import org.gephi.visualization.events.StandardVizEventManager;
import org.gephi.visualization.screenshot.ScreenshotControllerImpl;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.status.GraphSelection;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class VizController
implements VisualizationController,
Controller<VizModel> {
    protected final List<VisualizationPropertyChangeListener> listeners = new ArrayList<VisualizationPropertyChangeListener>();
    private final VizEngineGraphCanvasManager canvasManager;
    private final StandardVizEventManager vizEventManager = new StandardVizEventManager();
    private final ScreenshotControllerImpl screenshotController = new ScreenshotControllerImpl(this);

    public VizController() {
        this.canvasManager = new VizEngineGraphCanvasManager(this);
    }

    public VizModel newModel(Workspace workspace) {
        return new VizModel(this, workspace);
    }

    public VizModel getModel(Workspace workspace) {
        return (VizModel)super.getModel(workspace);
    }

    public Class<VizModel> getModelClass() {
        return VizModel.class;
    }

    public VizModel getModel() {
        return (VizModel)super.getModel();
    }

    public ScreenshotControllerImpl getScreenshotController() {
        return this.screenshotController;
    }

    public VizEngineGraphCanvasManager getCanvasManager() {
        return this.canvasManager;
    }

    public Optional<VizEngine<JOGLRenderingTarget, NEWTEvent>> getEngine() {
        return this.canvasManager.getEngine();
    }

    public void addPropertyChangeListener(VisualizationPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(VisualizationPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void addListener(VisualizationEventListener listener) {
        this.vizEventManager.addListener(listener);
    }

    public void removeListener(VisualizationEventListener listener) {
        this.vizEventManager.removeListener(listener);
    }

    public void setZoom(float zoom) {
        VizModel model = this.getModel();
        model.setZoom(zoom);
    }

    public void setAutoSelectNeighbors(boolean autoSelectNeighbors) {
        VizModel model = this.getModel();
        model.setAutoSelectNeighbors(autoSelectNeighbors);
    }

    public void setBackgroundColor(Color color) {
        VizModel model = this.getModel();
        model.setBackgroundColor(color);
    }

    public void setNodeScale(float nodeScale) {
        VizModel model = this.getModel();
        model.setNodeScale(nodeScale);
    }

    public void setShowEdges(boolean showEdges) {
        VizModel model = this.getModel();
        model.setShowEdges(showEdges);
    }

    private static float[] toColorArray(Color color) {
        return new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f};
    }

    public void setHideNonSelectedEdges(boolean hideNonSelectedEdges) {
        VizModel model = this.getModel();
        model.setHideNonSelectedEdges(hideNonSelectedEdges);
    }

    public void setEdgeWeightEstimator(Estimator estimator) {
        VizModel model = this.getModel();
        model.setEdgeWeightEstimator(estimator);
    }

    public void setLightenNonSelectedAuto(boolean lightenNonSelectedAuto) {
        VizModel model = this.getModel();
        model.setLightenNonSelectedAuto(lightenNonSelectedAuto);
    }

    public void setEdgeColorMode(EdgeColorMode mode) {
        VizModel model = this.getModel();
        model.setEdgeColorMode(mode);
    }

    public void setEdgeSelectionColor(boolean edgeSelectionColor) {
        VizModel model = this.getModel();
        model.setEdgeSelectionColor(edgeSelectionColor);
    }

    public void setEdgeInSelectionColor(Color edgeInSelectionColor) {
        VizModel model = this.getModel();
        model.setEdgeInSelectionColor(edgeInSelectionColor);
    }

    public void setEdgeOutSelectionColor(Color edgeOutSelectionColor) {
        VizModel model = this.getModel();
        model.setEdgeOutSelectionColor(edgeOutSelectionColor);
    }

    public void setEdgeBothSelectionColor(Color edgeBothSelectionColor) {
        VizModel model = this.getModel();
        model.setEdgeBothSelectionColor(edgeBothSelectionColor);
    }

    public void setEdgeScale(float edgeScale) {
        VizModel model = this.getModel();
        model.setEdgeScale(edgeScale);
    }

    public void setUseEdgeWeight(boolean useEdgeWeight) {
        VizModel model = this.getModel();
        model.setUseEdgeWeight(useEdgeWeight);
    }

    public void setRescaleEdgeWeight(boolean rescaleEdgeWeight) {
        VizModel model = this.getModel();
        model.setEdgeRescaleWeightEnabled(rescaleEdgeWeight);
    }

    public void setShowNodeLabels(boolean showNodeLabels) {
        VizModel model = this.getModel();
        model.setShowNodeLabels(showNodeLabels);
    }

    public void setShowEdgeLabels(boolean showEdgeLabels) {
        VizModel model = this.getModel();
        model.setShowEdgeLabels(showEdgeLabels);
    }

    public void setNodeLabelFont(Font font) {
        VizModel model = this.getModel();
        model.setNodeLabelFont(font);
    }

    public void setEdgeLabelFont(Font font) {
        VizModel model = this.getModel();
        model.setEdgeLabelFont(font);
    }

    public void setNodeLabelScale(float scale) {
        VizModel model = this.getModel();
        model.setNodeLabelScale(scale);
    }

    public void setEdgeLabelScale(float scale) {
        VizModel model = this.getModel();
        model.setEdgeLabelScale(scale);
    }

    public void setEdgeLabelColorMode(LabelColorMode mode) {
        VizModel model = this.getModel();
        model.setEdgeLabelColorMode(mode);
    }

    public void setEdgeLabelSizeMode(LabelSizeMode mode) {
        VizModel model = this.getModel();
        model.setEdgeLabelSizeMode(mode);
    }

    public void setNodeLabelColorMode(LabelColorMode mode) {
        VizModel model = this.getModel();
        model.setNodeLabelColorMode(mode);
    }

    public void setNodeLabelSizeMode(LabelSizeMode mode) {
        VizModel model = this.getModel();
        model.setNodeLabelSizeMode(mode);
    }

    public void setHideNonSelectedNodeLabels(boolean hideNonSelected) {
        VizModel model = this.getModel();
        model.setHideNonSelectedNodeLabels(hideNonSelected);
    }

    public void setHideNonSelectedEdgeLabels(boolean hideNonSelected) {
        VizModel model = this.getModel();
        model.setHideNonSelectedEdgeLabels(hideNonSelected);
    }

    public void setNodeLabelFitToNodeSize(boolean fitToNodeSize) {
        VizModel model = this.getModel();
        model.setNodeLabelFitToNodeSize(fitToNodeSize);
    }

    public void setAvoidNodeLabelOverlap(boolean avoidOverlap) {
        VizModel model = this.getModel();
        model.setAvoidNodeLabelOverlap(avoidOverlap);
    }

    public void setNodeLabelColumns(Column[] columns) {
        VizModel model = this.getModel();
        model.setNodeLabelColumns(columns);
    }

    public void setEdgeLabelColumns(Column[] columns) {
        VizModel model = this.getModel();
        model.setEdgeLabelColumns(columns);
    }

    public void destroy() {
    }

    public StandardVizEventManager getVizEventManager() {
        return this.vizEventManager;
    }

    public void centerOnGraph() {
        this.getEngine().ifPresent(VizEngine::centerOnGraph);
    }

    public void centerOnZero() {
        this.centerOn(0.0f, 0.0f, 1000.0f, 1000.0f);
    }

    public void centerOn(float x, float y, float width, float height) {
        this.getEngine().ifPresent(engine -> engine.centerOn((Vector2fc)new Vector2f(x, y), width, height));
    }

    public void centerOnNode(Node node) {
        if (node == null) {
            return;
        }
        this.getEngine().ifPresent(engine -> {
            Vector2f position = new Vector2f(node.x(), node.y());
            float size = node.size() * 10.0f;
            engine.centerOn((Vector2fc)position, size, size);
        });
    }

    public void centerOnEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        this.getEngine().ifPresent(engine -> {
            Node source = edge.getSource();
            Node target = edge.getTarget();
            float len = (float)Math.hypot(source.x() - target.x(), source.y() - target.y());
            Vector2f position = new Vector2f((source.x() + target.x()) / 2.0f, (source.y() + target.y()) / 2.0f);
            engine.centerOn((Vector2fc)position, len, len);
        });
    }

    public synchronized void disableSelection() {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.getSelectionModel().setSelectionEnable(false);
        model.getSelectionModel().setRectangleSelection(false);
        model.getSelectionModel().setCustomSelection(false);
        model.getSelectionModel().setSingleNodeSelection(false);
        model.getSelectionModel().setNodeSelection(false);
        this.setEngineSelectionMode(GraphSelection.GraphSelectionMode.NO_SELECTION);
        model.fireSelectionChange();
    }

    public void setMouseSelectionDiameter(int diameter) {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.getSelectionModel().setMouseSelectionDiameter(diameter);
        this.setEngineSelectionDiameter(diameter);
        model.fireSelectionChange();
    }

    public void setMouseSelectionZoomProportional(boolean proportional) {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.getSelectionModel().setMouseSelectionZoomProportional(proportional);
        this.setEngineMouseSelectionZoomProportional(proportional);
        model.fireSelectionChange();
    }

    public synchronized void setRectangleSelection() {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.getSelectionModel().setSelectionEnable(true);
        model.getSelectionModel().setRectangleSelection(true);
        model.getSelectionModel().setCustomSelection(false);
        model.getSelectionModel().setSingleNodeSelection(false);
        model.getSelectionModel().setNodeSelection(false);
        this.setEngineSelectionMode(GraphSelection.GraphSelectionMode.RECTANGLE_SELECTION);
        model.fireSelectionChange();
    }

    public synchronized void setDirectMouseSelection() {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.getSelectionModel().setSelectionEnable(true);
        model.getSelectionModel().setRectangleSelection(false);
        model.getSelectionModel().setCustomSelection(false);
        model.getSelectionModel().setNodeSelection(false);
        model.getSelectionModel().setSingleNodeSelection(false);
        this.setEngineSelectionMode(GraphSelection.GraphSelectionMode.SIMPLE_MOUSE_SELECTION);
        model.fireSelectionChange();
    }

    public void setNodeSelection(boolean singleNode) {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.getSelectionModel().setSelectionEnable(true);
        model.getSelectionModel().setRectangleSelection(false);
        model.getSelectionModel().setCustomSelection(false);
        model.getSelectionModel().setNodeSelection(true);
        model.getSelectionModel().setSingleNodeSelection(singleNode);
        if (singleNode) {
            this.setEngineSelectionMode(GraphSelection.GraphSelectionMode.SINGLE_NODE_SELECTION);
        } else {
            this.setEngineSelectionMode(GraphSelection.GraphSelectionMode.MULTI_NODE_SELECTION);
        }
        model.fireSelectionChange();
    }

    public synchronized void setCustomSelection() {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.getSelectionModel().setSelectionEnable(true);
        model.getSelectionModel().setCustomSelection(true);
        this.setEngineSelectionMode(GraphSelection.GraphSelectionMode.CUSTOM_SELECTION);
        model.fireSelectionChange();
    }

    public synchronized void resetSelection() {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        if (model.getSelectionModel().isCustomSelection()) {
            model.getSelectionModel().currentEngineSelectionModel().ifPresent(GraphSelection::clearSelection);
            model.getSelectionModel().setCustomSelection(false);
            if (model.getSelectionModel().isRectangleSelection()) {
                this.setEngineSelectionMode(GraphSelection.GraphSelectionMode.RECTANGLE_SELECTION);
            } else if (model.getSelectionModel().isNodeSelection()) {
                if (model.getSelectionModel().isSingleNodeSelection()) {
                    this.setEngineSelectionMode(GraphSelection.GraphSelectionMode.SINGLE_NODE_SELECTION);
                } else {
                    this.setEngineSelectionMode(GraphSelection.GraphSelectionMode.MULTI_NODE_SELECTION);
                }
            } else if (model.getSelectionModel().isDirectMouseSelection()) {
                this.setEngineSelectionMode(GraphSelection.GraphSelectionMode.SIMPLE_MOUSE_SELECTION);
            } else {
                this.setEngineSelectionMode(GraphSelection.GraphSelectionMode.NO_SELECTION);
            }
            model.fireSelectionChange();
        }
    }

    public void selectNodes(Node[] nodes) {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        if (!model.isCustomSelection()) {
            this.setCustomSelection();
        }
        model.getSelectionModel().currentEngineSelectionModel().ifPresent(selection -> {
            if (nodes == null || nodes.length == 0) {
                selection.clearSelectedNodes();
            } else {
                selection.setSelectedNodes(nodes);
            }
        });
    }

    public void selectEdges(Edge[] edges) {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        if (!model.isCustomSelection()) {
            this.setCustomSelection();
        }
        model.getSelectionModel().currentEngineSelectionModel().ifPresent(selection -> {
            if (edges == null) {
                selection.clearSelectedEdges();
            } else {
                selection.setSelectedEdges(edges);
            }
        });
    }

    private void setEngineSelectionMode(GraphSelection.GraphSelectionMode mode) {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.getSelectionModel().currentEngineSelectionModel().ifPresent(graphSelection -> graphSelection.setMode(mode));
    }

    private void setEngineSelectionDiameter(float diameter) {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.getSelectionModel().currentEngineSelectionModel().ifPresent(graphSelection -> graphSelection.setMouseSelectionDiameter(diameter));
    }

    private void setEngineMouseSelectionZoomProportional(boolean proportional) {
        VizModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.getSelectionModel().currentEngineSelectionModel().ifPresent(graphSelection -> graphSelection.setMouseSelectionDiameterZoomProportional(proportional));
    }
}

