/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.gephi.graph.api.Node;
import org.gephi.visualization.VizConfig;
import org.gephi.visualization.VizModel;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.status.GraphSelectionImpl;

public class SelectionModelImpl {
    private final VizModel visualizationModel;
    private int mouseSelectionDiameter;
    private boolean mouseSelectionZoomProportional;
    private boolean rectangleSelection = false;
    private boolean selectionEnable = true;
    private boolean customSelection = false;
    private boolean singleNodeSelection = false;
    private boolean nodeSelection = false;

    public SelectionModelImpl(VizModel visualizationModel) {
        this.visualizationModel = visualizationModel;
        this.mouseSelectionDiameter = VizConfig.getDefaultMouseSelectionDiameter();
    }

    public GraphSelection toGraphSelection() {
        GraphSelectionImpl gs = new GraphSelectionImpl();
        if (this.selectionEnable) {
            if (this.rectangleSelection) {
                gs.setMode(GraphSelection.GraphSelectionMode.RECTANGLE_SELECTION);
            } else if (this.customSelection) {
                gs.setMode(GraphSelection.GraphSelectionMode.CUSTOM_SELECTION);
            } else if (this.nodeSelection) {
                if (this.singleNodeSelection) {
                    gs.setMode(GraphSelection.GraphSelectionMode.SINGLE_NODE_SELECTION);
                } else {
                    gs.setMode(GraphSelection.GraphSelectionMode.MULTI_NODE_SELECTION);
                }
            } else {
                gs.setMode(GraphSelection.GraphSelectionMode.SIMPLE_MOUSE_SELECTION);
            }
        }
        gs.setMouseSelectionDiameter((float)this.mouseSelectionDiameter);
        gs.setMouseSelectionDiameterZoomProportional(this.mouseSelectionZoomProportional);
        return gs;
    }

    protected Optional<GraphSelection> currentEngineSelectionModel() {
        return this.visualizationModel.getEngine().map(VizEngine::getGraphSelection);
    }

    public Collection<Node> getSelectedNodes() {
        return this.currentEngineSelectionModel().map(GraphSelection::getSelectedNodes).orElse(Collections.emptyList());
    }

    public int getMouseSelectionDiameter() {
        return this.mouseSelectionDiameter;
    }

    protected void setMouseSelectionDiameter(int mouseSelectionDiameter) {
        this.mouseSelectionDiameter = mouseSelectionDiameter;
    }

    public boolean isMouseSelectionZoomProportional() {
        return this.mouseSelectionZoomProportional;
    }

    protected void setMouseSelectionZoomProportional(boolean mouseSelectionZoomProportional) {
        this.mouseSelectionZoomProportional = mouseSelectionZoomProportional;
    }

    protected void setSelectionEnable(boolean selectionEnable) {
        this.selectionEnable = selectionEnable;
    }

    protected void setRectangleSelection(boolean rectangleSelection) {
        this.rectangleSelection = rectangleSelection;
    }

    protected void setCustomSelection(boolean customSelection) {
        this.customSelection = customSelection;
    }

    public void setSingleNodeSelection(boolean singleNodeSelection) {
        this.singleNodeSelection = singleNodeSelection;
    }

    public void setNodeSelection(boolean nodeSelection) {
        this.nodeSelection = nodeSelection;
    }

    public boolean isRectangleSelection() {
        return this.selectionEnable && this.rectangleSelection;
    }

    public boolean isDirectMouseSelection() {
        return this.selectionEnable && !this.rectangleSelection;
    }

    public boolean isCustomSelection() {
        return this.selectionEnable && this.customSelection;
    }

    public boolean isSingleNodeSelection() {
        return this.singleNodeSelection;
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnable;
    }

    public boolean isNodeSelection() {
        return this.nodeSelection;
    }
}

