/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.tools;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.gephi.ui.utils.UIUtils;

public class Toolbar
extends JToolBar {
    private final ButtonGroup buttonGroup;

    public Toolbar() {
        this.initDesign();
        this.buttonGroup = new ButtonGroup();
    }

    private void initDesign() {
        this.setFloatable(false);
        this.setOrientation(1);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.setOpaque(true);
    }

    @Override
    public void setEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : Toolbar.this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        });
    }

    public void clearSelection() {
        this.buttonGroup.clearSelection();
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof JButton) {
            UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
        }
        if (comp instanceof AbstractButton) {
            this.buttonGroup.add((AbstractButton)comp);
        }
        return super.add(comp);
    }
}

