/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gephi.desktop.visualization.selection.SelectionPropertiesToolbar;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.openide.util.Lookup;

public class PropertiesBar
extends JPanel {
    private final SelectionPropertiesToolbar selectionBar;
    private final JLabel fpsLabel;
    private volatile boolean fpsThreadRunning = false;
    private Thread fpsThread;

    public PropertiesBar() {
        super(new BorderLayout());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setOpaque(true);
        this.fpsLabel = new JLabel();
        leftPanel.add((Component)this.getFpsPanel(), "West");
        this.selectionBar = new SelectionPropertiesToolbar();
        leftPanel.add((Component)this.selectionBar, "Center");
        this.add((Component)leftPanel, "West");
        this.setOpaque(true);
    }

    public void setup(VisualizationModel vizModel) {
        this.selectionBar.setup(vizModel);
        this.startFpsThread();
    }

    public void unsetup() {
        this.selectionBar.unsetup();
        this.stopFpsThread();
        SwingUtilities.invokeLater(() -> this.fpsLabel.setText(""));
    }

    public void addToolsPropertiesBar(JComponent component) {
        this.add((Component)component, "Center");
    }

    private JComponent getFpsPanel() {
        int logoWidth = 27;
        int logoHeight = 28;
        if (UIUtils.isAquaLookAndFeel()) {
            logoWidth = 34;
        }
        JPanel c = new JPanel(new BorderLayout());
        this.fpsLabel.setText("");
        this.fpsLabel.setFont(new Font("Lucida Grande", 0, 8));
        this.fpsLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        c.add((Component)this.fpsLabel, "Center");
        c.setPreferredSize(new Dimension(logoWidth, logoHeight));
        return c;
    }

    private void startFpsThread() {
        if (this.fpsThreadRunning) {
            return;
        }
        this.fpsThreadRunning = true;
        this.fpsThread = new Thread(() -> {
            VisualizationController controller = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            while (this.fpsThreadRunning) {
                VisualizationModel model = controller.getModel();
                String text = "";
                if (model != null) {
                    text = String.valueOf(model.getFps());
                }
                String fpsText = text;
                SwingUtilities.invokeLater(() -> {
                    if (this.fpsLabel != null) {
                        this.fpsLabel.setText(fpsText);
                    }
                });
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }, "Refresh FPS Label");
        this.fpsThread.setDaemon(true);
        this.fpsThread.start();
    }

    private void stopFpsThread() {
        this.fpsThreadRunning = false;
        if (this.fpsThread != null) {
            this.fpsThread.interrupt();
            this.fpsThread = null;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        SwingUtilities.invokeLater(() -> {
            for (Component c : this.getComponents()) {
                c.setEnabled(enabled);
            }
            this.selectionBar.setEnabled(enabled);
        });
    }
}

