/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.gephi.desktop.visualization.tools.Toolbar;
import org.gephi.desktop.visualization.tools.ToolsPropertiesBar;
import org.gephi.graph.api.Node;
import org.gephi.tools.api.ToolController;
import org.gephi.tools.spi.MouseClickEventListener;
import org.gephi.tools.spi.NodeClickEventListener;
import org.gephi.tools.spi.NodePressAndDraggingEventListener;
import org.gephi.tools.spi.NodePressingEventListener;
import org.gephi.tools.spi.Tool;
import org.gephi.tools.spi.ToolEventListener;
import org.gephi.tools.spi.ToolUI;
import org.gephi.tools.spi.UnselectToolException;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationEvent;
import org.gephi.visualization.api.VisualizationEventListener;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public class DesktopToolController
implements ToolController {
    private final Tool[] tools = Lookup.getDefault().lookupAll(Tool.class).toArray(new Tool[0]);
    private final VisualizationController visualizationController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
    private ToolsPropertiesBar toolsPropertiesBar;
    private Tool currentTool;
    private ToolEventHandler[] currentHandlers;

    public void select(Tool tool) {
        this.unselect();
        if (tool == null) {
            return;
        }
        ArrayList<ToolEventHandler> handlers = new ArrayList<ToolEventHandler>();
        for (ToolEventListener toolListener : tool.getListeners()) {
            ToolEventHandler h;
            if (toolListener instanceof NodeClickEventListener) {
                h = new NodeClickEventHandler(toolListener);
                ((NodeClickEventHandler)h).select();
                handlers.add(h);
                continue;
            }
            if (toolListener instanceof NodePressingEventListener) {
                h = new NodePressingEventHandler(toolListener);
                ((NodePressingEventHandler)h).select();
                handlers.add(h);
                continue;
            }
            if (toolListener instanceof MouseClickEventListener) {
                h = new MouseClickEventHandler(toolListener);
                ((MouseClickEventHandler)h).select();
                handlers.add(h);
                continue;
            }
            if (toolListener instanceof NodePressAndDraggingEventListener) {
                h = new NodePressAndDraggingEventHandler(toolListener);
                ((NodePressAndDraggingEventHandler)h).select();
                handlers.add(h);
                continue;
            }
            throw new RuntimeException("The ToolEventListener " + toolListener.getClass().getSimpleName() + " cannot be recognized");
        }
        this.currentHandlers = handlers.toArray(new ToolEventHandler[0]);
        switch (tool.getSelectionType()) {
            case NONE: {
                this.visualizationController.disableSelection();
                break;
            }
            case SINGLE_NODE_SELECTION: {
                this.visualizationController.setNodeSelection(true);
                break;
            }
            case SELECTION: 
            case SELECTION_AND_DRAGGING: {
                this.visualizationController.setNodeSelection(false);
            }
        }
        this.currentTool = tool;
        this.currentTool.select();
    }

    public void unselect() {
        if (this.currentTool != null) {
            for (ToolEventHandler handler : this.currentHandlers) {
                handler.unselect();
            }
            this.currentTool.unselect();
            this.currentHandlers = null;
            this.currentTool = null;
            if (this.toolsPropertiesBar != null) {
                this.toolsPropertiesBar.unselect();
            }
        }
    }

    public JComponent getToolbar() {
        HashMap<ToolUI, Tool> toolMap = new HashMap<ToolUI, Tool>();
        ArrayList<ToolUI> toolsUI = new ArrayList<ToolUI>();
        for (final Tool tool : this.tools) {
            ToolUI ui = tool.getUI();
            if (ui == null) continue;
            toolsUI.add(ui);
            toolMap.put(ui, tool);
        }
        Collections.sort(toolsUI, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer p1 = ((ToolUI)o1).getPosition();
                Integer p2 = ((ToolUI)o2).getPosition();
                return p1.compareTo(p2);
            }
        });
        final Toolbar toolbar = new Toolbar();
        for (final ToolUI toolUI : toolsUI) {
            Tool tool;
            tool = (Tool)toolMap.get(toolUI);
            JToggleButton btn = toolUI.getIcon() != null ? new JToggleButton(toolUI.getIcon()) : new JToggleButton(ImageUtilities.loadImageIcon((String)"VisualizationImpl/tool.svg", (boolean)false));
            btn.setFocusPainted(false);
            btn.setToolTipText(toolUI.getName() + " - " + toolUI.getDescription());
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (tool == DesktopToolController.this.currentTool) {
                        toolbar.clearSelection();
                        DesktopToolController.this.unselect();
                        DesktopToolController.this.visualizationController.setDirectMouseSelection();
                    } else {
                        try {
                            DesktopToolController.this.select(tool);
                            DesktopToolController.this.toolsPropertiesBar.select(toolUI.getPropertiesBar(tool));
                        }
                        catch (UnselectToolException unselectToolException) {
                            toolbar.clearSelection();
                            DesktopToolController.this.unselect();
                        }
                    }
                }
            });
            toolbar.add(btn);
        }
        this.visualizationController.addPropertyChangeListener(new VisualizationPropertyChangeListener(){

            public void propertyChange(VisualizationModel model, PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selection") && DesktopToolController.this.currentTool != null && !model.isCustomSelection() && !model.isNodeSelection()) {
                    toolbar.clearSelection();
                    DesktopToolController.this.unselect();
                }
            }
        });
        return toolbar;
    }

    public JComponent getPropertiesBar() {
        this.toolsPropertiesBar = new ToolsPropertiesBar();
        return this.toolsPropertiesBar;
    }

    private static class NodeClickEventHandler
    implements ToolEventHandler {
        private NodeClickEventListener toolEventListener;
        private VisualizationEventListener currentListener;

        public NodeClickEventHandler(ToolEventListener toolListener) {
            this.toolEventListener = (NodeClickEventListener)toolListener;
        }

        @Override
        public void select() {
            this.currentListener = new VisualizationEventListener(){

                public boolean handleEvent(VisualizationEvent event) {
                    return toolEventListener.clickNodes((Node[])event.getData());
                }

                public VisualizationEvent.Type getType() {
                    return VisualizationEvent.Type.NODE_LEFT_CLICK;
                }
            };
            VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            vizController.addListener(this.currentListener);
        }

        @Override
        public void unselect() {
            VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            vizController.removeListener(this.currentListener);
            this.currentListener = null;
            this.toolEventListener = null;
        }
    }

    private static class NodePressingEventHandler
    implements ToolEventHandler {
        private NodePressingEventListener toolEventListener;
        private VisualizationEventListener[] currentListeners;

        public NodePressingEventHandler(ToolEventListener toolListener) {
            this.toolEventListener = (NodePressingEventListener)toolListener;
        }

        @Override
        public void select() {
            this.currentListeners = new VisualizationEventListener[2];
            this.currentListeners[0] = new VisualizationEventListener(){

                public boolean handleEvent(VisualizationEvent event) {
                    return toolEventListener.pressingNodes((Node[])event.getData());
                }

                public VisualizationEvent.Type getType() {
                    return VisualizationEvent.Type.NODE_LEFT_PRESSING;
                }
            };
            this.currentListeners[1] = new VisualizationEventListener(){

                public boolean handleEvent(VisualizationEvent event) {
                    return toolEventListener.released();
                }

                public VisualizationEvent.Type getType() {
                    return VisualizationEvent.Type.MOUSE_RELEASED;
                }
            };
            VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            vizController.addListener(this.currentListeners[0]);
            vizController.addListener(this.currentListeners[1]);
        }

        @Override
        public void unselect() {
            VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            vizController.removeListener(this.currentListeners[0]);
            vizController.removeListener(this.currentListeners[1]);
            this.toolEventListener = null;
            this.currentListeners = null;
        }
    }

    private static class MouseClickEventHandler
    implements ToolEventHandler {
        private MouseClickEventListener toolEventListener;
        private VisualizationEventListener currentListener;

        public MouseClickEventHandler(ToolEventListener toolListener) {
            this.toolEventListener = (MouseClickEventListener)toolListener;
        }

        @Override
        public void select() {
            this.currentListener = new VisualizationEventListener(){

                public boolean handleEvent(VisualizationEvent event) {
                    float[] data = (float[])event.getData();
                    int[] viewport = new int[]{(int)data[0], (int)data[1]};
                    float[] worldPosition = new float[]{data[2], data[3]};
                    return toolEventListener.mouseClick(viewport, worldPosition);
                }

                public VisualizationEvent.Type getType() {
                    return VisualizationEvent.Type.MOUSE_LEFT_CLICK;
                }
            };
            VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            vizController.addListener(this.currentListener);
        }

        @Override
        public void unselect() {
            VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            vizController.removeListener(this.currentListener);
            this.toolEventListener = null;
            this.currentListener = null;
        }
    }

    private static class NodePressAndDraggingEventHandler
    implements ToolEventHandler {
        private NodePressAndDraggingEventListener toolEventListener;
        private VisualizationEventListener[] currentListeners;

        public NodePressAndDraggingEventHandler(ToolEventListener toolListener) {
            this.toolEventListener = (NodePressAndDraggingEventListener)toolListener;
        }

        @Override
        public void select() {
            this.currentListeners = new VisualizationEventListener[3];
            this.currentListeners[0] = new VisualizationEventListener(){

                public boolean handleEvent(VisualizationEvent event) {
                    return toolEventListener.pressNodes((Node[])event.getData());
                }

                public VisualizationEvent.Type getType() {
                    return VisualizationEvent.Type.NODE_LEFT_PRESS;
                }
            };
            this.currentListeners[1] = new VisualizationEventListener(){

                public boolean handleEvent(VisualizationEvent event) {
                    float[] mouseDrag = (float[])event.getData();
                    return toolEventListener.drag(mouseDrag[0], mouseDrag[1], mouseDrag[2], mouseDrag[3]);
                }

                public VisualizationEvent.Type getType() {
                    return VisualizationEvent.Type.DRAG;
                }
            };
            this.currentListeners[2] = new VisualizationEventListener(){

                public boolean handleEvent(VisualizationEvent event) {
                    toolEventListener.released();
                    return false;
                }

                public VisualizationEvent.Type getType() {
                    return VisualizationEvent.Type.STOP_DRAG;
                }
            };
            VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            vizController.addListener(this.currentListeners[0]);
            vizController.addListener(this.currentListeners[1]);
            vizController.addListener(this.currentListeners[2]);
        }

        @Override
        public void unselect() {
            VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            vizController.removeListener(this.currentListeners[0]);
            vizController.removeListener(this.currentListeners[1]);
            vizController.removeListener(this.currentListeners[2]);
            this.toolEventListener = null;
            this.currentListeners = null;
        }
    }

    private static interface ToolEventHandler {
        public void select();

        public void unselect();
    }
}

