/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.selection;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SelectionToolbar
extends JToolBar
implements VisualizationPropertyChangeListener {
    private final JToggleButton mouseButton;
    private final JToggleButton rectangleButton;
    private final JToggleButton panButton;
    private final ButtonGroup buttonGroup;
    private final VisualizationController visualizationController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);

    public SelectionToolbar() {
        this.setFloatable(false);
        this.setOrientation(1);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.buttonGroup = new ButtonGroup();
        this.mouseButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"VisualizationImpl/mouse.svg", (boolean)false));
        this.mouseButton.setToolTipText(NbBundle.getMessage(SelectionToolbar.class, (String)"SelectionToolbar.mouse.tooltip"));
        this.mouseButton.addActionListener(e -> this.visualizationController.setDirectMouseSelection());
        this.mouseButton.setFocusPainted(false);
        this.add(this.mouseButton);
        ImageIcon icon = ImageUtilities.loadImageIcon((String)"VisualizationImpl/rectangle.svg", (boolean)false);
        this.rectangleButton = new JToggleButton(icon);
        this.rectangleButton.setToolTipText(NbBundle.getMessage(SelectionToolbar.class, (String)"SelectionToolbar.rectangle.tooltip"));
        this.rectangleButton.addActionListener(e -> this.visualizationController.setRectangleSelection());
        this.rectangleButton.setFocusPainted(false);
        this.add(this.rectangleButton);
        this.panButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"VisualizationImpl/pan.svg", (boolean)false));
        this.panButton.setToolTipText(NbBundle.getMessage(SelectionToolbar.class, (String)"SelectionToolbar.pan.tooltip"));
        this.panButton.addActionListener(e -> {
            if (this.panButton.isSelected()) {
                this.visualizationController.disableSelection();
            }
        });
        this.panButton.setFocusPainted(false);
        this.add(this.panButton);
        this.addSeparator();
        for (Component c : this.getComponents()) {
            c.setEnabled(false);
        }
    }

    public void setup(VisualizationModel vizModel) {
        this.setEnabled(true);
        this.visualizationController.addPropertyChangeListener((VisualizationPropertyChangeListener)this);
        this.refresh(vizModel);
    }

    public void unsetup(VisualizationModel vizModel) {
        this.setEnabled(false);
        this.visualizationController.removePropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    public void propertyChange(VisualizationModel model, PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("selection")) {
            this.refresh(model);
        }
    }

    private void refresh(final VisualizationModel vizModel) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (vizModel.isCustomSelection() || vizModel.isNodeSelection()) {
                    SelectionToolbar.this.buttonGroup.clearSelection();
                } else if (!vizModel.isSelectionEnabled()) {
                    if (!SelectionToolbar.this.buttonGroup.isSelected(SelectionToolbar.this.panButton.getModel())) {
                        SelectionToolbar.this.buttonGroup.setSelected(SelectionToolbar.this.panButton.getModel(), true);
                    }
                } else if (vizModel.isDirectMouseSelection()) {
                    if (!SelectionToolbar.this.buttonGroup.isSelected(SelectionToolbar.this.mouseButton.getModel())) {
                        SelectionToolbar.this.buttonGroup.setSelected(SelectionToolbar.this.mouseButton.getModel(), true);
                    }
                } else if (vizModel.isRectangleSelection() && !SelectionToolbar.this.buttonGroup.isSelected(SelectionToolbar.this.rectangleButton.getModel())) {
                    SelectionToolbar.this.buttonGroup.setSelected(SelectionToolbar.this.rectangleButton.getModel(), true);
                }
            }
        });
    }

    @Override
    public void setEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : SelectionToolbar.this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        });
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof JButton) {
            UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
        }
        if (comp instanceof AbstractButton) {
            this.buttonGroup.add((AbstractButton)comp);
        }
        return super.add(comp);
    }
}

