/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.selection;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.gephi.desktop.visualization.selection.MouseSelectionPopupPanel;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SelectionPropertiesToolbar
extends JPanel
implements VisualizationPropertyChangeListener {
    private final VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
    private JXHyperlink configureLink;
    private JSeparator endSeparator;
    private JLabel statusLabel;

    public SelectionPropertiesToolbar() {
        this.initComponents();
        this.configureLink.addActionListener(e -> {
            if (this.statusLabel.isEnabled()) {
                JPopupMenu menu = this.createPopup();
                menu.show(this.statusLabel, 0, this.statusLabel.getHeight());
            }
        });
        this.configureLink.setVisible(false);
    }

    public void propertyChange(VisualizationModel model, PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("selection")) {
            this.refresh(model);
        }
    }

    public void setup(VisualizationModel vizModel) {
        this.vizController.addPropertyChangeListener((VisualizationPropertyChangeListener)this);
        this.refresh(vizModel);
    }

    public void unsetup() {
        this.vizController.removePropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    public JPopupMenu createPopup() {
        VisualizationController controller = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        VisualizationModel model = controller.getModel();
        MouseSelectionPopupPanel popupPanel = new MouseSelectionPopupPanel();
        popupPanel.setDiameter(model.getMouseSelectionDiameter());
        popupPanel.setProportionnalToZoom(model.isMouseSelectionZoomProportional());
        popupPanel.setChangeListener(e -> {
            controller.setMouseSelectionDiameter(popupPanel.getDiameter());
            controller.setMouseSelectionZoomProportional(popupPanel.isProportionnalToZoom());
        });
        JPopupMenu menu = new JPopupMenu();
        menu.add(popupPanel);
        return menu;
    }

    public void refresh(VisualizationModel vizModel) {
        SwingUtilities.invokeLater(() -> {
            if (vizModel == null) {
                this.configureLink.setVisible(false);
                this.statusLabel.setText(NbBundle.getMessage(SelectionPropertiesToolbar.class, (String)"SelectionBar.statusLabel.noSelection"));
                return;
            }
            if (vizModel.isSelectionEnabled()) {
                if (vizModel.isCustomSelection()) {
                    this.configureLink.setVisible(false);
                    this.statusLabel.setText(NbBundle.getMessage(SelectionPropertiesToolbar.class, (String)"SelectionBar.statusLabel.customSelection"));
                } else if (vizModel.isNodeSelection()) {
                    this.configureLink.setVisible(!vizModel.isSingleNodeSelection());
                    this.statusLabel.setText(NbBundle.getMessage(SelectionPropertiesToolbar.class, (String)"SelectionBar.statusLabel.nodeSelection"));
                } else if (vizModel.isRectangleSelection()) {
                    this.configureLink.setVisible(false);
                    this.statusLabel.setText(NbBundle.getMessage(SelectionPropertiesToolbar.class, (String)"SelectionBar.statusLabel.rectangleSelection"));
                } else if (vizModel.isDirectMouseSelection()) {
                    this.configureLink.setVisible(true);
                    this.statusLabel.setText(NbBundle.getMessage(SelectionPropertiesToolbar.class, (String)"SelectionBar.statusLabel.mouseSelection"));
                }
            } else {
                this.configureLink.setVisible(false);
                this.statusLabel.setText(NbBundle.getMessage(SelectionPropertiesToolbar.class, (String)"SelectionBar.statusLabel.noSelection"));
            }
        });
    }

    private void initComponents() {
        this.statusLabel = new JLabel();
        this.configureLink = new JXHyperlink();
        this.endSeparator = new JSeparator();
        this.setPreferredSize(new Dimension(180, 28));
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(10.0f));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 1, 0);
        this.add((Component)this.statusLabel, gridBagConstraints);
        this.configureLink.setText(NbBundle.getMessage(SelectionPropertiesToolbar.class, (String)"SelectionBar.configureLink.text"));
        this.configureLink.setDefaultCapable(false);
        this.configureLink.setFocusable(false);
        this.configureLink.setFont(new Font("Lucida Grande", 0, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.configureLink, gridBagConstraints);
        this.endSeparator.setOrientation(1);
        this.endSeparator.setPreferredSize(new Dimension(3, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.endSeparator, gridBagConstraints);
    }

    @Override
    public void setEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : SelectionPropertiesToolbar.this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        });
    }
}

