/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.screenshot;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.visualization.api.ScreenshotModel;
import org.gephi.visualization.screenshot.ScreenshotControllerImpl;
import org.gephi.viz.engine.jogl.util.ScreenshotTaker;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ScreenshotSettingsPanel
extends JPanel {
    private JCheckBox autoSaveCheckBox;
    private JSpinner customScaleFactorSpinner;
    private JLabel heightLabel;
    private JPanel imagePanel;
    private JLabel labelCustomScaleFactor;
    private JLabel labelHeight;
    private JLabel labelScaleFactor;
    private JLabel labelWidth;
    private JComboBox<String> scaleFactorCombo;
    private JButton selectDirectoryButton;
    private JCheckBox transparentBackgroundCheckbox;
    private JLabel widthLabel;
    private final ScreenshotControllerImpl controller;
    private int surfaceWidth;
    private int surfaceHeight;

    public ScreenshotSettingsPanel(ScreenshotControllerImpl screenshotController) {
        this.controller = screenshotController;
        this.initComponents();
        this.autoSaveCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ScreenshotSettingsPanel.this.selectDirectoryButton.setEnabled(ScreenshotSettingsPanel.this.autoSaveCheckBox.isSelected());
            }
        });
        this.scaleFactorCombo.addItemListener(e -> {
            String customElement = NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.scaleFactorCombo.customItem");
            if (this.scaleFactorCombo.getSelectedItem() != null && this.scaleFactorCombo.getSelectedItem().equals(customElement)) {
                this.customScaleFactorSpinner.setVisible(true);
                this.labelCustomScaleFactor.setVisible(true);
                this.refreshWidthAndHeightLabels((Integer)this.customScaleFactorSpinner.getModel().getValue());
            } else if (this.scaleFactorCombo.getSelectedItem() != null) {
                this.customScaleFactorSpinner.setVisible(false);
                this.labelCustomScaleFactor.setVisible(false);
                this.customScaleFactorSpinner.getModel().setValue(Integer.parseInt(this.scaleFactorCombo.getSelectedItem().toString().replace("x", "")));
            }
        });
        this.customScaleFactorSpinner.addChangeListener(e -> this.refreshWidthAndHeightLabels((Integer)this.customScaleFactorSpinner.getModel().getValue()));
    }

    private void refreshWidthAndHeightLabels(int scaleFactor) {
        if (this.surfaceHeight == 0 || this.surfaceWidth == 0) {
            this.widthLabel.setText("0");
            this.heightLabel.setText("0");
            return;
        }
        int width = this.surfaceWidth * scaleFactor;
        int height = this.surfaceHeight * scaleFactor;
        this.widthLabel.setText(width + "px");
        this.heightLabel.setText(height + "px");
    }

    public void setup(final ScreenshotModel model) {
        int[] standardScaleFactors;
        this.surfaceHeight = this.controller.getSurfaceHeight();
        this.surfaceWidth = this.controller.getSurfaceWidth();
        int maxScaleFactor = ScreenshotTaker.getMaxScaleFactor((int)this.surfaceWidth, (int)this.surfaceHeight, (boolean)true);
        String customElement = NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.scaleFactorCombo.customItem");
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>();
        for (int scaleFactor : standardScaleFactors = new int[]{1, 2, 4, 8, 16, 32, 64}) {
            if (scaleFactor > maxScaleFactor) continue;
            comboModel.addElement(scaleFactor + "x");
        }
        comboModel.addElement(customElement);
        this.scaleFactorCombo.setModel(comboModel);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(Math.min(model.getScaleFactor(), maxScaleFactor), 1, maxScaleFactor, 1);
        this.customScaleFactorSpinner.setModel(spinnerModel);
        this.autoSaveCheckBox.setSelected(model.isAutoSave());
        this.selectDirectoryButton.setEnabled(this.autoSaveCheckBox.isSelected());
        this.customScaleFactorSpinner.setVisible(false);
        this.labelCustomScaleFactor.setVisible(false);
        int modelScaleFactor = Math.min(model.getScaleFactor(), maxScaleFactor);
        boolean foundInCombo = false;
        for (int i = 0; i < comboModel.getSize() - 1; ++i) {
            String item = (String)comboModel.getElementAt(i);
            int itemScaleFactor = Integer.parseInt(item.replace("x", ""));
            if (itemScaleFactor != modelScaleFactor) continue;
            this.scaleFactorCombo.setSelectedIndex(i);
            foundInCombo = true;
            break;
        }
        if (!foundInCombo) {
            this.scaleFactorCombo.setSelectedIndex(comboModel.getSize() - 1);
            this.customScaleFactorSpinner.setValue(modelScaleFactor);
            this.customScaleFactorSpinner.setVisible(true);
            this.labelCustomScaleFactor.setVisible(true);
        }
        this.transparentBackgroundCheckbox.setSelected(model.isTransparentBackground());
        this.selectDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(model.getDefaultDirectory());
                fileChooser.setFileSelectionMode(1);
                int result = fileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
                if (result == 0) {
                    ScreenshotSettingsPanel.this.controller.setDefaultDirectory(fileChooser.getSelectedFile());
                }
            }
        });
        this.refreshWidthAndHeightLabels((Integer)this.customScaleFactorSpinner.getModel().getValue());
    }

    public void unsetup() {
        this.controller.setAutoSave(this.autoSaveCheckBox.isSelected());
        String customElement = NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.scaleFactorCombo.customItem");
        Object selectedItem = this.scaleFactorCombo.getSelectedItem();
        if (selectedItem != null && selectedItem.equals(customElement)) {
            this.controller.setScaleFactor((Integer)this.customScaleFactorSpinner.getModel().getValue());
        } else if (selectedItem != null) {
            this.controller.setScaleFactor(Integer.parseInt(selectedItem.toString().replace("x", "")));
        }
        this.controller.setTransparentBackground(this.transparentBackgroundCheckbox.isSelected());
    }

    private void initComponents() {
        this.imagePanel = new JPanel();
        this.labelScaleFactor = new JLabel();
        this.scaleFactorCombo = new JComboBox();
        this.transparentBackgroundCheckbox = new JCheckBox();
        this.labelCustomScaleFactor = new JLabel();
        this.customScaleFactorSpinner = new JSpinner();
        this.labelWidth = new JLabel();
        this.widthLabel = new JLabel();
        this.labelHeight = new JLabel();
        this.heightLabel = new JLabel();
        this.autoSaveCheckBox = new JCheckBox();
        this.selectDirectoryButton = new JButton();
        this.imagePanel.setBorder(BorderFactory.createEtchedBorder());
        this.labelScaleFactor.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.labelScaleFactor.text"));
        this.transparentBackgroundCheckbox.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.transparentBackgroundCheckbox.text"));
        this.labelCustomScaleFactor.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.labelCustomScaleFactor.text"));
        this.customScaleFactorSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.labelWidth.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.labelWidth.text"));
        this.widthLabel.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.widthLabel.text"));
        this.labelHeight.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.labelHeight.text"));
        this.heightLabel.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.heightLabel.text"));
        GroupLayout imagePanelLayout = new GroupLayout(this.imagePanel);
        this.imagePanel.setLayout(imagePanelLayout);
        imagePanelLayout.setHorizontalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagePanelLayout.createSequentialGroup().addContainerGap().addGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.transparentBackgroundCheckbox, -2, 0, Short.MAX_VALUE).addGroup(imagePanelLayout.createSequentialGroup().addGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagePanelLayout.createSequentialGroup().addComponent(this.labelScaleFactor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scaleFactorCombo, -2, -1, -2)).addGroup(imagePanelLayout.createSequentialGroup().addComponent(this.labelCustomScaleFactor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customScaleFactorSpinner, -2, -1, -2)).addGroup(imagePanelLayout.createSequentialGroup().addComponent(this.labelWidth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.widthLabel).addGap(32, 32, 32).addComponent(this.labelHeight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.heightLabel))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        imagePanelLayout.setVerticalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagePanelLayout.createSequentialGroup().addContainerGap().addGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelScaleFactor).addComponent(this.scaleFactorCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelCustomScaleFactor).addComponent(this.customScaleFactorSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelWidth).addComponent(this.heightLabel).addComponent(this.widthLabel).addComponent(this.labelHeight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addComponent(this.transparentBackgroundCheckbox).addContainerGap()));
        this.autoSaveCheckBox.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.autoSaveCheckBox.text"));
        this.selectDirectoryButton.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.selectDirectoryButton.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imagePanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.autoSaveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectDirectoryButton, -2, 1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.imagePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 36, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoSaveCheckBox).addComponent(this.selectDirectoryButton, -2, 23, -2)).addContainerGap()));
    }
}

