/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.options;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.gephi.desktop.visualization.options.OpenGLOptionsPanelController;
import org.gephi.visualization.VizConfig;
import org.gephi.visualization.VizController;
import org.gephi.viz.engine.jogl.util.gl.capabilities.GLCapabilitiesSummary;
import org.jdesktop.swingx.JXTitledSeparator;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class OpenGLPanel
extends JPanel {
    private final OpenGLOptionsPanelController controller;
    private int antiAliasing = 0;
    private JComboBox antialisaingCombobox;
    private JCheckBox debugLogs;
    private JCheckBox fpsCheckbox;
    private JXTitledSeparator jXTitledSeparator1;
    private JLabel labelAntialiasing;
    private JLabel labelShow;
    private JTextArea openInfoText;
    private JPanel openglInfoPanel;
    private JButton resetButton;

    OpenGLPanel(OpenGLOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.antialisaingCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OpenGLPanel.this.antiAliasing = OpenGLPanel.this.antialisaingCombobox.getSelectedIndex() > 0 ? (int)Math.pow(2.0, OpenGLPanel.this.antialisaingCombobox.getSelectedIndex()) : 0;
            }
        });
    }

    private void initComponents() {
        this.jXTitledSeparator1 = new JXTitledSeparator();
        this.labelAntialiasing = new JLabel();
        this.antialisaingCombobox = new JComboBox();
        this.labelShow = new JLabel();
        this.fpsCheckbox = new JCheckBox();
        this.resetButton = new JButton();
        this.openglInfoPanel = new JPanel();
        this.openInfoText = new JTextArea();
        this.debugLogs = new JCheckBox();
        this.jXTitledSeparator1.setTitle(NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.jXTitledSeparator1.title"));
        Mnemonics.setLocalizedText((JLabel)this.labelAntialiasing, (String)NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.labelAntialiasing.text"));
        this.antialisaingCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"0x", "2x", "4x", "8x", "16x"}));
        Mnemonics.setLocalizedText((JLabel)this.labelShow, (String)NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.labelShow.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.fpsCheckbox, (String)NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.fpsCheckbox.text"));
        this.fpsCheckbox.setMargin(new Insets(2, 0, 2, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.resetButton, (String)NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.resetButton.text"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenGLPanel.this.resetButtonActionPerformed(evt);
            }
        });
        this.openglInfoPanel.setLayout(new GridBagLayout());
        this.openInfoText.setEditable(false);
        this.openInfoText.setColumns(5);
        this.openInfoText.setFont(new Font("Monospaced", 0, 11));
        this.openInfoText.setRows(3);
        this.openInfoText.setText("Vendor\nModel\nVersion");
        this.openInfoText.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.openglInfoPanel.add((Component)this.openInfoText, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.debugLogs, (String)NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.debugLogs.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.openglInfoPanel.add((Component)this.debugLogs, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jXTitledSeparator1, -1, 679, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resetButton).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelShow, -2, 52, -2).addComponent(this.labelAntialiasing)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.fpsCheckbox)).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.antialisaingCombobox, -2, -1, -2))))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.openglInfoPanel, -2, 209, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.jXTitledSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelAntialiasing).addComponent(this.antialisaingCombobox)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelShow, -1, -1, Short.MAX_VALUE).addComponent(this.fpsCheckbox)).addGap(48, 48, 48)).addGroup(layout.createSequentialGroup().addComponent(this.openglInfoPanel, -2, 86, -2).addGap(18, 18, 18))).addComponent(this.resetButton).addContainerGap()));
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        NbPreferences.forModule(VizConfig.class).remove("VizConfig.antialiasing");
        NbPreferences.forModule(VizConfig.class).remove("VizConfig.showFPS");
        this.load();
    }

    void load() {
        this.antiAliasing = NbPreferences.forModule(VizConfig.class).getInt("VizConfig.antialiasing", 4);
        this.antialisaingCombobox.setSelectedIndex(this.antiAliasing == 0 ? 0 : Math.round((float)(Math.log(this.antiAliasing) / Math.log(2.0))));
        this.fpsCheckbox.setSelected(NbPreferences.forModule(VizConfig.class).getBoolean("VizConfig.showFPS", false));
        this.debugLogs.setSelected(NbPreferences.forModule(VizConfig.class).getBoolean("VizConfig.engineOpenGLDebug", false));
        VizController vizController = (VizController)Lookup.getDefault().lookup(VizController.class);
        vizController.getEngine().ifPresent(engine -> {
            GLCapabilitiesSummary summary = engine.getOpenGLOptions().getGlCapabilitiesSummary();
            String vendor = summary.getVendor();
            String renderer = summary.getRenderer();
            String version = summary.getVersionString();
            String shaderVersion = summary.getShadingLanguageVersion();
            this.openInfoText.setText(vendor + "\n" + renderer + "\nOpenGL " + version + "\nGLSL " + shaderVersion);
        });
    }

    void store() {
        NbPreferences.forModule(VizConfig.class).putInt("VizConfig.antialiasing", this.antiAliasing);
        NbPreferences.forModule(VizConfig.class).putBoolean("VizConfig.showFPS", this.fpsCheckbox.isSelected());
        NbPreferences.forModule(VizConfig.class).putBoolean("VizConfig.engineOpenGLDebug", this.debugLogs.isSelected());
        NotificationDisplayer.getDefault().notify(NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.restart.title"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/core/windows/resources/restart.png", (boolean)false), NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.restart.message"), e -> {
            LifecycleManager.getDefault().markForRestart();
            LifecycleManager.getDefault().exit();
        }, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.INFO);
    }

    boolean valid() {
        return true;
    }
}

