/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.options;

import com.connectina.swing.fontchooser.JFontChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import net.java.dev.colorchooser.ColorChooser;
import org.gephi.desktop.visualization.options.DefaultOptionsPanelController;
import org.gephi.ui.utils.ColorUtils;
import org.gephi.ui.utils.FontUtils;
import org.gephi.visualization.VizConfig;
import org.jdesktop.swingx.JXTitledSeparator;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

final class DefaultPanel
extends JPanel {
    private final DefaultOptionsPanelController controller;
    private Font nodeFont;
    private Font edgeFont;
    private JCheckBox autoSelectNeighborCheckbox;
    private ColorChooser backgroundColor;
    private JButton edgeFontButton;
    private JCheckBox highlightCheckbox;
    private JLabel labelBackground;
    private JLabel labelBackgroundColor;
    private JPanel labelBackgroundPanel;
    private JLabel labelDefaultSettings;
    private JLabel labelEdgeFont;
    private JLabel labelFont;
    private JLabel labelNodeFont;
    private JButton nodeFontButton;
    private JButton resetButton;
    private JXTitledSeparator titleDesign;
    private JXTitledSeparator titleLabel;

    DefaultPanel(DefaultOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.nodeFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = JFontChooser.showDialog((Window)WindowManager.getDefault().getMainWindow(), (Font)DefaultPanel.this.nodeFont);
                if (font != null) {
                    DefaultPanel.this.nodeFont = font;
                    DefaultPanel.this.nodeFontButton.setText(DefaultPanel.this.nodeFont.getFontName() + ", " + DefaultPanel.this.nodeFont.getSize());
                }
            }
        });
        this.edgeFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = JFontChooser.showDialog((Window)WindowManager.getDefault().getMainWindow(), (Font)DefaultPanel.this.edgeFont);
                if (font != null) {
                    DefaultPanel.this.edgeFont = font;
                    DefaultPanel.this.edgeFontButton.setText(DefaultPanel.this.edgeFont.getFontName() + ", " + DefaultPanel.this.edgeFont.getSize());
                }
            }
        });
    }

    private void initComponents() {
        this.titleDesign = new JXTitledSeparator();
        this.titleLabel = new JXTitledSeparator();
        this.labelDefaultSettings = new JLabel();
        this.autoSelectNeighborCheckbox = new JCheckBox();
        this.highlightCheckbox = new JCheckBox();
        this.labelFont = new JLabel();
        this.nodeFontButton = new JButton();
        this.labelNodeFont = new JLabel();
        this.labelEdgeFont = new JLabel();
        this.edgeFontButton = new JButton();
        this.labelBackground = new JLabel();
        this.labelBackgroundPanel = new JPanel();
        this.backgroundColor = new ColorChooser();
        this.labelBackgroundColor = new JLabel();
        this.resetButton = new JButton();
        this.titleDesign.setTitle(NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.titleDesign.title"));
        this.titleLabel.setTitle(NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.titleLabel.title"));
        Mnemonics.setLocalizedText((JLabel)this.labelDefaultSettings, (String)NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.labelDefaultSettings.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoSelectNeighborCheckbox, (String)NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.autoSelectNeighborCheckbox.text"));
        this.autoSelectNeighborCheckbox.setMargin(new Insets(2, 0, 2, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.highlightCheckbox, (String)NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.highlightCheckbox.text"));
        this.highlightCheckbox.setMargin(new Insets(2, 0, 2, 2));
        Mnemonics.setLocalizedText((JLabel)this.labelFont, (String)NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.labelFont.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.nodeFontButton, (String)NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.nodeFontButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelNodeFont, (String)NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.labelNodeFont.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelEdgeFont, (String)NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.labelEdgeFont.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.edgeFontButton, (String)NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.edgeFontButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelBackground, (String)NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.labelBackground.text"));
        this.labelBackgroundPanel.setLayout(new FlowLayout(0, 3, 5));
        this.backgroundColor.setPreferredSize(new Dimension(12, 12));
        GroupLayout backgroundColorLayout = new GroupLayout((Container)this.backgroundColor);
        this.backgroundColor.setLayout((LayoutManager)backgroundColorLayout);
        backgroundColorLayout.setHorizontalGroup(backgroundColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        backgroundColorLayout.setVerticalGroup(backgroundColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.labelBackgroundPanel.add((Component)this.backgroundColor);
        this.labelBackgroundColor.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.labelBackgroundColor, (String)NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.labelBackgroundColor.text"));
        this.labelBackgroundColor.setMaximumSize(new Dimension(141, 15));
        this.labelBackgroundColor.setMinimumSize(new Dimension(141, 15));
        this.labelBackgroundColor.setPreferredSize(new Dimension(141, 14));
        this.labelBackgroundPanel.add(this.labelBackgroundColor);
        Mnemonics.setLocalizedText((AbstractButton)this.resetButton, (String)NbBundle.getMessage(DefaultPanel.class, (String)"DefaultPanel.resetButton.text"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultPanel.this.resetButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.labelFont, -2, 34, -2).addGap(65, 65, 65).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nodeFontButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelNodeFont)).addGroup(layout.createSequentialGroup().addComponent(this.edgeFontButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelEdgeFont))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.titleDesign, GroupLayout.Alignment.TRAILING, -1, 475, Short.MAX_VALUE).addComponent((Component)this.titleLabel, -1, 475, Short.MAX_VALUE).addComponent(this.resetButton).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.labelBackground).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelBackgroundPanel, -1, -1, Short.MAX_VALUE).addGap(9, 9, 9)).addGroup(layout.createSequentialGroup().addComponent(this.labelDefaultSettings).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoSelectNeighborCheckbox).addComponent(this.highlightCheckbox, -2, 162, -2)).addGap(6, 6, 6))))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleDesign, -2, -1, -2).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoSelectNeighborCheckbox).addComponent(this.labelDefaultSettings)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highlightCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelBackground).addComponent(this.labelBackgroundPanel, -2, 19, -2)).addGap(18, 18, 18).addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelFont).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nodeFontButton).addComponent(this.labelNodeFont)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.edgeFontButton).addComponent(this.labelEdgeFont)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 69, Short.MAX_VALUE).addComponent(this.resetButton).addContainerGap()));
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        NbPreferences.forModule(VizConfig.class).remove("VizConfig.defaultLightenNonSelectedAuto");
        NbPreferences.forModule(VizConfig.class).remove("VizConfig.defaultAutoSelectNeighbor");
        NbPreferences.forModule(VizConfig.class).remove("VizConfig.defaultBackgroundColor");
        NbPreferences.forModule(VizConfig.class).remove("VizConfig.defaultNodeLabelFont");
        NbPreferences.forModule(VizConfig.class).remove("VizConfig.defaultEdgeLabelFont");
        this.load();
    }

    void load() {
        this.highlightCheckbox.setSelected(NbPreferences.forModule(VizConfig.class).getBoolean("VizConfig.defaultLightenNonSelectedAuto", true));
        this.autoSelectNeighborCheckbox.setSelected(NbPreferences.forModule(VizConfig.class).getBoolean("VizConfig.defaultAutoSelectNeighbor", true));
        this.backgroundColor.setColor(ColorUtils.decode((String)NbPreferences.forModule(VizConfig.class).get("VizConfig.defaultBackgroundColor", ColorUtils.encode((Color)VizConfig.DEFAULT_BACKGROUND_COLOR))));
        this.nodeFont = Font.decode(NbPreferences.forModule(VizConfig.class).get("VizConfig.defaultNodeLabelFont", FontUtils.encode((Font)VizConfig.DEFAULT_NODE_LABEL_FONT)));
        this.nodeFontButton.setText(this.nodeFont.getFontName() + ", " + this.nodeFont.getSize());
        this.edgeFont = Font.decode(NbPreferences.forModule(VizConfig.class).get("VizConfig.defaultEdgeLabelFont", FontUtils.encode((Font)VizConfig.DEFAULT_EDGE_LABEL_FONT)));
        this.edgeFontButton.setText(this.edgeFont.getFontName() + ", " + this.edgeFont.getSize());
    }

    void store() {
        NbPreferences.forModule(VizConfig.class).putBoolean("VizConfig.defaultLightenNonSelectedAuto", this.highlightCheckbox.isSelected());
        NbPreferences.forModule(VizConfig.class).putBoolean("VizConfig.defaultAutoSelectNeighbor", this.autoSelectNeighborCheckbox.isSelected());
        NbPreferences.forModule(VizConfig.class).put("VizConfig.defaultBackgroundColor", ColorUtils.encode((Color)this.backgroundColor.getColor()));
        NbPreferences.forModule(VizConfig.class).put("VizConfig.defaultNodeLabelFont", FontUtils.encode((Font)this.nodeFont));
        NbPreferences.forModule(VizConfig.class).put("VizConfig.defaultEdgeLabelFont", FontUtils.encode((Font)this.edgeFont));
    }

    boolean valid() {
        return true;
    }
}

