/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.collapse;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.gephi.desktop.visualization.collapse.CollapseGroup;
import org.gephi.ui.utils.UIUtils;

public class VizToolbar
extends JToolBar {
    public VizToolbar(CollapseGroup[] groups) {
        this.initDesign();
        for (CollapseGroup g : groups) {
            if (g.drawSeparator()) {
                this.addSeparator();
            }
            if (!g.hasToolbar()) continue;
            for (JComponent c : g.getToolbarComponents()) {
                this.add(c);
            }
        }
    }

    private void initDesign() {
        this.setFloatable(false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 4, 0));
        this.setOpaque(true);
    }

    public void setEnable(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : VizToolbar.this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        });
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof JButton) {
            UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
        }
        return super.add(comp);
    }
}

