/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.collapse;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NodeSettingsPanel
extends JPanel
implements VisualizationPropertyChangeListener {
    private final VisualizationController vizController;
    private JLabel labelScale;
    private JPanel scalePanel;
    private JSlider scaleSlider;
    private JCheckBox showNodesCheckbox;

    public NodeSettingsPanel() {
        this.initComponents();
        this.vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        this.scaleSlider.addChangeListener(e -> this.vizController.setNodeScale((float)this.scaleSlider.getValue() / 10.0f + 0.1f));
    }

    public void setup(VisualizationModel model) {
        if (model == null) {
            this.setEnable(false);
            return;
        }
        this.refreshSharedConfig(model);
        this.setEnable(true);
        this.vizController.addPropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    public void unsetup(VisualizationModel model) {
        this.vizController.removePropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    public void propertyChange(VisualizationModel model, PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("nodeScale")) {
            this.refreshSharedConfig(model);
        }
    }

    private void refreshSharedConfig(VisualizationModel vizModel) {
        if ((float)this.scaleSlider.getValue() / 10.0f + 0.1f != vizModel.getNodeScale()) {
            this.scaleSlider.setValue((int)((vizModel.getNodeScale() - 0.1f) * 10.0f));
        }
    }

    private void setEnable(boolean enable) {
        this.scaleSlider.setEnabled(enable && this.showNodesCheckbox.isSelected());
        this.labelScale.setEnabled(enable && this.showNodesCheckbox.isSelected());
    }

    private void initComponents() {
        this.showNodesCheckbox = new JCheckBox();
        this.scalePanel = new JPanel();
        this.labelScale = new JLabel();
        this.scaleSlider = new JSlider();
        this.showNodesCheckbox.setFont(new Font("Tahoma", 1, 11));
        this.showNodesCheckbox.setSelected(true);
        this.showNodesCheckbox.setText(NbBundle.getMessage(NodeSettingsPanel.class, (String)"NodeSettingsPanel.showNodesCheckbox.text"));
        this.showNodesCheckbox.setEnabled(false);
        this.scalePanel.setOpaque(false);
        this.scalePanel.setLayout(new GridBagLayout());
        this.labelScale.setText(NbBundle.getMessage(NodeSettingsPanel.class, (String)"NodeSettingsPanel.labelScale.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 2, 0);
        this.scalePanel.add((Component)this.labelScale, gridBagConstraints);
        this.scaleSlider.setMinimum(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.scalePanel.add((Component)this.scaleSlider, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.scalePanel, -2, 205, -2)).addComponent(this.showNodesCheckbox)).addContainerGap(520, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.showNodesCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scalePanel, -1, 61, Short.MAX_VALUE).addGap(7, 7, 7)));
    }
}

