/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.collapse;

import com.connectina.swing.fontchooser.JFontChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.gephi.appearance.spi.TransformerCategory;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.desktop.appearance.AppearanceUIController;
import org.gephi.desktop.visualization.collapse.LabelAttributesPanel;
import org.gephi.ui.appearance.plugin.UniqueLabelColorTransformerUI;
import org.gephi.ui.appearance.plugin.category.DefaultCategory;
import org.gephi.visualization.api.LabelColorMode;
import org.gephi.visualization.api.LabelSizeMode;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class NodeLabelsSettingsPanel
extends JPanel
implements VisualizationPropertyChangeListener {
    private final VisualizationController vizController;
    private JButton attributesButton;
    private JCheckBox avoidOverlap;
    private JToggleButton fitToNodeSizeToggleButton;
    private JCheckBox hideNonSelectedCheckbox;
    private JLabel labelNodeColor;
    private JLabel labelNodeFont;
    private JLabel labelNodeScale;
    private JLabel labelNodeSize;
    private JComboBox<LabelColorMode> nodeColorCombo;
    private JButton nodeFontButton;
    private JComboBox<LabelSizeMode> nodeSizeCombo;
    private JSlider nodeSizeSlider;
    private JXHyperlink selfColorLink;
    private JCheckBox showLabelsCheckbox;

    public NodeLabelsSettingsPanel() {
        this.initComponents();
        this.vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        DefaultComboBoxModel<LabelColorMode> colorModeModel = new DefaultComboBoxModel<LabelColorMode>(LabelColorMode.values());
        this.nodeColorCombo.setModel(colorModeModel);
        this.nodeColorCombo.addActionListener(e -> {
            LabelColorMode selected = (LabelColorMode)this.nodeColorCombo.getSelectedItem();
            if (selected == null) {
                return;
            }
            this.vizController.setNodeLabelColorMode(selected);
            this.selfColorLink.setVisible(selected.equals((Object)LabelColorMode.SELF));
        });
        this.nodeColorCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (!(value instanceof LabelColorMode)) {
                    throw new IllegalArgumentException("Expected LabelColorMode");
                }
                label.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)("NodeLabelColorMode." + ((LabelColorMode)value).name().toLowerCase() + ".name")));
                label.setIcon(ImageUtilities.loadIcon((String)("VisualizationImpl/LabelColorMode_" + ((LabelColorMode)value).name() + ".svg")));
                return this;
            }
        });
        this.selfColorLink.addActionListener(e -> {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("AppearanceTopComponent");
            topComponent.open();
            topComponent.requestActive();
            AppearanceUIController appearanceUIController = (AppearanceUIController)Lookup.getDefault().lookup(AppearanceUIController.class);
            TransformerCategory category = DefaultCategory.LABEL_COLOR;
            appearanceUIController.setSelectedElementClass("nodes");
            appearanceUIController.setSelectedCategory(category);
            UniqueLabelColorTransformerUI transformerUI = (UniqueLabelColorTransformerUI)Lookup.getDefault().lookup(UniqueLabelColorTransformerUI.class);
            appearanceUIController.setSelectedTransformerUI((TransformerUI)transformerUI);
        });
        DefaultComboBoxModel<LabelSizeMode> sizeModeModel = new DefaultComboBoxModel<LabelSizeMode>(LabelSizeMode.values());
        this.nodeSizeCombo.setModel(sizeModeModel);
        this.nodeSizeCombo.addActionListener(e -> this.vizController.setNodeLabelSizeMode((LabelSizeMode)this.nodeSizeCombo.getSelectedItem()));
        this.nodeSizeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (!(value instanceof LabelSizeMode)) {
                    throw new IllegalArgumentException("Expected NodeLabelSizeMode");
                }
                label.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)("LabelSizeMode." + ((LabelSizeMode)value).name().toLowerCase() + ".name")));
                label.setIcon(ImageUtilities.loadIcon((String)("VisualizationImpl/LabelSizeMode_" + ((LabelSizeMode)value).name() + ".svg")));
                return this;
            }
        });
        this.showLabelsCheckbox.addItemListener(e -> {
            this.vizController.setShowNodeLabels(this.showLabelsCheckbox.isSelected());
            this.setEnable(true);
        });
        this.nodeFontButton.addActionListener(e -> {
            VisualizationModel model = this.vizController.getModel();
            Font font = JFontChooser.showDialog((Window)WindowManager.getDefault().getMainWindow(), (Font)model.getNodeLabelFont());
            if (font != null && font != model.getNodeLabelFont()) {
                this.vizController.setNodeLabelFont(font);
            }
        });
        this.nodeSizeSlider.addChangeListener(e -> this.vizController.setNodeLabelScale((float)this.nodeSizeSlider.getValue() / 100.0f));
        this.attributesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizationModel model = NodeLabelsSettingsPanel.this.vizController.getModel();
                LabelAttributesPanel panel = new LabelAttributesPanel(model, false);
                panel.setup();
                DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"LabelAttributesPanel.title"), true, 2, null, null);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(NotifyDescriptor.OK_OPTION)) {
                    panel.unsetup();
                }
            }
        });
        this.attributesButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/configureLabels.svg", (boolean)false));
        this.hideNonSelectedCheckbox.addActionListener(e -> this.vizController.setHideNonSelectedNodeLabels(this.hideNonSelectedCheckbox.isSelected()));
        this.fitToNodeSizeToggleButton.addActionListener(e -> this.vizController.setNodeLabelFitToNodeSize(this.fitToNodeSizeToggleButton.isSelected()));
        this.fitToNodeSizeToggleButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/fitToNodeSize.svg", (boolean)false));
        this.fitToNodeSizeToggleButton.setToolTipText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.fitToNodeSizeToggleButton.toolTipText"));
        this.avoidOverlap.addActionListener(e -> this.vizController.setAvoidNodeLabelOverlap(this.avoidOverlap.isSelected()));
    }

    public void setup(VisualizationModel model) {
        if (model == null) {
            this.setEnable(false);
            return;
        }
        this.refreshSharedConfig(model);
        this.setEnable(true);
        this.vizController.addPropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    public void unsetup(VisualizationModel model) {
        this.vizController.removePropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    public void propertyChange(VisualizationModel model, PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showNodeLabels")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("nodeLabelFont")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("nodeLabelColor")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("nodeLabelScale")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("hideNonSelectedNodeLabels")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("nodeLabelSizeMode")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("nodeLabelColorMode")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("nodeLabelFitToNodeSize")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("avoidNodeLabelOverlap")) {
            this.refreshSharedConfig(model);
        }
    }

    private void refreshSharedConfig(VisualizationModel vizModel) {
        if (this.showLabelsCheckbox.isSelected() != vizModel.isShowNodeLabels()) {
            this.showLabelsCheckbox.setSelected(vizModel.isShowNodeLabels());
        }
        if (this.nodeColorCombo.getSelectedItem() != vizModel.getNodeLabelColorMode()) {
            this.nodeColorCombo.setSelectedItem(vizModel.getNodeLabelColorMode());
        }
        if (this.nodeSizeCombo.getSelectedItem() != vizModel.getNodeLabelSizeMode()) {
            this.nodeSizeCombo.setSelectedItem(vizModel.getNodeLabelSizeMode());
        }
        this.nodeFontButton.setText(vizModel.getNodeLabelFont().getFontName() + ", " + vizModel.getNodeLabelFont().getSize());
        if ((float)this.nodeSizeSlider.getValue() / 100.0f != vizModel.getNodeLabelScale()) {
            this.nodeSizeSlider.setValue((int)(vizModel.getNodeLabelScale() * 100.0f));
        }
        if (this.hideNonSelectedCheckbox.isSelected() != vizModel.isHideNonSelectedNodeLabels()) {
            this.hideNonSelectedCheckbox.setSelected(vizModel.isHideNonSelectedNodeLabels());
        }
        if (this.fitToNodeSizeToggleButton.isSelected() != vizModel.isNodeLabelFitToNodeSize()) {
            this.fitToNodeSizeToggleButton.setSelected(vizModel.isNodeLabelFitToNodeSize());
        }
        if (this.avoidOverlap.isSelected() != vizModel.isAvoidNodeLabelOverlap()) {
            this.avoidOverlap.setSelected(vizModel.isAvoidNodeLabelOverlap());
        }
        this.selfColorLink.setVisible(this.nodeColorCombo.getSelectedItem() == LabelColorMode.SELF);
    }

    private void setEnable(boolean enable) {
        this.showLabelsCheckbox.setEnabled(enable);
        this.nodeColorCombo.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.labelNodeColor.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.nodeFontButton.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.labelNodeFont.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.nodeSizeSlider.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.labelNodeScale.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.nodeSizeCombo.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.labelNodeSize.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.fitToNodeSizeToggleButton.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.hideNonSelectedCheckbox.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.avoidOverlap.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.attributesButton.setEnabled(enable && this.showLabelsCheckbox.isSelected());
        this.selfColorLink.setEnabled(enable && this.showLabelsCheckbox.isSelected());
    }

    private void initComponents() {
        this.showLabelsCheckbox = new JCheckBox();
        this.labelNodeColor = new JLabel();
        this.nodeColorCombo = new JComboBox();
        this.labelNodeFont = new JLabel();
        this.nodeFontButton = new JButton();
        this.labelNodeScale = new JLabel();
        this.nodeSizeSlider = new JSlider();
        this.labelNodeSize = new JLabel();
        this.nodeSizeCombo = new JComboBox();
        this.fitToNodeSizeToggleButton = new JToggleButton();
        this.hideNonSelectedCheckbox = new JCheckBox();
        this.attributesButton = new JButton();
        this.selfColorLink = new JXHyperlink();
        this.avoidOverlap = new JCheckBox();
        this.showLabelsCheckbox.setFont(new Font("Tahoma", 1, 11));
        this.showLabelsCheckbox.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.showLabelsCheckbox.text"));
        this.labelNodeColor.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.labelNodeColor.text"));
        this.labelNodeFont.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.labelNodeFont.text"));
        this.labelNodeFont.setMaximumSize(new Dimension(60, 15));
        this.nodeFontButton.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.nodeFontButton.text"));
        this.labelNodeScale.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.labelNodeScale.text"));
        this.nodeSizeSlider.setMinimum(1);
        this.labelNodeSize.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.labelNodeSize.text"));
        this.fitToNodeSizeToggleButton.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.fitToNodeSizeToggleButton.text"));
        this.hideNonSelectedCheckbox.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.hideNonSelectedCheckbox.text"));
        this.hideNonSelectedCheckbox.setBorder(null);
        this.hideNonSelectedCheckbox.setHorizontalTextPosition(2);
        this.hideNonSelectedCheckbox.setMargin(new Insets(2, 0, 2, 2));
        this.attributesButton.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.attributesButton.text"));
        this.selfColorLink.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.selfColorLink.text"));
        this.avoidOverlap.setText(NbBundle.getMessage(NodeLabelsSettingsPanel.class, (String)"NodeLabelsSettingsPanel.avoidOverlap.text"));
        this.avoidOverlap.setHorizontalTextPosition(2);
        this.avoidOverlap.setMargin(new Insets(2, 0, 2, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelNodeColor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeColorCombo, -2, 145, -2)).addGroup(layout.createSequentialGroup().addComponent(this.labelNodeSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.nodeSizeCombo, -2, 145, -2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.fitToNodeSizeToggleButton)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.selfColorLink, -2, 31, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.labelNodeFont, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeFontButton, -1, -1, Short.MAX_VALUE)).addComponent(this.hideNonSelectedCheckbox)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.labelNodeScale).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeSizeSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attributesButton, -2, 125, -2)).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.avoidOverlap)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.showLabelsCheckbox))).addContainerGap(99, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.showLabelsCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelNodeColor).addComponent(this.nodeColorCombo, -2, -1, -2).addComponent(this.labelNodeFont, -2, -1, -2).addComponent(this.nodeFontButton).addComponent(this.labelNodeScale).addComponent(this.nodeSizeSlider, -2, -1, -2).addComponent((Component)this.selfColorLink, -2, -1, -2).addComponent(this.attributesButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelNodeSize).addComponent(this.nodeSizeCombo, -2, -1, -2).addComponent(this.fitToNodeSizeToggleButton).addComponent(this.hideNonSelectedCheckbox).addComponent(this.avoidOverlap)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

