/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.collapse;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import org.gephi.desktop.visualization.collapse.CollapseGroup;
import org.gephi.desktop.visualization.collapse.NodeSettingsPanel;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NodeGroup
implements CollapseGroup,
VisualizationPropertyChangeListener {
    private final VisualizationController vizController;
    private final NodeSettingsPanel nodeSettingsPanel = new NodeSettingsPanel();
    private final JSlider nodeScaleSlider;
    private final JLabel titleLabel;

    public NodeGroup() {
        this.vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        this.titleLabel = new JLabel(NbBundle.getMessage(NodeGroup.class, (String)"VizToolbar.Nodes.groupLabel"));
        this.nodeScaleSlider = new JSlider(1, 100, 1);
        this.nodeScaleSlider.setToolTipText(NbBundle.getMessage(NodeGroup.class, (String)"VizToolbar.Nodes.nodeScale"));
        this.nodeScaleSlider.addChangeListener(e -> {
            float value = (float)this.nodeScaleSlider.getValue() / 10.0f + 0.1f;
            this.vizController.setNodeScale(value);
        });
        this.nodeScaleSlider.setPreferredSize(new Dimension(100, 20));
        this.nodeScaleSlider.setMaximumSize(new Dimension(100, 20));
    }

    @Override
    public void setup(VizModel vizModel) {
        this.nodeSettingsPanel.setup(vizModel);
        this.titleLabel.setEnabled(true);
        this.nodeScaleSlider.setEnabled(true);
        this.nodeScaleSlider.setValue((int)((vizModel.getNodeScale() - 0.1f) * 10.0f));
        this.vizController.addPropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    @Override
    public void unsetup(VizModel vizModel) {
        this.nodeSettingsPanel.unsetup(vizModel);
        this.vizController.removePropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    @Override
    public void disable() {
        this.nodeSettingsPanel.setup(null);
        this.nodeScaleSlider.setEnabled(false);
        this.titleLabel.setEnabled(false);
    }

    public void propertyChange(VisualizationModel model, PropertyChangeEvent evt) {
        if ("nodeScale".equals(evt.getPropertyName()) && model.getNodeScale() != (float)this.nodeScaleSlider.getValue() / 10.0f + 0.1f) {
            this.nodeScaleSlider.setValue((int)((model.getNodeScale() - 0.1f) * 10.0f));
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(NodeGroup.class, (String)"VizToolbar.Nodes.groupBarTitle");
    }

    @Override
    public JComponent[] getToolbarComponents() {
        return new JComponent[]{this.titleLabel, this.nodeScaleSlider};
    }

    @Override
    public JComponent getExtendedComponent() {
        return this.nodeSettingsPanel;
    }

    @Override
    public boolean hasToolbar() {
        return true;
    }

    @Override
    public boolean hasExtended() {
        return true;
    }
}

