/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.collapse;

import java.awt.Color;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.gephi.ui.components.JColorButton;
import org.gephi.visualization.VizController;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GlobalSettingsPanel
extends JPanel
implements VisualizationPropertyChangeListener {
    private final VisualizationController vizController;
    private JCheckBox autoSelectNeigborCheckbox;
    private JButton backgroundColorButton;
    private JCheckBox hightlightCheckBox;
    private JLabel labelBackgroundColor;

    public GlobalSettingsPanel() {
        this.initComponents();
        this.vizController = (VisualizationController)Lookup.getDefault().lookup(VizController.class);
        this.hightlightCheckBox.addItemListener(e -> this.vizController.setLightenNonSelectedAuto(this.hightlightCheckBox.isSelected()));
        this.backgroundColorButton.addPropertyChangeListener(JColorButton.EVENT_COLOR, evt -> this.vizController.setBackgroundColor(((JColorButton)this.backgroundColorButton).getColor()));
        this.autoSelectNeigborCheckbox.addItemListener(e -> this.vizController.setAutoSelectNeighbors(this.autoSelectNeigborCheckbox.isSelected()));
    }

    public void propertyChange(VisualizationModel model, PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("backgroundColor")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("autoSelectNeighbor")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("lightenNonSelectedAuto")) {
            this.refreshSharedConfig(model);
        }
    }

    public void setup(VisualizationModel model) {
        if (model == null) {
            this.setEnable(false);
            return;
        }
        this.refreshSharedConfig(model);
        this.setEnable(true);
        this.vizController.addPropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    public void unsetup(VisualizationModel model) {
        this.vizController.removePropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    private void refreshSharedConfig(VisualizationModel vizModel) {
        if (this.autoSelectNeigborCheckbox.isSelected() != vizModel.isAutoSelectNeighbors()) {
            this.autoSelectNeigborCheckbox.setSelected(vizModel.isAutoSelectNeighbors());
        }
        ((JColorButton)this.backgroundColorButton).setColor(vizModel.getBackgroundColor());
        if (this.hightlightCheckBox.isSelected() != vizModel.isLightenNonSelectedAuto()) {
            this.hightlightCheckBox.setSelected(vizModel.isLightenNonSelectedAuto());
        }
    }

    private void setEnable(boolean enable) {
        this.autoSelectNeigborCheckbox.setEnabled(enable);
        this.backgroundColorButton.setEnabled(enable);
        this.hightlightCheckBox.setEnabled(enable);
        this.labelBackgroundColor.setEnabled(enable);
    }

    private void initComponents() {
        this.labelBackgroundColor = new JLabel();
        this.backgroundColorButton = new JColorButton(Color.DARK_GRAY);
        this.hightlightCheckBox = new JCheckBox();
        this.autoSelectNeigborCheckbox = new JCheckBox();
        this.labelBackgroundColor.setText(NbBundle.getMessage(GlobalSettingsPanel.class, (String)"GlobalSettingsPanel.labelBackgroundColor.text"));
        this.backgroundColorButton.setText(NbBundle.getMessage(GlobalSettingsPanel.class, (String)"GlobalSettingsPanel.backgroundColorButton.text"));
        this.hightlightCheckBox.setText(NbBundle.getMessage(GlobalSettingsPanel.class, (String)"GlobalSettingsPanel.hightlightCheckBox.text"));
        this.hightlightCheckBox.setBorder(null);
        this.hightlightCheckBox.setHorizontalTextPosition(2);
        this.hightlightCheckBox.setMargin(new Insets(2, 0, 2, 2));
        this.autoSelectNeigborCheckbox.setText(NbBundle.getMessage(GlobalSettingsPanel.class, (String)"GlobalSettingsPanel.autoSelectNeigborCheckbox.text"));
        this.autoSelectNeigborCheckbox.setBorder(null);
        this.autoSelectNeigborCheckbox.setHorizontalTextPosition(2);
        this.autoSelectNeigborCheckbox.setMargin(new Insets(2, 0, 2, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoSelectNeigborCheckbox).addGroup(layout.createSequentialGroup().addComponent(this.labelBackgroundColor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backgroundColorButton, -2, 24, -2).addGap(18, 18, 18).addComponent(this.hightlightCheckBox))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelBackgroundColor, GroupLayout.Alignment.LEADING, -2, 24, -2).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.backgroundColorButton, -2, 24, -2).addComponent(this.hightlightCheckBox, -2, 25, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoSelectNeigborCheckbox, -2, 26, -2).addContainerGap()));
    }
}

