/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.collapse;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.gephi.desktop.visualization.collapse.CollapseGroup;
import org.gephi.desktop.visualization.collapse.GlobalSettingsPanel;
import org.gephi.ui.components.JColorBlackWhiteSwitcher;
import org.gephi.ui.components.JColorButton;
import org.gephi.ui.components.JDropDownButton;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.VizConfig;
import org.gephi.visualization.VizController;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class GlobalGroup
implements CollapseGroup,
VisualizationPropertyChangeListener {
    private final JColorBlackWhiteSwitcher backgroundColorButton;
    private final JDropDownButton screenshotButton;
    private final GlobalSettingsPanel globalSettingsPanel = new GlobalSettingsPanel();
    private final VizController vizController;

    public GlobalGroup(final VizController vizController) {
        this.vizController = vizController;
        this.backgroundColorButton = new JColorBlackWhiteSwitcher(UIUtils.isDarkLookAndFeel() ? VizConfig.DEFAULT_DARK_BACKGROUND_COLOR : VizConfig.DEFAULT_BACKGROUND_COLOR);
        this.backgroundColorButton.setLightColor(VizConfig.DEFAULT_BACKGROUND_COLOR);
        this.backgroundColorButton.setDarkColor(VizConfig.DEFAULT_DARK_BACKGROUND_COLOR);
        this.backgroundColorButton.setToolTipText(NbBundle.getMessage(GlobalGroup.class, (String)"VizToolbar.Global.background"));
        this.backgroundColorButton.addPropertyChangeListener(JColorButton.EVENT_COLOR, evt -> vizController.setBackgroundColor(this.backgroundColorButton.getColor()));
        JPopupMenu screenshotPopup = new JPopupMenu();
        JMenuItem configureScreenshotItem = new JMenuItem(NbBundle.getMessage(GlobalGroup.class, (String)"VizToolbar.Global.screenshot.configure"));
        configureScreenshotItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                vizController.getScreenshotController().configure();
            }
        });
        screenshotPopup.add(configureScreenshotItem);
        this.screenshotButton = new JDropDownButton((Icon)ImageUtilities.loadImageIcon((String)"VisualizationImpl/screenshot.svg", (boolean)false), screenshotPopup);
        this.screenshotButton.setToolTipText(NbBundle.getMessage(GlobalGroup.class, (String)"VizToolbar.Global.screenshot"));
        this.screenshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                vizController.getScreenshotController().takeScreenshot();
            }
        });
    }

    public void propertyChange(VisualizationModel vizModel, PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("backgroundColor")) {
            this.backgroundColorButton.setColor(vizModel.getBackgroundColor());
        }
    }

    @Override
    public void setup(VizModel vizModel) {
        for (JComponent component : this.getToolbarComponents()) {
            component.setEnabled(true);
        }
        this.backgroundColorButton.setColor(vizModel.getBackgroundColor());
        this.globalSettingsPanel.setup(vizModel);
        this.vizController.addPropertyChangeListener(this);
    }

    @Override
    public void unsetup(VizModel vizModel) {
        this.vizController.removePropertyChangeListener(this);
        this.globalSettingsPanel.unsetup(vizModel);
    }

    @Override
    public void disable() {
        this.globalSettingsPanel.setup(null);
        for (JComponent component : this.getToolbarComponents()) {
            component.setEnabled(false);
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(GlobalGroup.class, (String)"VizToolbar.Global.groupBarTitle");
    }

    @Override
    public JComponent[] getToolbarComponents() {
        return new JComponent[]{this.backgroundColorButton, this.screenshotButton};
    }

    @Override
    public JComponent getExtendedComponent() {
        return this.globalSettingsPanel;
    }

    @Override
    public boolean hasToolbar() {
        return true;
    }

    @Override
    public boolean hasExtended() {
        return true;
    }

    @Override
    public boolean drawSeparator() {
        return false;
    }
}

