/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.visualization.collapse;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import net.java.dev.colorchooser.ColorChooser;
import org.gephi.appearance.spi.TransformerCategory;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.desktop.appearance.AppearanceUIController;
import org.gephi.graph.api.Estimator;
import org.gephi.ui.appearance.plugin.UniqueElementColorTransformerUI;
import org.gephi.ui.appearance.plugin.category.DefaultCategory;
import org.gephi.visualization.api.EdgeColorMode;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.VisualizationModel;
import org.gephi.visualization.api.VisualizationPropertyChangeListener;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class EdgeSettingsPanel
extends JPanel
implements VisualizationPropertyChangeListener {
    private final VisualizationController vizController;
    private ColorChooser edgeBothSelectionColorChooser;
    private JLabel edgeColor;
    private JComboBox<EdgeColorMode> edgeColorCombo;
    private ColorChooser edgeInSelectionColorChooser;
    private ColorChooser edgeOutSelectionColorChooser;
    private JComboBox<Estimator> edgeWeightEstimatorCombo;
    private JLabel edgeWeightEstimatorLabel;
    private JCheckBox hideNonSelectedCheckbox;
    private JLabel labelBoth;
    private JLabel labelIn;
    private JLabel labelOut;
    private JLabel labelScale;
    private JCheckBox rescaleEdgeWeightCheckbox;
    private JPanel scalePanel;
    private JSlider scaleSlider;
    private JCheckBox selectionColorCheckbox;
    private JPanel selectionColorPanel;
    private JXHyperlink selfColorLink;
    private JCheckBox showEdgesCheckbox;
    private JCheckBox useEdgeWeightCheckbox;

    public EdgeSettingsPanel() {
        this.initComponents();
        this.vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        DefaultComboBoxModel<EdgeColorMode> colorModeModel = new DefaultComboBoxModel<EdgeColorMode>(EdgeColorMode.values());
        this.edgeColorCombo.setModel(colorModeModel);
        this.edgeColorCombo.addActionListener(e -> {
            EdgeColorMode selected = (EdgeColorMode)this.edgeColorCombo.getSelectedItem();
            if (selected == null) {
                return;
            }
            this.vizController.setEdgeColorMode(selected);
            this.selfColorLink.setVisible(selected.equals((Object)EdgeColorMode.SELF));
        });
        this.edgeColorCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (!(value instanceof EdgeColorMode)) {
                    throw new IllegalArgumentException("Expected EdgeColorMode");
                }
                label.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)("EdgeColorMode." + ((EdgeColorMode)value).name().toLowerCase() + ".name")));
                label.setIcon(ImageUtilities.loadIcon((String)("VisualizationImpl/EdgeColorMode_" + ((EdgeColorMode)value).name() + ".svg")));
                return this;
            }
        });
        this.selfColorLink.addActionListener(e -> {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("AppearanceTopComponent");
            topComponent.open();
            topComponent.requestActive();
            AppearanceUIController appearanceUIController = (AppearanceUIController)Lookup.getDefault().lookup(AppearanceUIController.class);
            TransformerCategory category = DefaultCategory.COLOR;
            appearanceUIController.setSelectedElementClass("edges");
            appearanceUIController.setSelectedCategory(category);
            UniqueElementColorTransformerUI transformerUI = (UniqueElementColorTransformerUI)Lookup.getDefault().lookup(UniqueElementColorTransformerUI.class);
            appearanceUIController.setSelectedTransformerUI((TransformerUI)transformerUI);
        });
        this.showEdgesCheckbox.addItemListener(e -> {
            this.vizController.setShowEdges(this.showEdgesCheckbox.isSelected());
            this.setEnable(true, null);
        });
        this.selectionColorCheckbox.addItemListener(e -> {
            this.vizController.setEdgeSelectionColor(this.selectionColorCheckbox.isSelected());
            this.setEnable(true, null);
        });
        this.edgeInSelectionColorChooser.addActionListener(ae -> this.vizController.setEdgeInSelectionColor(this.edgeInSelectionColorChooser.getColor()));
        this.edgeBothSelectionColorChooser.addActionListener(ae -> this.vizController.setEdgeBothSelectionColor(this.edgeBothSelectionColorChooser.getColor()));
        this.edgeOutSelectionColorChooser.addActionListener(ae -> this.vizController.setEdgeOutSelectionColor(this.edgeOutSelectionColorChooser.getColor()));
        this.scaleSlider.addChangeListener(e -> this.vizController.setEdgeScale((float)this.scaleSlider.getValue() / 10.0f + 0.1f));
        this.useEdgeWeightCheckbox.addItemListener(e -> {
            this.vizController.setUseEdgeWeight(this.useEdgeWeightCheckbox.isSelected());
            this.setEnable(true, null);
        });
        this.rescaleEdgeWeightCheckbox.addItemListener(e -> this.vizController.setRescaleEdgeWeight(this.rescaleEdgeWeightCheckbox.isSelected()));
        this.hideNonSelectedCheckbox.addItemListener(e -> this.vizController.setHideNonSelectedEdges(this.hideNonSelectedCheckbox.isSelected()));
        DefaultComboBoxModel<Estimator> estimatorModel = new DefaultComboBoxModel<Estimator>((Estimator[])Arrays.stream(Estimator.values()).filter(e -> !e.is(Estimator.MEDIAN)).toArray(Estimator[]::new));
        this.edgeWeightEstimatorCombo.setModel(estimatorModel);
        this.edgeWeightEstimatorCombo.addActionListener(e -> {
            Estimator selected = (Estimator)this.edgeWeightEstimatorCombo.getSelectedItem();
            if (selected == null) {
                return;
            }
            this.vizController.setEdgeWeightEstimator(selected);
        });
        this.edgeWeightEstimatorCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof Estimator) {
                    label.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)("EdgeWeightEstimator." + ((Estimator)value).name().toLowerCase() + ".name")));
                } else if (value == null) {
                    label.setText("");
                } else {
                    throw new IllegalArgumentException("Expected Estimator");
                }
                return this;
            }
        });
    }

    public void setup(VisualizationModel model) {
        if (model == null) {
            this.setEnable(false, null);
            return;
        }
        this.refreshSharedConfig(model);
        this.setEnable(true, model);
        this.vizController.addPropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    public void unsetup(VisualizationModel model) {
        this.vizController.removePropertyChangeListener((VisualizationPropertyChangeListener)this);
    }

    public void propertyChange(VisualizationModel model, PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showEdges")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("edgeSelectionColor")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("edgeInSelectionColor")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("edgeOutSelectionColor")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("edgeBothSelectionColor")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("edgeScale")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("edgeColorMode")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("useEdgeWeight")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("rescaleEdgeWeight")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("hideNonSelectedEdges")) {
            this.refreshSharedConfig(model);
        } else if (evt.getPropertyName().equals("edgeWeightEstimator")) {
            this.refreshSharedConfig(model);
        }
    }

    private void refreshSharedConfig(VisualizationModel vizModel) {
        if (this.showEdgesCheckbox.isSelected() != vizModel.isShowEdges()) {
            this.showEdgesCheckbox.setSelected(vizModel.isShowEdges());
        }
        if (this.edgeColorCombo.getSelectedItem() != vizModel.getEdgeColorMode()) {
            this.edgeColorCombo.setSelectedItem(vizModel.getEdgeColorMode());
        }
        if (this.selectionColorCheckbox.isSelected() != vizModel.isEdgeSelectionColor()) {
            this.selectionColorCheckbox.setSelected(vizModel.isEdgeSelectionColor());
        }
        Color in = vizModel.getEdgeInSelectionColor();
        Color out = vizModel.getEdgeOutSelectionColor();
        Color both = vizModel.getEdgeBothSelectionColor();
        if (!this.edgeInSelectionColorChooser.getColor().equals(in)) {
            this.edgeInSelectionColorChooser.setColor(in);
        }
        if (!this.edgeBothSelectionColorChooser.getColor().equals(both)) {
            this.edgeBothSelectionColorChooser.setColor(both);
        }
        if (!this.edgeOutSelectionColorChooser.getColor().equals(out)) {
            this.edgeOutSelectionColorChooser.setColor(out);
        }
        if ((float)this.scaleSlider.getValue() / 10.0f + 0.1f != vizModel.getEdgeScale()) {
            this.scaleSlider.setValue((int)((vizModel.getEdgeScale() - 0.1f) * 10.0f));
        }
        if (this.useEdgeWeightCheckbox.isSelected() != vizModel.isUseEdgeWeight()) {
            this.useEdgeWeightCheckbox.setSelected(vizModel.isUseEdgeWeight());
        }
        if (this.rescaleEdgeWeightCheckbox.isSelected() != vizModel.isRescaleEdgeWeight()) {
            this.rescaleEdgeWeightCheckbox.setSelected(vizModel.isRescaleEdgeWeight());
        }
        if (this.hideNonSelectedCheckbox.isSelected() != vizModel.isHideNonSelectedEdges()) {
            this.hideNonSelectedCheckbox.setSelected(vizModel.isHideNonSelectedEdges());
        }
        if (this.edgeWeightEstimatorCombo.getSelectedItem() != vizModel.getEdgeWeightEstimator()) {
            this.edgeWeightEstimatorCombo.setSelectedItem(vizModel.getEdgeWeightEstimator());
        }
    }

    private void setEnable(boolean enable, VisualizationModel model) {
        this.showEdgesCheckbox.setEnabled(enable);
        this.edgeColorCombo.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.edgeColor.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.scaleSlider.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.labelScale.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.selectionColorCheckbox.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.selfColorLink.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.edgeInSelectionColorChooser.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
        this.edgeBothSelectionColorChooser.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
        this.edgeOutSelectionColorChooser.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
        this.labelIn.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
        this.labelOut.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
        this.labelBoth.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.selectionColorCheckbox.isSelected());
        this.useEdgeWeightCheckbox.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.rescaleEdgeWeightCheckbox.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.useEdgeWeightCheckbox.isSelected());
        this.hideNonSelectedCheckbox.setEnabled(enable && this.showEdgesCheckbox.isSelected());
        this.edgeWeightEstimatorCombo.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.useEdgeWeightCheckbox.isSelected() && model != null && model.getEdgeWeightEstimator() != null);
        this.edgeWeightEstimatorLabel.setEnabled(enable && this.showEdgesCheckbox.isSelected() && this.useEdgeWeightCheckbox.isSelected() && model != null && model.getEdgeWeightEstimator() != null);
    }

    private void initComponents() {
        this.showEdgesCheckbox = new JCheckBox();
        this.edgeColor = new JLabel();
        this.selectionColorPanel = new JPanel();
        this.selectionColorCheckbox = new JCheckBox();
        this.edgeInSelectionColorChooser = new ColorChooser();
        this.edgeOutSelectionColorChooser = new ColorChooser();
        this.edgeBothSelectionColorChooser = new ColorChooser();
        this.labelIn = new JLabel();
        this.labelOut = new JLabel();
        this.labelBoth = new JLabel();
        this.scalePanel = new JPanel();
        this.labelScale = new JLabel();
        this.scaleSlider = new JSlider();
        this.useEdgeWeightCheckbox = new JCheckBox();
        this.rescaleEdgeWeightCheckbox = new JCheckBox();
        this.edgeColorCombo = new JComboBox();
        this.hideNonSelectedCheckbox = new JCheckBox();
        this.selfColorLink = new JXHyperlink();
        this.edgeWeightEstimatorLabel = new JLabel();
        this.edgeWeightEstimatorCombo = new JComboBox();
        this.showEdgesCheckbox.setFont(new Font("Tahoma", 1, 11));
        this.showEdgesCheckbox.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.showEdgesCheckbox.text"));
        this.edgeColor.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.edgeColor.text"));
        this.selectionColorPanel.setOpaque(false);
        this.selectionColorPanel.setLayout(new GridBagLayout());
        this.selectionColorCheckbox.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.selectionColorCheckbox.text"));
        this.selectionColorCheckbox.setToolTipText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.selectionColorCheckbox.toolTipText"));
        this.selectionColorCheckbox.setHorizontalAlignment(2);
        this.selectionColorCheckbox.setHorizontalTextPosition(2);
        this.selectionColorCheckbox.setMaximumSize(new Dimension(160, 18));
        this.selectionColorCheckbox.setMinimumSize(new Dimension(160, 18));
        this.selectionColorCheckbox.setPreferredSize(new Dimension(160, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.selectionColorPanel.add((Component)this.selectionColorCheckbox, gridBagConstraints);
        this.edgeInSelectionColorChooser.setMinimumSize(new Dimension(14, 14));
        this.edgeInSelectionColorChooser.setPreferredSize(new Dimension(14, 14));
        this.edgeInSelectionColorChooser.setToolTipText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.edgeInSelectionColorChooser.toolTipText"));
        GroupLayout edgeInSelectionColorChooserLayout = new GroupLayout((Container)this.edgeInSelectionColorChooser);
        this.edgeInSelectionColorChooser.setLayout((LayoutManager)edgeInSelectionColorChooserLayout);
        edgeInSelectionColorChooserLayout.setHorizontalGroup(edgeInSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        edgeInSelectionColorChooserLayout.setVerticalGroup(edgeInSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.selectionColorPanel.add((Component)this.edgeInSelectionColorChooser, gridBagConstraints);
        this.edgeOutSelectionColorChooser.setMinimumSize(new Dimension(14, 14));
        this.edgeOutSelectionColorChooser.setPreferredSize(new Dimension(14, 14));
        this.edgeOutSelectionColorChooser.setToolTipText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.edgeOutSelectionColorChooser.toolTipText"));
        GroupLayout edgeOutSelectionColorChooserLayout = new GroupLayout((Container)this.edgeOutSelectionColorChooser);
        this.edgeOutSelectionColorChooser.setLayout((LayoutManager)edgeOutSelectionColorChooserLayout);
        edgeOutSelectionColorChooserLayout.setHorizontalGroup(edgeOutSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        edgeOutSelectionColorChooserLayout.setVerticalGroup(edgeOutSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.selectionColorPanel.add((Component)this.edgeOutSelectionColorChooser, gridBagConstraints);
        this.edgeBothSelectionColorChooser.setMinimumSize(new Dimension(14, 14));
        this.edgeBothSelectionColorChooser.setPreferredSize(new Dimension(14, 14));
        this.edgeBothSelectionColorChooser.setToolTipText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.edgeBothSelectionColorChooser.toolTipText"));
        GroupLayout edgeBothSelectionColorChooserLayout = new GroupLayout((Container)this.edgeBothSelectionColorChooser);
        this.edgeBothSelectionColorChooser.setLayout((LayoutManager)edgeBothSelectionColorChooserLayout);
        edgeBothSelectionColorChooserLayout.setHorizontalGroup(edgeBothSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        edgeBothSelectionColorChooserLayout.setVerticalGroup(edgeBothSelectionColorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.selectionColorPanel.add((Component)this.edgeBothSelectionColorChooser, gridBagConstraints);
        this.labelIn.setFont(new Font("Tahoma", 0, 10));
        this.labelIn.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.labelIn.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.selectionColorPanel.add((Component)this.labelIn, gridBagConstraints);
        this.labelOut.setFont(new Font("Tahoma", 0, 10));
        this.labelOut.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.labelOut.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 10, 0, 0);
        this.selectionColorPanel.add((Component)this.labelOut, gridBagConstraints);
        this.labelBoth.setFont(new Font("Tahoma", 0, 10));
        this.labelBoth.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.labelBoth.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.selectionColorPanel.add((Component)this.labelBoth, gridBagConstraints);
        this.scalePanel.setOpaque(false);
        this.scalePanel.setLayout(new GridBagLayout());
        this.labelScale.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.labelScale.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 5, 2, 0);
        this.scalePanel.add((Component)this.labelScale, gridBagConstraints);
        this.scaleSlider.setMinimum(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.scalePanel.add((Component)this.scaleSlider, gridBagConstraints);
        this.useEdgeWeightCheckbox.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.useEdgeWeightCheckbox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.scalePanel.add((Component)this.useEdgeWeightCheckbox, gridBagConstraints);
        this.rescaleEdgeWeightCheckbox.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.rescaleEdgeWeightCheckbox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.scalePanel.add((Component)this.rescaleEdgeWeightCheckbox, gridBagConstraints);
        this.hideNonSelectedCheckbox.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.hideNonSelectedCheckbox.text"));
        this.selfColorLink.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.selfColorLink.text"));
        this.edgeWeightEstimatorLabel.setText(NbBundle.getMessage(EdgeSettingsPanel.class, (String)"EdgeSettingsPanel.edgeWeightEstimatorLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.scalePanel, -2, 190, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.edgeColor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgeColorCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.selfColorLink, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.edgeWeightEstimatorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgeWeightEstimatorCombo, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addComponent(this.selectionColorPanel, -2, 176, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideNonSelectedCheckbox)).addGroup(layout.createSequentialGroup().addComponent(this.showEdgesCheckbox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.showEdgesCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.edgeColor).addComponent(this.edgeColorCombo, -2, -1, -2).addComponent((Component)this.selfColorLink, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.edgeWeightEstimatorLabel).addComponent(this.edgeWeightEstimatorCombo, -2, -1, -2))).addComponent(this.scalePanel, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hideNonSelectedCheckbox).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.selectionColorPanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
    }
}

